/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.tracing;

import fleet.util.tracing.MyIntervalMetricReaderBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lfleet/util/tracing/MyIntervalMetricReader;", "", "internalState", "Lfleet/util/tracing/MyIntervalMetricReader$InternalState;", "intervalMetricReader", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lfleet/util/tracing/MyIntervalMetricReader$InternalState;Ljava/util/concurrent/ScheduledExecutorService;)V", "exporter", "Lfleet/util/tracing/MyIntervalMetricReader$Exporter;", "lock", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "scheduler", "flushMetrics", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "shutdown", "start", "Companion", "Exporter", "InternalState", "fleet.util.telemetry"})
public final class MyIntervalMetricReader {
    private final Exporter exporter;
    private final ScheduledExecutorService scheduler;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final Object lock;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final CompletableResultCode flushMetrics() {
        return this.exporter.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableResultCode shutdown() {
        CompletableResultCode result2 = new CompletableResultCode();
        if (this.scheduledFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(false);
        }
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            CompletableResultCode flushResult = this.exporter.doRun();
            flushResult.join(5L, TimeUnit.SECONDS);
            CompletableResultCode shutdownResult = this.exporter.shutdown();
            shutdownResult.whenComplete(new Runnable(shutdownResult, result2){
                final /* synthetic */ CompletableResultCode $shutdownResult;
                final /* synthetic */ CompletableResultCode $result;

                public final void run() {
                    if (!this.$shutdownResult.isSuccess()) {
                        this.$result.fail();
                    } else {
                        this.$result.succeed();
                    }
                }
                {
                    this.$shutdownResult = completableResultCode;
                    this.$result = completableResultCode2;
                }
            });
        }
        catch (InterruptedException e) {
            try {
                this.scheduler.shutdownNow();
                Thread.currentThread().interrupt();
                CompletableResultCode shutdownResult = this.exporter.shutdown();
                shutdownResult.whenComplete(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                CompletableResultCode shutdownResult = this.exporter.shutdown();
                shutdownResult.whenComplete(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final MyIntervalMetricReader start() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            block4: {
                boolean bl3 = false;
                if (this.scheduledFuture == null) break block4;
                MyIntervalMetricReader myIntervalMetricReader = this;
                return myIntervalMetricReader;
            }
            this.scheduledFuture = this.scheduler.scheduleAtFixedRate(this.exporter, this.exporter.getInternalState$fleet_util_telemetry().getExportIntervalMillis(), this.exporter.getInternalState$fleet_util_telemetry().getExportIntervalMillis(), TimeUnit.MILLISECONDS);
            MyIntervalMetricReader myIntervalMetricReader = this;
            return myIntervalMetricReader;
        }
    }

    public MyIntervalMetricReader(@NotNull InternalState internalState, @NotNull ScheduledExecutorService intervalMetricReader) {
        Intrinsics.checkNotNullParameter((Object)internalState, (String)"internalState");
        Intrinsics.checkNotNullParameter((Object)intervalMetricReader, (String)"intervalMetricReader");
        this.exporter = new Exporter(internalState);
        this.scheduler = intervalMetricReader;
        this.lock = new Object();
    }

    public /* synthetic */ MyIntervalMetricReader(InternalState internalState, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("MyIntervalMetricReader"));
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"Executors.newScheduledTh\u2026MyIntervalMetricReader\"))");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(internalState, scheduledExecutorService);
    }

    static {
        Companion = new Companion(null);
        logger = Logger.getLogger(MyIntervalMetricReader.class.getName());
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lfleet/util/tracing/MyIntervalMetricReader$Exporter;", "Ljava/lang/Runnable;", "internalState", "Lfleet/util/tracing/MyIntervalMetricReader$InternalState;", "(Lfleet/util/tracing/MyIntervalMetricReader$InternalState;)V", "exportAvailable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInternalState$fleet_util_telemetry", "()Lfleet/util/tracing/MyIntervalMetricReader$InternalState;", "doRun", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "run", "", "shutdown", "fleet.util.telemetry"})
    public static final class Exporter
    implements Runnable {
        private final AtomicBoolean exportAvailable;
        @NotNull
        private final InternalState internalState;

        @Override
        public void run() {
            this.doRun();
        }

        @NotNull
        public final CompletableResultCode doRun() {
            CompletableResultCode flushResult = new CompletableResultCode();
            if (this.exportAvailable.compareAndSet(true, false)) {
                try {
                    CompletableResultCode result2;
                    List metricsList = new ArrayList();
                    for (MetricProducer metricProducer : this.internalState.getMetricProducers()) {
                        Collection<MetricData> collection = metricProducer.collectAllMetrics();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"metricProducer.collectAllMetrics()");
                        metricsList.addAll(collection);
                    }
                    MetricExporter metricExporter = this.internalState.getMetricExporter();
                    CompletableResultCode completableResultCode = result2 = metricExporter != null ? metricExporter.export(Collections.unmodifiableList(metricsList)) : null;
                    if (completableResultCode != null) {
                        completableResultCode.whenComplete(new Runnable(this, result2, flushResult){
                            final /* synthetic */ Exporter this$0;
                            final /* synthetic */ CompletableResultCode $result;
                            final /* synthetic */ CompletableResultCode $flushResult;

                            public final void run() {
                                if (!this.$result.isSuccess()) {
                                    MyIntervalMetricReader.access$getLogger$cp().log(Level.FINE, "Exporter failed");
                                }
                                this.$flushResult.succeed();
                                Exporter.access$getExportAvailable$p(this.this$0).set(true);
                            }
                            {
                                this.this$0 = exporter;
                                this.$result = completableResultCode;
                                this.$flushResult = completableResultCode2;
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    this.exportAvailable.set(true);
                    logger.log(Level.WARNING, "Exporter threw an Exception", t);
                    flushResult.fail();
                }
            } else {
                logger.log(Level.FINE, "Exporter busy. Dropping metrics.");
                flushResult.fail();
            }
            return flushResult;
        }

        @NotNull
        public final CompletableResultCode shutdown() {
            Object object = this.internalState.getMetricExporter();
            if (object == null || (object = object.shutdown()) == null) {
                CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
                object = completableResultCode;
                Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"CompletableResultCode.ofSuccess()");
            }
            return object;
        }

        @NotNull
        public final InternalState getInternalState$fleet_util_telemetry() {
            return this.internalState;
        }

        public Exporter(@NotNull InternalState internalState) {
            Intrinsics.checkNotNullParameter((Object)internalState, (String)"internalState");
            this.internalState = internalState;
            this.exportAvailable = new AtomicBoolean(true);
        }

        public static final /* synthetic */ AtomicBoolean access$getExportAvailable$p(Exporter $this) {
            return $this.exportAvailable;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lfleet/util/tracing/MyIntervalMetricReader$InternalState;", "", "metricExporter", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "exportIntervalMillis", "", "metricProducers", "", "Lio/opentelemetry/sdk/metrics/export/MetricProducer;", "(Lio/opentelemetry/sdk/metrics/export/MetricExporter;JLjava/util/Collection;)V", "getExportIntervalMillis", "()J", "getMetricExporter", "()Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "getMetricProducers", "()Ljava/util/Collection;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Builder", "Companion", "fleet.util.telemetry"})
    public static final class InternalState {
        @Nullable
        private final MetricExporter metricExporter;
        private final long exportIntervalMillis;
        @NotNull
        private final Collection<MetricProducer> metricProducers;
        public static final long DEFAULT_INTERVAL_MILLIS = 60000L;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Nullable
        public final MetricExporter getMetricExporter() {
            return this.metricExporter;
        }

        public final long getExportIntervalMillis() {
            return this.exportIntervalMillis;
        }

        @NotNull
        public final Collection<MetricProducer> getMetricProducers() {
            return this.metricProducers;
        }

        public InternalState(@Nullable MetricExporter metricExporter, long exportIntervalMillis, @NotNull Collection<? extends MetricProducer> metricProducers) {
            Intrinsics.checkNotNullParameter(metricProducers, (String)"metricProducers");
            this.metricExporter = metricExporter;
            this.exportIntervalMillis = exportIntervalMillis;
            this.metricProducers = metricProducers;
        }

        @Nullable
        public final MetricExporter component1() {
            return this.metricExporter;
        }

        public final long component2() {
            return this.exportIntervalMillis;
        }

        @NotNull
        public final Collection<MetricProducer> component3() {
            return this.metricProducers;
        }

        @NotNull
        public final InternalState copy(@Nullable MetricExporter metricExporter, long exportIntervalMillis, @NotNull Collection<? extends MetricProducer> metricProducers) {
            Intrinsics.checkNotNullParameter(metricProducers, (String)"metricProducers");
            return new InternalState(metricExporter, exportIntervalMillis, metricProducers);
        }

        public static /* synthetic */ InternalState copy$default(InternalState internalState, MetricExporter metricExporter, long l, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                metricExporter = internalState.metricExporter;
            }
            if ((n & 2) != 0) {
                l = internalState.exportIntervalMillis;
            }
            if ((n & 4) != 0) {
                collection = internalState.metricProducers;
            }
            return internalState.copy(metricExporter, l, collection);
        }

        @NotNull
        public String toString() {
            return "InternalState(metricExporter=" + this.metricExporter + ", exportIntervalMillis=" + this.exportIntervalMillis + ", metricProducers=" + this.metricProducers + ")";
        }

        public int hashCode() {
            MetricExporter metricExporter = this.metricExporter;
            Collection<MetricProducer> collection = this.metricProducers;
            return ((metricExporter != null ? metricExporter.hashCode() : 0) * 31 + Long.hashCode(this.exportIntervalMillis)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof InternalState)) break block3;
                    InternalState internalState = (InternalState)object;
                    if (!Intrinsics.areEqual((Object)this.metricExporter, (Object)internalState.metricExporter) || this.exportIntervalMillis != internalState.exportIntervalMillis || !Intrinsics.areEqual(this.metricProducers, internalState.metricProducers)) break block3;
                }
                return true;
            }
            return false;
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0011\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J1\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u0014\u001a\u00020\u00002\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lfleet/util/tracing/MyIntervalMetricReader$InternalState$Builder;", "", "exportIntervalMillis", "", "metricExporter", "Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "metricProducers", "", "Lio/opentelemetry/sdk/metrics/export/MetricProducer;", "(JLio/opentelemetry/sdk/metrics/export/MetricExporter;Ljava/util/Collection;)V", "getExportIntervalMillis", "()J", "setExportIntervalMillis", "(J)V", "getMetricExporter", "()Lio/opentelemetry/sdk/metrics/export/MetricExporter;", "setMetricExporter", "(Lio/opentelemetry/sdk/metrics/export/MetricExporter;)V", "getMetricProducers", "()Ljava/util/Collection;", "setMetricProducers", "(Ljava/util/Collection;)V", "build", "Lfleet/util/tracing/MyIntervalMetricReader$InternalState;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fleet.util.telemetry"})
        public static final class Builder {
            private long exportIntervalMillis;
            @Nullable
            private MetricExporter metricExporter;
            @Nullable
            private Collection<? extends MetricProducer> metricProducers;

            @NotNull
            public final InternalState build() {
                Collection collection = this.metricProducers;
                if (collection == null) {
                    collection = CollectionsKt.emptyList();
                }
                return new InternalState(this.metricExporter, this.exportIntervalMillis, collection);
            }

            @NotNull
            public final Builder setExportIntervalMillis(long exportIntervalMillis) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder it = builder;
                boolean bl3 = false;
                this.exportIntervalMillis = exportIntervalMillis;
                return builder;
            }

            @NotNull
            public final Builder setMetricExporter(@Nullable MetricExporter metricExporter) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder it = builder;
                boolean bl3 = false;
                this.metricExporter = metricExporter;
                return builder;
            }

            @NotNull
            public final Builder setMetricProducers(@Nullable Collection<? extends MetricProducer> metricProducers) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder it = builder;
                boolean bl3 = false;
                this.metricProducers = metricProducers;
                return builder;
            }

            public final long getExportIntervalMillis() {
                return this.exportIntervalMillis;
            }

            public final void setExportIntervalMillis(long l) {
                this.exportIntervalMillis = l;
            }

            @Nullable
            public final MetricExporter getMetricExporter() {
                return this.metricExporter;
            }

            public final void setMetricExporter(@Nullable MetricExporter metricExporter) {
                this.metricExporter = metricExporter;
            }

            @Nullable
            public final Collection<MetricProducer> getMetricProducers() {
                return this.metricProducers;
            }

            public final void setMetricProducers(@Nullable Collection<? extends MetricProducer> collection) {
                this.metricProducers = collection;
            }

            public Builder(long exportIntervalMillis, @Nullable MetricExporter metricExporter, @Nullable Collection<? extends MetricProducer> metricProducers) {
                this.exportIntervalMillis = exportIntervalMillis;
                this.metricExporter = metricExporter;
                this.metricProducers = metricProducers;
            }

            public /* synthetic */ Builder(long l, MetricExporter metricExporter, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    l = 60000L;
                }
                if ((n & 2) != 0) {
                    metricExporter = null;
                }
                if ((n & 4) != 0) {
                    collection = null;
                }
                this(l, metricExporter, collection);
            }

            public Builder() {
                this(0L, null, null, 7, null);
            }

            public final long component1() {
                return this.exportIntervalMillis;
            }

            @Nullable
            public final MetricExporter component2() {
                return this.metricExporter;
            }

            @Nullable
            public final Collection<MetricProducer> component3() {
                return this.metricProducers;
            }

            @NotNull
            public final Builder copy(long exportIntervalMillis, @Nullable MetricExporter metricExporter, @Nullable Collection<? extends MetricProducer> metricProducers) {
                return new Builder(exportIntervalMillis, metricExporter, metricProducers);
            }

            public static /* synthetic */ Builder copy$default(Builder builder, long l, MetricExporter metricExporter, Collection collection, int n, Object object) {
                if ((n & 1) != 0) {
                    l = builder.exportIntervalMillis;
                }
                if ((n & 2) != 0) {
                    metricExporter = builder.metricExporter;
                }
                if ((n & 4) != 0) {
                    collection = builder.metricProducers;
                }
                return builder.copy(l, metricExporter, collection);
            }

            @NotNull
            public String toString() {
                return "Builder(exportIntervalMillis=" + this.exportIntervalMillis + ", metricExporter=" + this.metricExporter + ", metricProducers=" + this.metricProducers + ")";
            }

            public int hashCode() {
                MetricExporter metricExporter = this.metricExporter;
                Collection<? extends MetricProducer> collection = this.metricProducers;
                return (Long.hashCode(this.exportIntervalMillis) * 31 + (metricExporter != null ? metricExporter.hashCode() : 0)) * 31 + (collection != null ? ((Object)collection).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Builder)) break block3;
                        Builder builder = (Builder)object;
                        if (this.exportIntervalMillis != builder.exportIntervalMillis || !Intrinsics.areEqual((Object)this.metricExporter, (Object)builder.metricExporter) || !Intrinsics.areEqual(this.metricProducers, builder.metricProducers)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lfleet/util/tracing/MyIntervalMetricReader$InternalState$Companion;", "", "()V", "DEFAULT_INTERVAL_MILLIS", "", "builder", "Lfleet/util/tracing/MyIntervalMetricReader$InternalState$Builder;", "fleet.util.telemetry"})
        public static final class Companion {
            @NotNull
            public final Builder builder() {
                return new Builder(0L, null, null, 7, null).setExportIntervalMillis(60000L);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lfleet/util/tracing/MyIntervalMetricReader$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "builder", "Lfleet/util/tracing/MyIntervalMetricReaderBuilder;", "fleet.util.telemetry"})
    public static final class Companion {
        @NotNull
        public final MyIntervalMetricReaderBuilder builder() {
            return new MyIntervalMetricReaderBuilder(InternalState.Companion.builder());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

