/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.exporter.otlp.internal.CommonAdapter;
import io.opentelemetry.exporter.otlp.internal.ResourceAdapter;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Gauge;
import io.opentelemetry.proto.metrics.v1.Histogram;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.Sum;
import io.opentelemetry.proto.metrics.v1.Summary;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.LongGaugeData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MetricAdapter {
    public static List<ResourceMetrics> toProtoResourceMetrics(Collection<MetricData> metricData) {
        Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> resourceAndLibraryMap = MetricAdapter.groupByResourceAndLibrary(metricData);
        ArrayList<ResourceMetrics> resourceMetrics = new ArrayList<ResourceMetrics>(resourceAndLibraryMap.size());
        for (Map.Entry<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> entryResource : resourceAndLibraryMap.entrySet()) {
            ArrayList<InstrumentationLibraryMetrics> instrumentationLibraryMetrics = new ArrayList<InstrumentationLibraryMetrics>(entryResource.getValue().size());
            for (Map.Entry<InstrumentationLibraryInfo, List<Metric>> entryLibrary : entryResource.getValue().entrySet()) {
                instrumentationLibraryMetrics.add(InstrumentationLibraryMetrics.newBuilder().setInstrumentationLibrary(CommonAdapter.toProtoInstrumentationLibrary(entryLibrary.getKey())).addAllMetrics((Iterable<? extends Metric>)entryLibrary.getValue()).build());
            }
            resourceMetrics.add(ResourceMetrics.newBuilder().setResource(ResourceAdapter.toProtoResource(entryResource.getKey())).addAllInstrumentationLibraryMetrics(instrumentationLibraryMetrics).build());
        }
        return resourceMetrics;
    }

    private static Map<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> groupByResourceAndLibrary(Collection<MetricData> metricDataList) {
        HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>> result2 = new HashMap<Resource, Map<InstrumentationLibraryInfo, List<Metric>>>();
        for (MetricData metricData : metricDataList) {
            if (metricData.isEmpty()) continue;
            Resource resource = metricData.getResource();
            HashMap<InstrumentationLibraryInfo, List> libraryInfoListMap = (HashMap<InstrumentationLibraryInfo, List>)result2.get(metricData.getResource());
            if (libraryInfoListMap == null) {
                libraryInfoListMap = new HashMap<InstrumentationLibraryInfo, List>();
                result2.put(resource, libraryInfoListMap);
            }
            List metricList = libraryInfoListMap.computeIfAbsent(metricData.getInstrumentationLibraryInfo(), k -> new ArrayList());
            metricList.add(MetricAdapter.toProtoMetric(metricData));
        }
        return result2;
    }

    static Metric toProtoMetric(MetricData metricData) {
        Metric.Builder builder = Metric.newBuilder().setName(metricData.getName()).setDescription(metricData.getDescription()).setUnit(metricData.getUnit());
        switch (metricData.getType()) {
            case LONG_SUM: {
                LongSumData longSumData = metricData.getLongSumData();
                builder.setSum(Sum.newBuilder().setIsMonotonic(longSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(longSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toIntDataPoints(longSumData.getPoints())).build());
                break;
            }
            case DOUBLE_SUM: {
                DoubleSumData doubleSumData = metricData.getDoubleSumData();
                builder.setSum(Sum.newBuilder().setIsMonotonic(doubleSumData.isMonotonic()).setAggregationTemporality(MetricAdapter.mapToTemporality(doubleSumData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleSumData.getPoints())).build());
                break;
            }
            case SUMMARY: {
                DoubleSummaryData doubleSummaryData = metricData.getDoubleSummaryData();
                builder.setSummary(Summary.newBuilder().addAllDataPoints(MetricAdapter.toSummaryDataPoints(doubleSummaryData.getPoints())).build());
                break;
            }
            case LONG_GAUGE: {
                LongGaugeData longGaugeData = metricData.getLongGaugeData();
                builder.setGauge(Gauge.newBuilder().addAllDataPoints(MetricAdapter.toIntDataPoints(longGaugeData.getPoints())).build());
                break;
            }
            case DOUBLE_GAUGE: {
                DoubleGaugeData doubleGaugeData = metricData.getDoubleGaugeData();
                builder.setGauge(Gauge.newBuilder().addAllDataPoints(MetricAdapter.toDoubleDataPoints(doubleGaugeData.getPoints())).build());
                break;
            }
            case HISTOGRAM: {
                DoubleHistogramData doubleHistogramData = metricData.getDoubleHistogramData();
                builder.setHistogram(Histogram.newBuilder().setAggregationTemporality(MetricAdapter.mapToTemporality(doubleHistogramData.getAggregationTemporality())).addAllDataPoints(MetricAdapter.toHistogramDataPoints(doubleHistogramData.getPoints())).build());
            }
        }
        return builder.build();
    }

    private static AggregationTemporality mapToTemporality(io.opentelemetry.sdk.metrics.data.AggregationTemporality temporality) {
        switch (temporality) {
            case CUMULATIVE: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_CUMULATIVE;
            }
            case DELTA: {
                return AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
            }
        }
        return AggregationTemporality.AGGREGATION_TEMPORALITY_UNSPECIFIED;
    }

    static List<NumberDataPoint> toIntDataPoints(Collection<LongPointData> points) {
        ArrayList<NumberDataPoint> result2 = new ArrayList<NumberDataPoint>(points.size());
        for (LongPointData longPoint : points) {
            NumberDataPoint.Builder builder = NumberDataPoint.newBuilder().setStartTimeUnixNano(longPoint.getStartEpochNanos()).setTimeUnixNano(longPoint.getEpochNanos()).setAsInt(longPoint.getValue());
            List<KeyValue> labels = MetricAdapter.toProtoLabels(longPoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllAttributes(labels);
            }
            result2.add(builder.build());
        }
        return result2;
    }

    static Collection<NumberDataPoint> toDoubleDataPoints(Collection<DoublePointData> points) {
        ArrayList<NumberDataPoint> result2 = new ArrayList<NumberDataPoint>(points.size());
        for (DoublePointData doublePoint : points) {
            NumberDataPoint.Builder builder = NumberDataPoint.newBuilder().setStartTimeUnixNano(doublePoint.getStartEpochNanos()).setTimeUnixNano(doublePoint.getEpochNanos()).setAsDouble(doublePoint.getValue());
            List<KeyValue> labels = MetricAdapter.toProtoLabels(doublePoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllAttributes(labels);
            }
            result2.add(builder.build());
        }
        return result2;
    }

    static List<SummaryDataPoint> toSummaryDataPoints(Collection<DoubleSummaryPointData> points) {
        ArrayList<SummaryDataPoint> result2 = new ArrayList<SummaryDataPoint>(points.size());
        for (DoubleSummaryPointData doubleSummaryPoint : points) {
            SummaryDataPoint.Builder builder = SummaryDataPoint.newBuilder().setStartTimeUnixNano(doubleSummaryPoint.getStartEpochNanos()).setTimeUnixNano(doubleSummaryPoint.getEpochNanos()).setCount(doubleSummaryPoint.getCount()).setSum(doubleSummaryPoint.getSum());
            List<KeyValue> labels = MetricAdapter.toProtoLabels(doubleSummaryPoint.getLabels());
            if (!labels.isEmpty()) {
                builder.addAllAttributes(labels);
            }
            if (!doubleSummaryPoint.getPercentileValues().isEmpty()) {
                for (ValueAtPercentile valueAtPercentile : doubleSummaryPoint.getPercentileValues()) {
                    builder.addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(valueAtPercentile.getPercentile() / 100.0).setValue(valueAtPercentile.getValue()).build());
                }
            }
            result2.add(builder.build());
        }
        return result2;
    }

    static Collection<HistogramDataPoint> toHistogramDataPoints(Collection<DoubleHistogramPointData> points) {
        ArrayList<HistogramDataPoint> result2 = new ArrayList<HistogramDataPoint>(points.size());
        for (DoubleHistogramPointData doubleHistogramPoint : points) {
            List<KeyValue> labels;
            HistogramDataPoint.Builder builder = HistogramDataPoint.newBuilder().setStartTimeUnixNano(doubleHistogramPoint.getStartEpochNanos()).setTimeUnixNano(doubleHistogramPoint.getEpochNanos()).setCount(doubleHistogramPoint.getCount()).setSum(doubleHistogramPoint.getSum()).addAllBucketCounts(doubleHistogramPoint.getCounts());
            List<Double> boundaries = doubleHistogramPoint.getBoundaries();
            if (!boundaries.isEmpty()) {
                builder.addAllExplicitBounds(boundaries);
            }
            if (!(labels = MetricAdapter.toProtoLabels(doubleHistogramPoint.getLabels())).isEmpty()) {
                builder.addAllAttributes(labels);
            }
            result2.add(builder.build());
        }
        return result2;
    }

    static List<KeyValue> toProtoLabels(Labels labels) {
        if (labels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<KeyValue> result2 = new ArrayList<KeyValue>(labels.size());
        labels.forEach((key, value) -> result2.add(KeyValue.newBuilder().setKey((String)key).setValue(AnyValue.newBuilder().setStringValue((String)value).build()).build()));
        return result2;
    }

    private MetricAdapter() {
    }
}

