/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.metrics.BoundDoubleValueRecorder;
import io.opentelemetry.api.metrics.DoubleValueRecorder;
import io.opentelemetry.api.metrics.DoubleValueRecorderBuilder;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrumentBuilder;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.SynchronousInstrumentAccumulator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class DoubleValueRecorderSdk
extends AbstractSynchronousInstrument
implements DoubleValueRecorder {
    private DoubleValueRecorderSdk(InstrumentDescriptor descriptor, SynchronousInstrumentAccumulator<?> accumulator) {
        super(descriptor, accumulator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(double value, Labels labels) {
        AggregatorHandle<?> aggregatorHandle = this.acquireHandle(labels);
        try {
            aggregatorHandle.recordDouble(value);
        }
        finally {
            aggregatorHandle.release();
        }
    }

    @Override
    public void record(double value) {
        this.record(value, Labels.empty());
    }

    @Override
    public BoundDoubleValueRecorder bind(Labels labels) {
        return new BoundInstrument(this.acquireHandle(labels));
    }

    static final class Builder
    extends AbstractSynchronousInstrumentBuilder<Builder>
    implements DoubleValueRecorderBuilder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState) {
            super(name, InstrumentType.VALUE_RECORDER, InstrumentValueType.DOUBLE, meterProviderSharedState, meterSharedState);
        }

        @Override
        Builder getThis() {
            return this;
        }

        @Override
        public DoubleValueRecorderSdk build() {
            return this.buildInstrument((x$0, x$1) -> new DoubleValueRecorderSdk((InstrumentDescriptor)x$0, (SynchronousInstrumentAccumulator)x$1));
        }
    }

    static final class BoundInstrument
    implements BoundDoubleValueRecorder {
        private final AggregatorHandle<?> aggregatorHandle;

        BoundInstrument(AggregatorHandle<?> aggregatorHandle) {
            this.aggregatorHandle = aggregatorHandle;
        }

        @Override
        public void record(double value) {
            this.aggregatorHandle.recordDouble(value);
        }

        @Override
        public void unbind() {
            this.aggregatorHandle.release();
        }
    }
}

