/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.appender.destination;

import ch.qos.logback.core.util.Duration;
import net.logstash.logback.appender.destination.DestinationConnectionStrategy;

public abstract class DestinationConnectionStrategyWithTtl
implements DestinationConnectionStrategy {
    private Duration connectionTTL;
    private volatile long connectionExpirationTime = Long.MAX_VALUE;

    @Override
    public void connectSuccess(long connectionStartTimeInMillis, int connectedDestinationIndex, int numDestinations) {
        this.connectionExpirationTime = this.connectionTTL != null ? connectionStartTimeInMillis + this.connectionTTL.getMilliseconds() : Long.MAX_VALUE;
    }

    @Override
    public void connectFailed(long connectionStartTimeInMillis, int failedDestinationIndex, int numDestinations) {
    }

    @Override
    public boolean shouldReconnect(long currentTimeInMillis, int currentDestinationIndex, int numDestinations) {
        return this.connectionExpirationTime <= currentTimeInMillis;
    }

    public Duration getConnectionTTL() {
        return this.connectionTTL;
    }

    public void setConnectionTTL(Duration connectionTTL) {
        if (connectionTTL != null && connectionTTL.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("connectionTTL must be > 0");
        }
        this.connectionTTL = connectionTTL;
    }
}

