/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.mask;

import com.fasterxml.jackson.core.JsonStreamContext;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.logstash.logback.mask.ValueMasker;

public class RegexValueMasker
implements ValueMasker {
    private final Pattern pattern;
    private final Object mask;

    public RegexValueMasker(String regex2, Object mask) {
        this(Pattern.compile(regex2), mask);
    }

    public RegexValueMasker(Pattern pattern, Object mask) {
        this.pattern = Objects.requireNonNull(pattern, "pattern must not be null");
        this.mask = Objects.requireNonNull(mask, "rmask must not be null");
    }

    @Override
    public Object mask(JsonStreamContext context, Object o) {
        Matcher matcher;
        if (o instanceof CharSequence && (matcher = this.pattern.matcher((CharSequence)o)).matches()) {
            return this.mask instanceof String ? matcher.replaceAll((String)this.mask) : this.mask;
        }
        return null;
    }
}

