/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.LocalVariableImpl;
import com.jetbrains.jdi.LocationImpl;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.MirrorImpl;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.SlotLocalVariable;
import com.jetbrains.jdi.ThreadAction;
import com.jetbrains.jdi.ThreadListener;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.VMState;
import com.jetbrains.jdi.ValueImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class StackFrameImpl
extends MirrorImpl
implements StackFrame,
ThreadListener {
    private boolean isValid = true;
    private final ThreadReferenceImpl thread;
    private final long id;
    private final Location location;
    private volatile Map<String, LocalVariable> visibleVariables = null;
    private ObjectReference thisObject = null;

    StackFrameImpl(VirtualMachine vm, ThreadReferenceImpl thread, long id, Location location) {
        super(vm);
        this.thread = thread;
        this.id = id;
        this.location = location;
        thread.addListener(this);
    }

    @Override
    public boolean threadResumable(ThreadAction action) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            if (this.isValid) {
                this.isValid = false;
                return false;
            }
            throw new InternalException("Invalid stack frame thread listener");
        }
    }

    void validateStackFrame() {
        if (!this.isValid) {
            throw new InvalidStackFrameException("Thread has been resumed");
        }
    }

    @Override
    public Location location() {
        this.validateStackFrame();
        return this.location;
    }

    @Override
    public ThreadReference thread() {
        this.validateStackFrame();
        return this.thread;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StackFrameImpl) {
            StackFrameImpl other = (StackFrameImpl)obj;
            return this.id == other.id && this.thread().equals(other.thread()) && this.location().equals(other.location()) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.thread().hashCode() << 4) + (int)this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectReference thisObject() {
        this.validateStackFrame();
        MethodImpl currentMethod = (MethodImpl)this.location.method();
        if (currentMethod.isStatic() || currentMethod.isNative()) {
            return null;
        }
        if (this.thisObject == null) {
            PacketStream ps;
            VMState vMState = this.vm.state();
            synchronized (vMState) {
                this.validateStackFrame();
                ps = JDWP.StackFrame.ThisObject.enqueueCommand(this.vm, this.thread, this.id);
            }
            try {
                this.thisObject = JDWP.StackFrame.ThisObject.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).objectThis;
            }
            catch (JDWPException exc) {
                switch (exc.errorCode()) {
                    case 10: 
                    case 13: 
                    case 30: {
                        throw new InvalidStackFrameException();
                    }
                }
                throw exc.toJDIException();
            }
        }
        return this.thisObject;
    }

    public CompletableFuture<ObjectReference> thisObjectAsync() {
        this.validateStackFrame();
        return ((LocationImpl)this.location).methodAsync().thenCompose(currentMethod -> {
            if (currentMethod.isStatic() || currentMethod.isNative()) {
                return CompletableFuture.completedFuture(null);
            }
            if (this.thisObject == null) {
                VMState vMState = this.vm.state();
                synchronized (vMState) {
                    this.validateStackFrame();
                    return ((CompletableFuture)JDWP.StackFrame.ThisObject.processAsync(this.vm, this.thread, this.id).exceptionally(throwable -> {
                        if (JDWPException.isOfType(throwable, 30, 13, 10)) {
                            throw new InvalidStackFrameException();
                        }
                        throw (RuntimeException)throwable;
                    })).thenApply(to -> {
                        this.thisObject = to.objectThis;
                        return this.thisObject;
                    });
                }
            }
            return CompletableFuture.completedFuture(this.thisObject);
        });
    }

    private Map<String, LocalVariable> createVisibleVariables() throws AbsentInformationException {
        if (this.visibleVariables == null) {
            this.createVisibleVariablesImpl(this.location.method().variables());
        }
        return this.visibleVariables;
    }

    private CompletableFuture<Map<String, LocalVariable>> createVisibleVariablesAsync() {
        if (this.visibleVariables == null) {
            return ((CompletableFuture)((LocationImpl)this.location).methodAsync().thenCompose(method -> ((MethodImpl)method).variablesAsync())).thenApply(this::createVisibleVariablesImpl);
        }
        return CompletableFuture.completedFuture(this.visibleVariables);
    }

    private Map<String, LocalVariable> createVisibleVariablesImpl(List<LocalVariable> allVariables) {
        HashMap<String, LocalVariable> map = new HashMap<String, LocalVariable>(allVariables.size());
        for (LocalVariable variable : allVariables) {
            LocalVariable existing;
            String name = variable.name();
            if (!variable.isVisible(this) || (existing = (LocalVariable)map.get(name)) != null && !((LocalVariableImpl)variable).hides(existing)) continue;
            map.put(name, variable);
        }
        this.visibleVariables = map;
        return this.visibleVariables;
    }

    @Override
    public List<LocalVariable> visibleVariables() throws AbsentInformationException {
        this.validateStackFrame();
        ArrayList<LocalVariable> mapAsList = new ArrayList<LocalVariable>(this.createVisibleVariables().values());
        Collections.sort(mapAsList);
        return mapAsList;
    }

    public CompletableFuture<List<LocalVariable>> visibleVariablesAsync() {
        this.validateStackFrame();
        return this.createVisibleVariablesAsync().thenApply(v -> {
            ArrayList mapAsList = new ArrayList(v.values());
            Collections.sort(mapAsList);
            return mapAsList;
        });
    }

    @Override
    public LocalVariable visibleVariableByName(String name) throws AbsentInformationException {
        this.validateStackFrame();
        return this.createVisibleVariables().get(name);
    }

    public CompletableFuture<LocalVariable> visibleVariableByNameAsync(String name) {
        this.validateStackFrame();
        return this.createVisibleVariablesAsync().thenApply(variables -> (LocalVariable)variables.get(name));
    }

    @Override
    public Value getValue(LocalVariable variable) {
        return this.getValues(List.of(variable)).get(variable);
    }

    public CompletableFuture<Value> getValueAsync(LocalVariable variable) {
        return this.getValuesAsync(List.of(variable)).thenApply(res -> (Value)res.get(variable));
    }

    public Value[] getSlotsValues(List<? extends SlotLocalVariable> slotsVariables) {
        this.validateStackFrame();
        JDWP.StackFrame.GetValues.SlotInfo[] slots = (JDWP.StackFrame.GetValues.SlotInfo[])slotsVariables.stream().map(v -> new JDWP.StackFrame.GetValues.SlotInfo(v.slot(), (byte)v.signature().charAt(0))).toArray(JDWP.StackFrame.GetValues.SlotInfo[]::new);
        return this.getSlotsValues(slots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueImpl[] getSlotsValues(JDWP.StackFrame.GetValues.SlotInfo[] slots) {
        ValueImpl[] values;
        PacketStream ps;
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.validateStackFrame();
            ps = JDWP.StackFrame.GetValues.enqueueCommand(this.vm, this.thread, this.id, slots);
        }
        try {
            values = JDWP.StackFrame.GetValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).values;
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw exc.toJDIException();
        }
        if (slots.length != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<ValueImpl[]> getSlotsValuesAsync(JDWP.StackFrame.GetValues.SlotInfo[] slots) {
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.validateStackFrame();
            return ((CompletableFuture)JDWP.StackFrame.GetValues.processAsync(this.vm, this.thread, this.id, slots).exceptionally(throwable -> {
                if (JDWPException.isOfType(throwable, 30, 13, 10)) {
                    throw new InvalidStackFrameException();
                }
                throw (RuntimeException)throwable;
            })).thenApply(v -> {
                ValueImpl[] values = v.values;
                if (slots.length != values.length) {
                    throw new InternalException("Wrong number of values returned from target VM");
                }
                return values;
            });
        }
    }

    @Override
    public Map<LocalVariable, Value> getValues(List<? extends LocalVariable> variables) {
        this.validateStackFrame();
        this.validateMirrors(variables);
        int count = variables.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slots = this.createSlots(variables, count);
        ValueImpl[] values = this.getSlotsValues(slots);
        HashMap<LocalVariable, Value> map = new HashMap<LocalVariable, Value>(count);
        for (int i = 0; i < count; ++i) {
            map.put(variables.get(i), values[i]);
        }
        return map;
    }

    public CompletableFuture<Map<LocalVariable, Value>> getValuesAsync(List<? extends LocalVariable> variables) {
        this.validateStackFrame();
        this.validateMirrors(variables);
        int count = variables.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slots = this.createSlots(variables, count);
        return this.getSlotsValuesAsync(slots).thenApply(values -> {
            HashMap<LocalVariable, ValueImpl> map = new HashMap<LocalVariable, ValueImpl>(count);
            for (int i = 0; i < count; ++i) {
                map.put((LocalVariable)variables.get(i), values[i]);
            }
            return map;
        });
    }

    private JDWP.StackFrame.GetValues.SlotInfo[] createSlots(List<? extends LocalVariable> variables, int count) {
        JDWP.StackFrame.GetValues.SlotInfo[] slots = new JDWP.StackFrame.GetValues.SlotInfo[count];
        for (int i = 0; i < count; ++i) {
            LocalVariableImpl variable = (LocalVariableImpl)variables.get(i);
            if (!variable.isVisible(this)) {
                throw new IllegalArgumentException(variable.name() + " is not valid at this frame location");
            }
            slots[i] = new JDWP.StackFrame.GetValues.SlotInfo(variable.slot(), (byte)variable.signature().charAt(0));
        }
        return slots;
    }

    public void setSlotValue(SlotLocalVariable variable, Value value) {
        this.validateStackFrame();
        this.validateMirrorOrNull(value);
        JDWP.StackFrame.SetValues.SlotInfo[] slotVals = new JDWP.StackFrame.SetValues.SlotInfo[]{new JDWP.StackFrame.SetValues.SlotInfo(variable.slot(), (ValueImpl)value)};
        this.setSlotsValues(slotVals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSlotsValues(JDWP.StackFrame.SetValues.SlotInfo[] slotVals) {
        PacketStream ps;
        VMState vMState = this.vm.state();
        synchronized (vMState) {
            this.validateStackFrame();
            ps = JDWP.StackFrame.SetValues.enqueueCommand(this.vm, this.thread, this.id, slotVals);
        }
        try {
            JDWP.StackFrame.SetValues.waitForReply(this.vm, ps);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw exc.toJDIException();
        }
    }

    @Override
    public void setValue(LocalVariable variableIntf, Value valueIntf) throws InvalidTypeException, ClassNotLoadedException {
        block3: {
            this.validateStackFrame();
            this.validateMirror(variableIntf);
            this.validateMirrorOrNull(valueIntf);
            LocalVariableImpl variable = (LocalVariableImpl)variableIntf;
            ValueImpl value = (ValueImpl)valueIntf;
            if (!variable.isVisible(this)) {
                throw new IllegalArgumentException(variable.name() + " is not valid at this frame location");
            }
            try {
                value = ValueImpl.prepareForAssignment(value, variable);
                JDWP.StackFrame.SetValues.SlotInfo[] slotVals = new JDWP.StackFrame.SetValues.SlotInfo[]{new JDWP.StackFrame.SetValues.SlotInfo(variable.slot(), value)};
                this.setSlotsValues(slotVals);
            }
            catch (ClassNotLoadedException e) {
                if (value == null) break block3;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Value> getArgumentValues() {
        ValueImpl[] values;
        PacketStream ps;
        this.validateStackFrame();
        MethodImpl mmm = (MethodImpl)this.location.method();
        List<String> argSigs = mmm.argumentSignatures();
        int count = argSigs.size();
        JDWP.StackFrame.GetValues.SlotInfo[] slots = new JDWP.StackFrame.GetValues.SlotInfo[count];
        int slot = mmm.isStatic() ? 0 : 1;
        for (int ii = 0; ii < count; ++ii) {
            char sigChar = argSigs.get(ii).charAt(0);
            slots[ii] = new JDWP.StackFrame.GetValues.SlotInfo(slot++, (byte)sigChar);
            if (sigChar != 'J' && sigChar != 'D') continue;
            ++slot;
        }
        VMState sigChar = this.vm.state();
        synchronized (sigChar) {
            this.validateStackFrame();
            ps = JDWP.StackFrame.GetValues.enqueueCommand(this.vm, this.thread, this.id, slots);
        }
        try {
            values = JDWP.StackFrame.GetValues.waitForReply((VirtualMachineImpl)this.vm, (PacketStream)ps).values;
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 10: 
                case 13: 
                case 30: {
                    throw new InvalidStackFrameException();
                }
            }
            throw exc.toJDIException();
        }
        if (count != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        return Arrays.asList(values);
    }

    void pop() throws IncompatibleThreadStateException {
        this.validateStackFrame();
        try {
            PacketStream stream = this.thread.sendResumingCommand(() -> JDWP.StackFrame.PopFrames.enqueueCommand(this.vm, this.thread, this.id));
            JDWP.StackFrame.PopFrames.waitForReply(this.vm, stream);
        }
        catch (JDWPException exc) {
            switch (exc.errorCode()) {
                case 13: {
                    throw new IncompatibleThreadStateException("Thread not current or suspended");
                }
                case 10: {
                    throw new IncompatibleThreadStateException("zombie");
                }
                case 31: {
                    throw new InvalidStackFrameException("No more frames on the stack");
                }
            }
            throw exc.toJDIException();
        }
        this.vm.state().freeze();
    }

    @Override
    public String toString() {
        return this.location.toString() + " in thread " + this.thread.toString();
    }
}

