/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;

public class Archetype
implements Serializable {
    private String groupId;
    private String artifactId;
    private String version;
    private String repository;
    private String description;
    private List goals;
    private Properties properties;
    private String modelEncoding = "UTF-8";

    public void addGoal(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("Archetype.addGoals(string) parameter must be instanceof " + String.class.getName());
        }
        this.getGoals().add(string);
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getDescription() {
        return this.description;
    }

    public List getGoals() {
        if (this.goals == null) {
            this.goals = new ArrayList();
        }
        return this.goals;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeGoal(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("Archetype.removeGoals(string) parameter must be instanceof " + String.class.getName());
        }
        this.getGoals().remove(string);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setGoals(List goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "[" + this.groupId + ":" + this.artifactId + ":" + this.version + (this.repository != null ? " -> " + this.repository : "") + "]";
    }

    public int hashCode() {
        return this.groupId.hashCode() + 17 * this.artifactId.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Archetype)) {
            return false;
        }
        Archetype a = (Archetype)object;
        return StringUtils.equals((String)this.groupId, (String)a.getGroupId()) && StringUtils.equals((String)this.artifactId, (String)a.getArtifactId());
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

