/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns;

import com.intellij.openapi.project.Project;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.KnownRepositories;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageOperations;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.TargetModules;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageOperationType;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.versions.NormalizedPackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableItem;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers.PackageActionsTableCellRendererAndEditor;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\"B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\"\u0010\u0006\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t0\b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0003J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0014\u0010\u001e\u001a\u00020\u00122\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u001e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010 \u001a\u00020!2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t0\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ActionsColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableItem;", "", "project", "Lcom/intellij/openapi/project/Project;", "operationExecutor", "Lkotlin/Function1;", "Lkotlinx/coroutines/Deferred;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "cellRendererAndEditor", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageActionsTableCellRendererAndEditor;", "knownRepositoriesInTargetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;", "onlyStable", "", "targetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "generateMessageFor", "", "item", "getEditor", "Ljavax/swing/table/TableCellEditor;", "getOperationTypeFor", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "isCellEditable", "updateData", "valueOf", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ActionsColumn$ActionViewModel;", "ActionViewModel", "intellij.packageSearch"})
public final class ActionsColumn
extends ColumnInfo<PackagesTableItem<?>, Object> {
    private TargetModules targetModules;
    private KnownRepositories.InTargetModules knownRepositoriesInTargetModules;
    private boolean onlyStable;
    private final PackageActionsTableCellRendererAndEditor cellRendererAndEditor;
    private final Project project;
    private final Function1<Deferred<? extends List<? extends PackageSearchOperation<?>>>, Unit> operationExecutor;

    @NotNull
    public TableCellRenderer getRenderer(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return this.cellRendererAndEditor;
    }

    @NotNull
    public TableCellEditor getEditor(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return (TableCellEditor)((Object)this.cellRendererAndEditor);
    }

    public boolean isCellEditable(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return this.getOperationTypeFor(item) != null;
    }

    public final void updateData(boolean onlyStable, @NotNull TargetModules targetModules, @NotNull KnownRepositories.InTargetModules knownRepositoriesInTargetModules) {
        Intrinsics.checkNotNullParameter((Object)targetModules, (String)"targetModules");
        Intrinsics.checkNotNullParameter((Object)knownRepositoriesInTargetModules, (String)"knownRepositoriesInTargetModules");
        this.onlyStable = onlyStable;
        this.targetModules = targetModules;
        this.knownRepositoriesInTargetModules = knownRepositoriesInTargetModules;
    }

    @NotNull
    public ActionViewModel valueOf(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        PackageOperationType operationType = this.getOperationTypeFor(item);
        return new ActionViewModel((PackageModel)item.getPackageModel(), (Deferred<? extends List<? extends PackageSearchOperation<?>>>)item.getUiPackageModel().getPackageOperations().getPrimaryOperations(), operationType, this.generateMessageFor(item), item instanceof PackagesTableItem.InstallablePackage);
    }

    private final PackageOperationType getOperationTypeFor(PackagesTableItem<?> item) {
        PackageOperationType packageOperationType;
        PackagesTableItem<?> packagesTableItem = item;
        if (packagesTableItem instanceof PackagesTableItem.InstalledPackage) {
            NormalizedPackageVersion<?> currentVersion = ((PackagesTableItem.InstalledPackage)item).getUiPackageModel().getSelectedVersion();
            PackageOperations packageOperations = ((PackagesTableItem.InstalledPackage)item).getUiPackageModel().getPackageOperations();
            packageOperationType = currentVersion instanceof NormalizedPackageVersion.Missing ? PackageOperationType.SET : (packageOperations.getCanUpgradePackage() ? PackageOperationType.UPGRADE : null);
        } else if (packagesTableItem instanceof PackagesTableItem.InstallablePackage) {
            packageOperationType = PackageOperationType.INSTALL;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return packageOperationType;
    }

    @Nls
    private final String generateMessageFor(PackagesTableItem<?> item) {
        Object packageModel = item.getPackageModel();
        RepositoryModel repositoryModel = this.knownRepositoriesInTargetModules.repositoryToAddWhenInstallingOrUpgrading(this.project, (PackageModel)packageModel, (PackageVersion)item.getUiPackageModel().getSelectedVersion().getOriginalVersion());
        if (repositoryModel == null) {
            return null;
        }
        RepositoryModel repoToInstall = repositoryModel;
        return PackageSearchBundle.INSTANCE.message("packagesearch.repository.willBeAddedOnInstall", repoToInstall.getDisplayName());
    }

    public ActionsColumn(@NotNull Project project, @NotNull Function1<? super Deferred<? extends List<? extends PackageSearchOperation<?>>>, Unit> operationExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(operationExecutor, (String)"operationExecutor");
        super(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.columns.actions", new Object[0]));
        this.project = project;
        this.operationExecutor = operationExecutor;
        this.targetModules = TargetModules.None.INSTANCE;
        this.knownRepositoriesInTargetModules = KnownRepositories.InTargetModules.Companion.getEMPTY();
        this.cellRendererAndEditor = new PackageActionsTableCellRendererAndEditor((Function1<? super ActionViewModel, Unit>)((Function1)new Function1<ActionViewModel, Unit>(this){
            final /* synthetic */ ActionsColumn this$0;

            public final void invoke(@NotNull ActionViewModel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionsColumn.access$getOperationExecutor$p(this.this$0).invoke(it.getOperations());
            }
            {
                this.this$0 = actionsColumn2;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ Function1 access$getOperationExecutor$p(ActionsColumn $this) {
        return $this.operationExecutor;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u0019\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00c6\u0003JO\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0003\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u000bH\u00d6\u0001R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0004\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/ActionsColumn$ActionViewModel;", "", "packageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;", "operations", "Lkotlinx/coroutines/Deferred;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "operationType", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;", "infoMessage", "", "isSearchResult", "", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;Lkotlinx/coroutines/Deferred;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;Ljava/lang/String;Z)V", "getInfoMessage", "()Ljava/lang/String;", "()Z", "getOperationType", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageOperationType;", "getOperations", "()Lkotlinx/coroutines/Deferred;", "getPackageModel", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageModel;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "intellij.packageSearch"})
    public static final class ActionViewModel {
        @NotNull
        private final PackageModel packageModel;
        @NotNull
        private final Deferred<List<PackageSearchOperation<?>>> operations;
        @Nullable
        private final PackageOperationType operationType;
        @Nullable
        private final String infoMessage;
        private final boolean isSearchResult;

        @NotNull
        public final PackageModel getPackageModel() {
            return this.packageModel;
        }

        @NotNull
        public final Deferred<List<PackageSearchOperation<?>>> getOperations() {
            return this.operations;
        }

        @Nullable
        public final PackageOperationType getOperationType() {
            return this.operationType;
        }

        @Nullable
        public final String getInfoMessage() {
            return this.infoMessage;
        }

        public final boolean isSearchResult() {
            return this.isSearchResult;
        }

        public ActionViewModel(@NotNull PackageModel packageModel, @NotNull Deferred<? extends List<? extends PackageSearchOperation<?>>> operations, @Nullable PackageOperationType operationType, @Nls @Nullable String infoMessage, boolean isSearchResult) {
            Intrinsics.checkNotNullParameter((Object)packageModel, (String)"packageModel");
            Intrinsics.checkNotNullParameter(operations, (String)"operations");
            this.packageModel = packageModel;
            this.operations = operations;
            this.operationType = operationType;
            this.infoMessage = infoMessage;
            this.isSearchResult = isSearchResult;
        }

        @NotNull
        public final PackageModel component1() {
            return this.packageModel;
        }

        @NotNull
        public final Deferred<List<PackageSearchOperation<?>>> component2() {
            return this.operations;
        }

        @Nullable
        public final PackageOperationType component3() {
            return this.operationType;
        }

        @Nullable
        public final String component4() {
            return this.infoMessage;
        }

        public final boolean component5() {
            return this.isSearchResult;
        }

        @NotNull
        public final ActionViewModel copy(@NotNull PackageModel packageModel, @NotNull Deferred<? extends List<? extends PackageSearchOperation<?>>> operations, @Nullable PackageOperationType operationType, @Nls @Nullable String infoMessage, boolean isSearchResult) {
            Intrinsics.checkNotNullParameter((Object)packageModel, (String)"packageModel");
            Intrinsics.checkNotNullParameter(operations, (String)"operations");
            return new ActionViewModel(packageModel, operations, operationType, infoMessage, isSearchResult);
        }

        public static /* synthetic */ ActionViewModel copy$default(ActionViewModel actionViewModel, PackageModel packageModel, Deferred deferred, PackageOperationType packageOperationType, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                packageModel = actionViewModel.packageModel;
            }
            if ((n & 2) != 0) {
                deferred = actionViewModel.operations;
            }
            if ((n & 4) != 0) {
                packageOperationType = actionViewModel.operationType;
            }
            if ((n & 8) != 0) {
                string = actionViewModel.infoMessage;
            }
            if ((n & 0x10) != 0) {
                bl = actionViewModel.isSearchResult;
            }
            return actionViewModel.copy(packageModel, deferred, packageOperationType, string, bl);
        }

        @NotNull
        public String toString() {
            return "ActionViewModel(packageModel=" + this.packageModel + ", operations=" + this.operations + ", operationType=" + (Object)((Object)this.operationType) + ", infoMessage=" + this.infoMessage + ", isSearchResult=" + this.isSearchResult + ")";
        }

        public int hashCode() {
            PackageModel packageModel = this.packageModel;
            Deferred<List<PackageSearchOperation<?>>> deferred = this.operations;
            PackageOperationType packageOperationType = this.operationType;
            String string = this.infoMessage;
            int n = ((((packageModel != null ? packageModel.hashCode() : 0) * 31 + (deferred != null ? deferred.hashCode() : 0)) * 31 + (packageOperationType != null ? ((Object)((Object)packageOperationType)).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.isSearchResult ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActionViewModel)) break block3;
                    ActionViewModel actionViewModel = (ActionViewModel)object;
                    if (!Intrinsics.areEqual((Object)this.packageModel, (Object)actionViewModel.packageModel) || !Intrinsics.areEqual(this.operations, actionViewModel.operations) || !Intrinsics.areEqual((Object)((Object)this.operationType), (Object)((Object)actionViewModel.operationType)) || !Intrinsics.areEqual((Object)this.infoMessage, (Object)actionViewModel.infoMessage) || this.isSearchResult != actionViewModel.isSearchResult) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

