/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.DefaultBundleService;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    @NotNull
    private static String ourLangTag = Locale.ENGLISH.toLanguageTag();
    private static final Map<String, DynamicBundle> ourBundlesForForms = CollectionFactory.createConcurrentSoftValueMap();
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};

    public DynamicBundle(@NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(0);
        }
        super(pathToBundle);
    }

    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        PluginDescriptor pluginDescriptor;
        ResourceBundle pluginBundle;
        LanguageBundleEP langBundle;
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(1);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(2);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$0(3);
        }
        ResourceBundle base = super.findBundle(pathToBundle, baseLoader, control);
        if (!DefaultBundleService.isDefaultBundle() && (langBundle = DynamicBundle.findLanguageBundle()) != null && (pluginBundle = super.findBundle(pathToBundle, (pluginDescriptor = langBundle.pluginDescriptor) == null ? ((Object)((Object)this)).getClass().getClassLoader() : pluginDescriptor.getClassLoader(), control)) != null) {
            try {
                if (DynamicBundleInternal.SET_PARENT != null && pluginBundle != base) {
                    DynamicBundleInternal.SET_PARENT.bindTo(pluginBundle).invoke(base);
                }
                return pluginBundle;
            }
            catch (Throwable e) {
                LOG.warn(e);
            }
        }
        return base;
    }

    @Nullable
    public static LanguageBundleEP findLanguageBundle() {
        try {
            if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                return null;
            }
            Application app = ApplicationManager.getApplication();
            if (app == null || !app.getExtensionArea().hasExtensionPoint(LanguageBundleEP.EP_NAME)) {
                return null;
            }
            return (LanguageBundleEP)LanguageBundleEP.EP_NAME.findExtension(LanguageBundleEP.class);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class callerClass;
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(4);
        }
        return DynamicBundle.getBundle(baseName, (callerClass = ReflectionUtil.findCallerClass((int)2)) == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(5);
        }
        if (formClass == null) {
            DynamicBundle.$$$reportNull$$$0(6);
        }
        DynamicBundle dynamic = ourBundlesForForms.computeIfAbsent(baseName, s -> new DynamicBundle((String)s){});
        final ResourceBundle rb = dynamic.getResourceBundle(formClass.getClassLoader());
        if (!BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return rb;
        }
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(@NotNull String key) {
                if (key == null) {
                    3.$$$reportNull$$$0(0);
                }
                Object get = rb.getObject(key);
                assert (get instanceof String) : "Language bundles should contain only strings";
                return BundleBase.appendLocalizationSuffix((String)((String)get), (String)"\ud83d\udd05");
            }

            @Override
            @NotNull
            public Enumeration<String> getKeys() {
                Enumeration<String> enumeration = rb.getKeys();
                if (enumeration == null) {
                    3.$$$reportNull$$$0(1);
                }
                return enumeration;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/DynamicBundle$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/DynamicBundle$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKeys";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleGetObject";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static void loadLocale(@Nullable LanguageBundleEP langBundle) {
        if (langBundle != null) {
            ourLangTag = langBundle.locale;
            DynamicBundle.clearGlobalLocaleCache();
            ourBundlesForForms.clear();
        }
    }

    @NotNull
    public static Locale getLocale() {
        Locale locale = Locale.forLanguageTag(ourLangTag);
        if (locale == null) {
            DynamicBundle.$$$reportNull$$$0(7);
        }
        return locale;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/DynamicBundle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/DynamicBundle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBundle";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBundle";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class LanguageBundleEP
    implements PluginAware {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = new ExtensionPointName("com.intellij.languageBundle");
        @Attribute(value="locale")
        public String locale = Locale.ENGLISH.getLanguage();
        public PluginDescriptor pluginDescriptor;

        public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
            if (pluginDescriptor == null) {
                LanguageBundleEP.$$$reportNull$$$0(0);
            }
            this.pluginDescriptor = pluginDescriptor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/DynamicBundle$LanguageBundleEP", "setPluginDescriptor"));
        }
    }

    private static class DynamicBundleInternal {
        private static final MethodHandle SET_PARENT;

        private DynamicBundleInternal() {
        }

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

