/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/hints/HintInfo;", "", "()V", "isOwnedByPsiElement", "", "elem", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "MethodInfo", "OptionInfo", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "intellij.platform.lang"})
public abstract class HintInfo {
    public boolean isOwnedByPsiElement(@NotNull PsiElement elem, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = elem.getTextRange();
        if (textRange == null) {
            return false;
        }
        int start = textRange.isEmpty() ? textRange.getStartOffset() : textRange.getStartOffset() + 1;
        return editor.getInlayModel().hasInlineElementsInRange(start, textRange.getEndOffset());
    }

    private HintInfo() {
    }

    public /* synthetic */ HintInfo(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "Lcom/intellij/codeInsight/hints/HintInfo;", "fullyQualifiedName", "", "paramNames", "", "(Ljava/lang/String;Ljava/util/List;)V", "language", "Lcom/intellij/lang/Language;", "(Ljava/lang/String;Ljava/util/List;Lcom/intellij/lang/Language;)V", "getFullyQualifiedName", "()Ljava/lang/String;", "getLanguage", "()Lcom/intellij/lang/Language;", "getParamNames", "()Ljava/util/List;", "getMethodName", "intellij.platform.lang"})
    public static class MethodInfo
    extends HintInfo {
        @NotNull
        private final String fullyQualifiedName;
        @NotNull
        private final List<String> paramNames;
        @Nullable
        private final Language language;

        @NotNull
        public String getMethodName() {
            int start = StringsKt.lastIndexOf$default((CharSequence)this.fullyQualifiedName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            String string = this.fullyQualifiedName;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(start);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }

        @NotNull
        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @NotNull
        public final List<String> getParamNames() {
            return this.paramNames;
        }

        @Nullable
        public final Language getLanguage() {
            return this.language;
        }

        public MethodInfo(@NotNull String fullyQualifiedName, @NotNull List<String> paramNames, @Nullable Language language) {
            Intrinsics.checkNotNullParameter((Object)fullyQualifiedName, (String)"fullyQualifiedName");
            Intrinsics.checkNotNullParameter(paramNames, (String)"paramNames");
            super(null);
            this.fullyQualifiedName = fullyQualifiedName;
            this.paramNames = paramNames;
            this.language = language;
        }

        public MethodInfo(@NotNull String fullyQualifiedName, @NotNull List<String> paramNames) {
            Intrinsics.checkNotNullParameter((Object)fullyQualifiedName, (String)"fullyQualifiedName");
            Intrinsics.checkNotNullParameter(paramNames, (String)"paramNames");
            this(fullyQualifiedName, paramNames, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "Lcom/intellij/codeInsight/hints/HintInfo;", "option", "Lcom/intellij/codeInsight/hints/Option;", "(Lcom/intellij/codeInsight/hints/Option;)V", "getOption", "()Lcom/intellij/codeInsight/hints/Option;", "optionName", "", "getOptionName", "()Ljava/lang/String;", "alternate", "", "disable", "enable", "isOptionEnabled", "", "intellij.platform.lang"})
    public static class OptionInfo
    extends HintInfo {
        @NotNull
        private final String optionName;
        @NotNull
        private final Option option;

        public void disable() {
            this.alternate();
        }

        public void enable() {
            this.alternate();
        }

        private final void alternate() {
            boolean current = this.option.get();
            this.option.set(!current);
        }

        @NotNull
        public String getOptionName() {
            return this.optionName;
        }

        public final boolean isOptionEnabled() {
            return this.option.isEnabled();
        }

        @NotNull
        protected final Option getOption() {
            return this.option;
        }

        public OptionInfo(@NotNull Option option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            super(null);
            this.option = option;
            this.optionName = this.option.getName();
        }
    }
}

