/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.AWTEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public interface EventWatcher {
    @NotNull
    public static final InstanceHolder ourInstance = new InstanceHolder();

    public static boolean isEnabled() {
        return ourInstance.myIsEnabled;
    }

    @Nullable
    public static EventWatcher getInstanceOrNull() {
        Application application;
        if (!EventWatcher.isEnabled()) {
            return null;
        }
        EventWatcher result = ourInstance.myInstance;
        if (result == null && (application = ApplicationManager.getApplication()) != null && !application.isDisposed() && LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred()) {
            result = (EventWatcher)application.getService(EventWatcher.class);
            ourInstance.myInstance = result;
        }
        return result;
    }

    @RequiresEdt
    public void runnableStarted(@NotNull Runnable var1, long var2);

    @RequiresEdt
    public void runnableFinished(@NotNull Runnable var1, long var2);

    @RequiresEdt
    public void edtEventStarted(@NotNull AWTEvent var1, long var2);

    @RequiresEdt
    public void edtEventFinished(@NotNull AWTEvent var1, long var2);

    public void reset();

    public void logTimeMillis(@NotNull String var1, long var2, @NotNull Class<? extends Runnable> var4);

    default public void logTimeMillis(@NotNull String processId, long startedAt) {
        if (processId == null) {
            EventWatcher.$$$reportNull$$$0(0);
        }
        this.logTimeMillis(processId, startedAt, Runnable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processId", "com/intellij/diagnostic/EventWatcher", "logTimeMillis"));
    }

    public static final class InstanceHolder {
        @Nullable
        private EventWatcher myInstance = null;
        private final boolean myIsEnabled = Boolean.getBoolean("idea.event.queue.dispatch.listen");

        private InstanceHolder() {
        }
    }
}

