/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.IndicatorIcon;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionUtil {
    public static final String PROPERTY_DYNAMIC_CLASSPATH = "dynamic.classpath";
    private static final Logger LOG = Logger.getInstance(ExecutionUtil.class);
    private static final NotificationGroup ourNotificationGroup = NotificationGroup.logOnlyGroup("Execution");

    private ExecutionUtil() {
    }

    public static void handleExecutionError(@NotNull Project project, @NotNull String toolWindowId, @NotNull RunProfile runProfile, @NotNull ExecutionException e) {
        if (project == null) {
            ExecutionUtil.$$$reportNull$$$0(0);
        }
        if (toolWindowId == null) {
            ExecutionUtil.$$$reportNull$$$0(1);
        }
        if (runProfile == null) {
            ExecutionUtil.$$$reportNull$$$0(2);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(3);
        }
        ExecutionUtil.handleExecutionError(project, toolWindowId, runProfile.getName(), (Throwable)e);
    }

    public static void handleExecutionError(@NotNull ExecutionEnvironment environment, @NotNull ExecutionException e) {
        if (environment == null) {
            ExecutionUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(5);
        }
        ExecutionUtil.handleExecutionError(environment.getProject(), RunContentManager.getInstance(environment.getProject()).getToolWindowIdByEnvironment(environment), environment.getRunProfile().getName(), (Throwable)e);
    }

    public static void handleExecutionError(@NotNull Project project, @NotNull String toolWindowId, @NotNull String taskName, @NotNull Throwable e) {
        if (project == null) {
            ExecutionUtil.$$$reportNull$$$0(6);
        }
        if (toolWindowId == null) {
            ExecutionUtil.$$$reportNull$$$0(7);
        }
        if (taskName == null) {
            ExecutionUtil.$$$reportNull$$$0(8);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(9);
        }
        if (e instanceof RunCanceledByUserException) {
            return;
        }
        LOG.debug(e);
        if (e instanceof CantRunException.CustomProcessedCantRunException) {
            return;
        }
        String description = e.getMessage();
        HyperlinkListener listener = null;
        if (ExecutionUtil.isProcessNotCreated(e)) {
            String exePath = ((ProcessNotCreatedException)e).getCommandLine().getExePath();
            if ((SystemInfoRt.isWindows ? exePath.endsWith("java.exe") : exePath.endsWith("java")) && !PropertiesComponent.getInstance(project).isTrueValue(PROPERTY_DYNAMIC_CLASSPATH)) {
                LOG.warn("Java configuration should implement `ConfigurationWithCommandLineShortener` and provide UI to configure shortening method", e);
                description = ExecutionBundle.message("dialog.message.command.line.too.long.notification", new Object[0]);
                listener = event -> PropertiesComponent.getInstance(project).setValue(PROPERTY_DYNAMIC_CLASSPATH, "true");
            }
        }
        ExecutionUtil.handleExecutionError(project, toolWindowId, taskName, e, description, listener);
    }

    public static boolean isProcessNotCreated(@NotNull Throwable e) {
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(10);
        }
        if (e instanceof ProcessNotCreatedException) {
            String description = e.getMessage();
            return (description.contains("87") || description.contains("111") || description.contains("206") || description.contains("error=7,")) && ((ProcessNotCreatedException)e).getCommandLine().getCommandLineString().length() > 32768;
        }
        return false;
    }

    public static void handleExecutionError(@NotNull Project project, @NotNull String toolWindowId, @NotNull String taskName, @NotNull Throwable e, @Nullable @NlsContexts.DialogMessage String description, @Nullable HyperlinkListener listener) {
        if (project == null) {
            ExecutionUtil.$$$reportNull$$$0(11);
        }
        if (toolWindowId == null) {
            ExecutionUtil.$$$reportNull$$$0(12);
        }
        if (taskName == null) {
            ExecutionUtil.$$$reportNull$$$0(13);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(14);
        }
        String title = ExecutionBundle.message("error.running.configuration.message", taskName);
        ExecutionUtil.handleExecutionError(project, toolWindowId, e, title, description, descr -> title + ":<br>" + descr, listener);
    }

    public static void handleExecutionError(@NotNull Project project, @NotNull String toolWindowId, @NotNull Throwable e, @Nls String title, @Nullable @NlsContexts.DialogMessage String description, @NotNull Function<? super @NlsContexts.DialogMessage String, @NlsContexts.DialogMessage String> fullMessageSupplier, @Nullable HyperlinkListener listener) {
        if (project == null) {
            ExecutionUtil.$$$reportNull$$$0(15);
        }
        if (toolWindowId == null) {
            ExecutionUtil.$$$reportNull$$$0(16);
        }
        if (e == null) {
            ExecutionUtil.$$$reportNull$$$0(17);
        }
        if (fullMessageSupplier == null) {
            ExecutionUtil.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmptyOrSpaces((String)description)) {
            LOG.warn("Execution error without description", e);
            description = ExecutionBundle.message("dialog.message.unknown.error", new Object[0]);
        }
        String fullMessage = fullMessageSupplier.apply(description);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(fullMessage, e);
        } else {
            LOG.info(fullMessage, e);
        }
        if (listener == null) {
            listener = (HyperlinkListener)ExceptionUtil.findCause((Throwable)e, HyperlinkListener.class);
        }
        HyperlinkListener _listener = listener;
        String _description = description;
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project.isDisposed()) {
                return;
            }
            IdeUiService.getInstance().notifyByBalloon(project, toolWindowId, MessageType.ERROR, title, fullMessage, _description, null, _listener);
            Notification notification = ourNotificationGroup.createNotification(title, _description, NotificationType.ERROR);
            if (_listener != null) {
                notification.setListener((_notification, event) -> {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        _notification.expire();
                        _listener.hyperlinkUpdate(event);
                    }
                });
            }
            notification.notify(project);
        });
    }

    public static void restartIfActive(@NotNull RunContentDescriptor descriptor) {
        ProcessHandler processHandler;
        if (descriptor == null) {
            ExecutionUtil.$$$reportNull$$$0(19);
        }
        if ((processHandler = descriptor.getProcessHandler()) != null && processHandler.isStartNotified() && !processHandler.isProcessTerminating() && !processHandler.isProcessTerminated()) {
            ExecutionUtil.restart(descriptor);
        }
    }

    public static void restart(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            ExecutionUtil.$$$reportNull$$$0(20);
        }
        ExecutionUtil.restart(descriptor.getComponent());
    }

    public static void restart(@NotNull Content content) {
        if (content == null) {
            ExecutionUtil.$$$reportNull$$$0(21);
        }
        ExecutionUtil.restart(content.getComponent());
    }

    private static void restart(@Nullable JComponent component) {
        ExecutionEnvironment environment;
        if (component != null && (environment = (ExecutionEnvironment)((Object)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext(component)))) != null) {
            ExecutionUtil.restart(environment);
        }
    }

    public static void restart(@NotNull ExecutionEnvironment environment) {
        ExecutionManager executionManager;
        if (environment == null) {
            ExecutionUtil.$$$reportNull$$$0(22);
        }
        if (!(executionManager = ExecutionManager.getInstance(environment.getProject())).isStarting(environment)) {
            executionManager.restartRunProfile(environment);
        }
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(23);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(24);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, null, null, null);
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(25);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(26);
        }
        if (target == null) {
            ExecutionUtil.$$$reportNull$$$0(27);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, target, null, null);
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @NotNull ExecutionTarget target, long executionId) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(28);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(29);
        }
        if (target == null) {
            ExecutionUtil.$$$reportNull$$$0(30);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, target, executionId, null);
    }

    public static void runConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, long executionId) {
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(31);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(32);
        }
        ExecutionUtil.doRunConfiguration(configuration, executor, null, executionId, null);
    }

    public static void doRunConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor, @Nullable ExecutionTarget targetOrNullForDefault, @Nullable Long executionId, @Nullable DataContext dataContext) {
        ExecutionEnvironmentBuilder builder;
        if (configuration == null) {
            ExecutionUtil.$$$reportNull$$$0(33);
        }
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(34);
        }
        if ((builder = ExecutionUtil.createEnvironment(executor, configuration)) == null) {
            return;
        }
        if (targetOrNullForDefault != null) {
            builder.target(targetOrNullForDefault);
        } else {
            builder.activeTarget();
        }
        if (executionId != null) {
            builder.executionId(executionId);
        }
        if (dataContext != null) {
            builder.dataContext(dataContext);
        }
        ExecutionManager.getInstance(configuration.getConfiguration().getProject()).restartRunProfile(builder.build());
    }

    @Nullable
    public static ExecutionEnvironmentBuilder createEnvironment(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        if (executor == null) {
            ExecutionUtil.$$$reportNull$$$0(35);
        }
        if (settings == null) {
            ExecutionUtil.$$$reportNull$$$0(36);
        }
        try {
            return ExecutionEnvironmentBuilder.create(executor, settings);
        }
        catch (ExecutionException e) {
            RunConfiguration configuration = settings.getConfiguration();
            Project project = configuration.getProject();
            RunContentManager manager = RunContentManager.getInstance(project);
            String toolWindowId = manager.getContentDescriptorToolWindowId(configuration);
            if (toolWindowId == null) {
                toolWindowId = executor.getToolWindowId();
            }
            ExecutionUtil.handleExecutionError(project, toolWindowId, configuration.getName(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static Icon getLiveIndicator(@Nullable Icon base) {
        return ExecutionUtil.getLiveIndicator(base, 13, 13);
    }

    @NotNull
    public static Icon getLiveIndicator(@Nullable Icon base, int emptyIconWidth, int emptyIconHeight) {
        return ExecutionUtil.getIndicator(base, emptyIconWidth, emptyIconHeight, Color.GREEN);
    }

    @NotNull
    public static Icon getIndicator(@Nullable Icon base, int emptyIconWidth, int emptyIconHeight, Color color) {
        return new LayeredIcon(new Icon[]{base, new IndicatorIcon(base, emptyIconWidth, emptyIconHeight, color)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullMessageSupplier";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/runners/ExecutionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleExecutionError";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isProcessNotCreated";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "restartIfActive";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "restart";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "runConfiguration";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "doRunConfiguration";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "createEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

