/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(TargetEnvironmentUtil.class);

    public static boolean reuploadRootFile(@NotNull File file, @Nullable TargetEnvironmentRequest request, @NotNull TargetEnvironment remoteEnvironment, @Nullable TargetProgressIndicator indicator, @Nullable Runnable afterUploadCallback) {
        if (file == null) {
            TargetEnvironmentUtil.$$$reportNull$$$0(0);
        }
        if (remoteEnvironment == null) {
            TargetEnvironmentUtil.$$$reportNull$$$0(1);
        }
        if (request == null || request instanceof LocalTargetEnvironmentRequest) {
            return false;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Path parentPath = file.toPath().getParent();
            for (TargetEnvironment.UploadRoot uploadRoot : request.getUploadVolumes()) {
                if (!parentPath.equals(uploadRoot.getLocalRootPath())) continue;
                TargetProgressIndicator targetProgressIndicator = Objects.requireNonNull(indicator);
                try {
                    remoteEnvironment.getUploadVolumes().get(uploadRoot).upload(file.getName(), targetProgressIndicator);
                }
                catch (Throwable t) {
                    LOG.warn(t);
                    targetProgressIndicator.addSystemLine("");
                    targetProgressIndicator.stopWithErrorMessage(ExecutionBundle.message("dialog.message.failed.to.reupload", file.getName(), StringUtil.notNullize((String)t.getLocalizedMessage())));
                }
                if (afterUploadCallback != null) {
                    afterUploadCallback.run();
                }
                return;
            }
            LOG.error("Did not find upload volume for " + parentPath);
            if (afterUploadCallback != null) {
                afterUploadCallback.run();
            }
        });
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "remoteEnvironment";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/target/TargetEnvironmentUtil";
        objectArray[2] = "reuploadRootFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

