/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.Gray;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;

public class TagButton
extends JBLayeredPane
implements Disposable {
    private static final ColorKey TAG_BACKGROUND = ColorKey.createColorKey("Tag.background", JBUI.CurrentTheme.ActionButton.hoverBackground());
    protected final JButton myButton;
    protected static final int ourInset = JBUI.scale((int)3);
    @Nls
    private final String myText;
    public static final Function<JComponent, JComponent> COMPONENT_VALIDATOR_TAG_PROVIDER = e -> ((TagButton)e).myButton;
    protected final InplaceButton myCloseButton;

    public TagButton(@Nls String text2, final Consumer<AnActionEvent> action) {
        this.myText = text2;
        this.myButton = new JButton(text2){
            private final Consumer<Color> setBorderColorFunc;
            {
                this.setBorderColorFunc = c -> this.putClientProperty("JButton.borderColor", c);
            }

            @Override
            protected void paintComponent(Graphics g) {
                this.setBorderColor();
                super.paintComponent(g);
            }

            private void setBorderColor() {
                String outline = (String)ObjectUtils.tryCast((Object)this.getClientProperty("JComponent.outline"), String.class);
                if (outline != null) {
                    if (outline.equals("error")) {
                        this.setBorderColorFunc.accept(JBUI.CurrentTheme.Focus.errorColor((boolean)this.hasFocus()));
                        return;
                    }
                    if (outline.equals("warning")) {
                        this.setBorderColorFunc.accept(JBUI.CurrentTheme.Focus.warningColor((boolean)this.hasFocus()));
                        return;
                    }
                }
                this.setBorderColorFunc.accept(this.hasFocus() ? null : TagButton.getBackgroundColor());
            }
        };
        this.myButton.putClientProperty("styleTag", true);
        this.myButton.putClientProperty("JButton.backgroundColor", TagButton.getBackgroundColor());
        this.myButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (8 == e.getKeyCode() || 127 == e.getKeyCode()) {
                    TagButton.this.remove(action, AnActionEvent.createFromInputEvent(e, "", null, DataContext.EMPTY_CONTEXT));
                }
            }
        });
        this.add((Component)this.myButton, JLayeredPane.DEFAULT_LAYER);
        this.myCloseButton = new InplaceButton(new IconButton(null, AllIcons.Actions.Close, AllIcons.Actions.CloseDarkGrey), a -> this.remove(action, null));
        this.myCloseButton.setOpaque(false);
        new HelpTooltip().setTitle(OptionsBundle.message("tag.button.tooltip", new Object[0])).setShortcut(new KeyboardShortcut(KeyStroke.getKeyStroke(8, 0), null)).installOn(this.myCloseButton);
        this.add((Component)this.myCloseButton, JLayeredPane.POPUP_LAYER);
        this.layoutButtons();
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        this.myButton.removeFocusListener(l);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        this.myButton.addFocusListener(l);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.myButton.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.myButton.removeMouseListener(l);
    }

    @Override
    public boolean hasFocus() {
        return this.myButton.hasFocus();
    }

    public void setToolTip(@Nls String toolTip) {
        this.myButton.setToolTipText(toolTip);
    }

    @Nls
    public String getText() {
        return this.myText;
    }

    protected void layoutButtons() {
        this.myButton.setMargin((Insets)JBUI.emptyInsets());
        Dimension size = this.myButton.getPreferredSize();
        Dimension iconSize = this.myCloseButton.getPreferredSize();
        Dimension tagSize = new Dimension(size.width + iconSize.width - ourInset * 2, size.height);
        this.setPreferredSize(tagSize);
        this.myButton.setBounds(new Rectangle(tagSize));
        this.myButton.setMargin((Insets)JBUI.insetsRight((int)iconSize.width));
        Point p = new Point(tagSize.width - iconSize.width - ourInset * 3, (tagSize.height - iconSize.height) / 2 + JBUI.scale((int)1));
        this.myCloseButton.setBounds(new Rectangle(p, iconSize));
    }

    protected void updateButton(@NlsContexts.Button String text2, Icon icon2) {
        this.myButton.setText(text2);
        this.myButton.setIcon(icon2);
        this.layoutButtons();
    }

    private void remove(Consumer<AnActionEvent> action, AnActionEvent e) {
        this.setVisible(false);
        action.accept(e);
    }

    private static Color getBackgroundColor() {
        return JBColor.namedColor((String)"Tag.background", (Color)Gray.xDF);
    }

    public void dispose() {
    }
}

