/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.execution.ui.TagButton;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JLayeredPane;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantTagFragment<T, V>
extends SettingsEditorFragment<T, TagButton> {
    private V mySelectedVariant;
    private final Supplier<? extends V[]> myVariantsProvider;
    private final Function<? super T, ? extends V> myGetter;
    private final BiConsumer<? super T, ? super V> mySetter;
    private Function<? super V, String> myVariantNameProvider;
    private Function<? super V, String> myVariantHintProvider;
    private Consumer<? super V> myToggleListener;

    public void setVariantNameProvider(Function<? super V, String> variantNameProvider) {
        this.myVariantNameProvider = variantNameProvider;
    }

    public void setVariantHintProvider(Function<? super V, String> variantHintProvider) {
        this.myVariantHintProvider = variantHintProvider;
    }

    public void setToggleListener(Consumer<? super V> toggleListener) {
        this.myToggleListener = toggleListener;
    }

    public static <T, V> VariantTagFragment<T, V> createFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, Supplier<? extends V[]> variantsProvider, Function<? super T, ? extends V> getter2, BiConsumer<? super T, ? super V> setter2, Predicate<? super T> initialSelection) {
        Ref ref = new Ref();
        VariantTagButton tagButton2 = new VariantTagButton(name, e -> ((VariantTagFragment)ref.get()).toggle(false, null));
        VariantTagFragment<? super T, ? super V> fragment = new VariantTagFragment<T, V>(id, name, group, tagButton2, variantsProvider, getter2, setter2, initialSelection);
        tagButton2.myFragment = fragment;
        Disposer.register(fragment, tagButton2);
        ref.set(fragment);
        return fragment;
    }

    public VariantTagFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, TagButton component, Supplier<? extends V[]> variantsProvider, Function<? super T, ? extends V> getter2, BiConsumer<? super T, ? super V> setter2, Predicate<? super T> initialSelection) {
        super(id, name, group, component, null, null, initialSelection);
        this.myVariantsProvider = variantsProvider;
        this.myGetter = getter2;
        this.mySetter = setter2;
    }

    public V getSelectedVariant() {
        return this.mySelectedVariant;
    }

    public void setSelectedVariant(V variant) {
        this.mySelectedVariant = variant;
        this.setSelected(!variant.equals(this.getVariants()[0]));
        ((TagButton)this.component()).updateButton(this.getName() + ": " + this.getVariantName(variant), null);
    }

    protected V[] getVariants() {
        return this.myVariantsProvider.get();
    }

    @Override
    public void toggle(boolean selected, AnActionEvent e) {
        super.toggle(selected, e);
        if (!selected) {
            this.setSelectedVariant(this.getVariants()[0]);
        }
    }

    @Override
    protected void resetEditorFrom(@NotNull T s) {
        if (s == null) {
            VariantTagFragment.$$$reportNull$$$0(0);
        }
        this.setSelectedVariant(this.myGetter.apply(s));
    }

    @Override
    protected void applyEditorTo(@NotNull T s) {
        if (s == null) {
            VariantTagFragment.$$$reportNull$$$0(1);
        }
        this.mySetter.accept(s, this.mySelectedVariant);
        this.validate(s);
    }

    @Nls
    protected String getVariantName(V variant) {
        return this.myVariantNameProvider == null ? StringUtil.capitalize((String)variant.toString()) : this.myVariantNameProvider.apply(variant);
    }

    @Nls
    @Nullable
    protected String getVariantHint(V variant) {
        return this.myVariantHintProvider == null ? null : this.myVariantHintProvider.apply(variant);
    }

    @Override
    public boolean isTag() {
        return true;
    }

    @Override
    @Nullable
    public ActionGroup getCustomActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup(this.getName(), ContainerUtil.map((Object[])this.getVariants(), s -> new ToggleAction(this.getVariantName(s), this.getVariantHint(s), null){

            @Override
            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return s.equals(VariantTagFragment.this.mySelectedVariant);
            }

            @Override
            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                VariantTagFragment.this.setSelectedVariant(s);
                VariantTagFragment.this.fireEditorStateChanged();
                if (VariantTagFragment.this.myToggleListener != null) {
                    VariantTagFragment.this.myToggleListener.accept(s);
                }
                VariantTagFragment.this.logChange(state, e);
            }

            @Override
            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/execution/ui/VariantTagFragment$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().putClientProperty(Presentation.PROP_VALUE, VariantTagFragment.this.getVariantName(VariantTagFragment.this.mySelectedVariant));
                e.getPresentation().setVisible(VariantTagFragment.this.isRemovable());
            }

            @Override
            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/VariantTagFragment$1", "update"));
            }
        };
        group.setPopup(true);
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "s";
        objectArray2[1] = "com/intellij/execution/ui/VariantTagFragment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VariantTagButton<V>
    extends TagButton {
        private final DropDownLink<V> myDropDown = new DropDownLink<Object>(null, (Function1<DropDownLink<Object>, JBPopup>)((Function1)link -> this.showPopup()));
        private VariantTagFragment<?, V> myFragment;

        private VariantTagButton(@Nls String text2, Consumer<AnActionEvent> action) {
            super(text2, action);
            this.myDropDown.setAutoHideOnDisable(false);
            this.add((Component)this.myDropDown, JLayeredPane.POPUP_LAYER);
            this.myButton.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 40) {
                        myDropDown.dispatchEvent(e);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 40) {
                        myDropDown.dispatchEvent(e);
                    }
                }
            });
        }

        private JBPopup showPopup() {
            DataContext context = DataManager.getInstance().getDataContext(this.myDropDown);
            DefaultActionGroup group = new DefaultActionGroup(ContainerUtil.map((Object[])this.myFragment.getVariants(), v -> new DumbAwareAction(this.myFragment.getVariantName(v)){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    myFragment.setSelectedVariant(v);
                    IdeFocusManager.findInstanceByComponent(myButton).requestFocus(myButton, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/VariantTagFragment$VariantTagButton$2", "actionPerformed"));
                }
            }));
            return JBPopupFactory.getInstance().createActionGroupPopup(null, group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        }

        @Override
        protected void layoutButtons() {
            super.layoutButtons();
            int dropDownWidth = 0;
            if (this.myDropDown != null) {
                Dimension preferredSize = this.myDropDown.getPreferredSize();
                dropDownWidth = preferredSize.width - ourInset * 2;
                this.myDropDown.setBounds(new Rectangle(this.myCloseButton.getX() - ourInset * 2, 0, preferredSize.width, this.myButton.getHeight()));
            }
            Insets insets = this.myButton.getMargin();
            insets.right += dropDownWidth;
            this.myButton.setMargin(insets);
            Rectangle closeButtonBounds = this.myCloseButton.getBounds();
            closeButtonBounds.x += dropDownWidth;
            this.myCloseButton.setBounds(closeButtonBounds);
            Rectangle bounds = this.myButton.getBounds();
            bounds.width += dropDownWidth;
            this.myButton.setBounds(bounds);
            this.setPreferredSize(bounds.getSize());
        }

        @Override
        protected void updateButton(String text2, Icon icon2) {
            String[] split2 = text2.split(": ");
            this.myButton.setText(split2[0] + ": ");
            this.myDropDown.setText(split2.length > 1 ? split2[1] : null);
            this.layoutButtons();
        }
    }
}

