/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CollectionComboBoxModel;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LafManager {
    public static LafManager getInstance() {
        return (LafManager)ApplicationManager.getApplication().getService(LafManager.class);
    }

    public abstract UIManager.LookAndFeelInfo @NotNull [] getInstalledLookAndFeels();

    @ApiStatus.Internal
    @NotNull
    public abstract CollectionComboBoxModel<LafReference> getLafComboBoxModel();

    @ApiStatus.Internal
    public abstract UIManager.LookAndFeelInfo findLaf(LafReference var1);

    public abstract UIManager.LookAndFeelInfo getCurrentLookAndFeel();

    @ApiStatus.Internal
    public abstract LafReference getLookAndFeelReference();

    @ApiStatus.Internal
    public abstract ListCellRenderer<LafReference> getLookAndFeelCellRenderer();

    @ApiStatus.Internal
    @NotNull
    public abstract JComponent getSettingsToolbar();

    public void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo lookAndFeelInfo) {
        if (lookAndFeelInfo == null) {
            LafManager.$$$reportNull$$$0(0);
        }
        this.setCurrentLookAndFeel(lookAndFeelInfo, false);
    }

    public abstract void setCurrentLookAndFeel(@NotNull UIManager.LookAndFeelInfo var1, boolean var2);

    public abstract void updateUI();

    public abstract void repaintUI();

    public abstract boolean getAutodetect();

    public abstract void setAutodetect(boolean var1);

    public abstract boolean getAutodetectSupported();

    public abstract void setPreferredDarkLaf(@NotNull UIManager.LookAndFeelInfo var1);

    public abstract void setPreferredLightLaf(@NotNull UIManager.LookAndFeelInfo var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void addLafManagerListener(@NotNull LafManagerListener var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void addLafManagerListener(@NotNull LafManagerListener var1, @NotNull Disposable var2);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract void removeLafManagerListener(@NotNull LafManagerListener var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookAndFeelInfo", "com/intellij/ide/ui/LafManager", "setCurrentLookAndFeel"));
    }

    public static final class LafReference {
        private final String name;
        private final String className;
        private final String themeId;

        public LafReference(@NotNull String name, @Nullable String className, @Nullable String themeId) {
            if (name == null) {
                LafReference.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.className = className;
            this.themeId = themeId;
        }

        @NlsSafe
        @NlsContexts.Label
        public String toString() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String getThemeId() {
            return this.themeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LafReference reference = (LafReference)o;
            return this.name.equals(reference.name) && Objects.equals(this.className, reference.className) && Objects.equals(this.themeId, reference.themeId);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.className, this.themeId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/ui/LafManager$LafReference", "<init>"));
        }
    }
}

