/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.SelectionRequest;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.ide.util.treeView.TreeUpdatePass;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2020.3")
public class AbstractTreeUpdater
implements Disposable,
Activatable {
    private static final Logger LOG = Logger.getInstance(AbstractTreeUpdater.class);
    private final LinkedList<TreeUpdatePass> myNodeQueue;
    private final AbstractTreeBuilder myTreeBuilder;
    private final List<Runnable> myRunAfterUpdate;
    private final MergingUpdateQueue myUpdateQueue;
    private long myUpdateCount;
    private boolean myReleaseRequested;

    public AbstractTreeUpdater(@NotNull AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            AbstractTreeUpdater.$$$reportNull$$$0(0);
        }
        this.myNodeQueue = new LinkedList();
        this.myRunAfterUpdate = new ArrayList<Runnable>();
        this.myTreeBuilder = treeBuilder;
        JTree tree = this.myTreeBuilder.getTree();
        JTree component = tree instanceof TreeTableTree ? ((TreeTableTree)tree).getTreeTable() : tree;
        this.myUpdateQueue = new MergingUpdateQueue("UpdateQueue", 100, component.isShowing(), component);
        this.myUpdateQueue.setRestartTimerOnAdd(false);
        UiNotifyConnector uiNotifyConnector = new UiNotifyConnector(component, this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)this.myUpdateQueue);
        Disposer.register((Disposable)this, (Disposable)uiNotifyConnector);
    }

    public void setDelay(int delay) {
        this.myUpdateQueue.setMergingTimeSpan(delay);
    }

    void setPassThroughMode(boolean passThroughMode) {
        this.myUpdateQueue.setPassThrough(passThroughMode);
    }

    void setModalityStateComponent(JComponent c) {
        this.myUpdateQueue.setModalityStateComponent(c);
    }

    public ModalityState getModalityState() {
        return this.myUpdateQueue.getModalityState();
    }

    public boolean hasNodesToUpdate() {
        return !this.myNodeQueue.isEmpty() || !this.myUpdateQueue.isEmpty();
    }

    public void dispose() {
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public synchronized void addSubtreeToUpdate(@NotNull DefaultMutableTreeNode rootNode) {
        if (rootNode == null) {
            AbstractTreeUpdater.$$$reportNull$$$0(1);
        }
        this.addSubtreeToUpdate(new TreeUpdatePass(rootNode).setUpdateStamp(-1L));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    synchronized void requeue(@NotNull TreeUpdatePass toAdd) {
        if (toAdd == null) {
            AbstractTreeUpdater.$$$reportNull$$$0(2);
        }
        this.addSubtreeToUpdate(toAdd.setUpdateStamp(-1L));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    synchronized void addSubtreeToUpdate(@NotNull TreeUpdatePass toAdd) {
        long newUpdateCount;
        Object element;
        if (toAdd == null) {
            AbstractTreeUpdater.$$$reportNull$$$0(3);
        }
        if (this.myReleaseRequested) {
            return;
        }
        assert (!toAdd.isExpired());
        AbstractTreeUi ui = this.myTreeBuilder.getUi();
        if (ui == null) {
            return;
        }
        if (ui.isUpdatingChildrenNow(toAdd.getNode())) {
            toAdd.expire();
        } else {
            Iterator iterator = this.myNodeQueue.iterator();
            while (iterator.hasNext()) {
                TreeUpdatePass passInQueue = (TreeUpdatePass)iterator.next();
                boolean isMatchingPass = toAdd.isUpdateStructure() == passInQueue.isUpdateStructure() && toAdd.isUpdateChildren() == passInQueue.isUpdateChildren();
                if (!isMatchingPass) continue;
                if (passInQueue == toAdd) {
                    toAdd.expire();
                    break;
                }
                if (passInQueue.getNode() == toAdd.getNode()) {
                    toAdd.expire();
                    break;
                }
                if (toAdd.getNode().isNodeAncestor(passInQueue.getNode())) {
                    toAdd.expire();
                    break;
                }
                if (!passInQueue.getNode().isNodeAncestor(toAdd.getNode())) continue;
                iterator.remove();
                passInQueue.expire();
            }
        }
        if (!(toAdd.getUpdateStamp() < 0L || (element = ui.getElementFor(toAdd.getNode())) != null && ui.isParentLoadingInBackground(element) || ui.isParentUpdatingChildrenNow(toAdd.getNode()))) {
            toAdd.setUpdateStamp(-1L);
        }
        long l = newUpdateCount = toAdd.getUpdateStamp() == -1L ? this.myUpdateCount : this.myUpdateCount + 1L;
        if (!toAdd.isExpired()) {
            Collection<TreeUpdatePass> yielding = ui.getYeildingPasses();
            for (TreeUpdatePass eachYielding : yielding) {
                DefaultMutableTreeNode eachNode = eachYielding.getCurrentNode();
                if (eachNode == null || !eachNode.isNodeAncestor(toAdd.getNode())) continue;
                eachYielding.setUpdateStamp(newUpdateCount);
            }
        }
        if (toAdd.isExpired()) {
            this.reQueueViewUpdateIfNeeded();
            return;
        }
        this.myNodeQueue.add(toAdd);
        ui.addActivity();
        this.myUpdateCount = newUpdateCount;
        toAdd.setUpdateStamp(this.myUpdateCount);
        this.reQueueViewUpdate();
    }

    private void reQueueViewUpdateIfNeeded() {
        if (this.myUpdateQueue.isEmpty() && !this.myNodeQueue.isEmpty()) {
            this.reQueueViewUpdate();
        }
    }

    private void reQueueViewUpdate() {
        this.queue(new Update("ViewUpdate"){

            @Override
            public boolean isExpired() {
                return AbstractTreeUpdater.this.myTreeBuilder.isDisposed();
            }

            @Override
            public void run() {
                AbstractTreeStructure structure = AbstractTreeUpdater.this.myTreeBuilder.getTreeStructure();
                if (structure.hasSomethingToCommit()) {
                    structure.asyncCommit().doWhenDone(new TreeRunnable("AbstractTreeUpdater.reQueueViewUpdate"){

                        @Override
                        public void perform() {
                            AbstractTreeUpdater.this.reQueueViewUpdateIfNeeded();
                        }
                    });
                    return;
                }
                try {
                    AbstractTreeUpdater.this.performUpdate();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    LOG.error(AbstractTreeUpdater.this.myTreeBuilder.getClass().getName(), (Throwable)e);
                }
            }
        });
    }

    private void queue(@NotNull Update update) {
        if (update == null) {
            AbstractTreeUpdater.$$$reportNull$$$0(4);
        }
        if (this.isReleased()) {
            return;
        }
        this.myUpdateQueue.queue(update);
    }

    public synchronized void performUpdate() {
        while (!this.myNodeQueue.isEmpty() && !this.isInPostponeMode()) {
            final TreeUpdatePass eachPass = this.myNodeQueue.removeFirst();
            this.beforeUpdate(eachPass).doWhenDone(new TreeRunnable("AbstractTreeUpdater.performUpdate"){

                @Override
                public void perform() {
                    try {
                        AbstractTreeUi ui = AbstractTreeUpdater.this.myTreeBuilder.getUi();
                        if (ui != null) {
                            ui.updateSubtreeNow(eachPass, false);
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                }
            });
        }
        AbstractTreeUi ui = this.myTreeBuilder.getUi();
        if (ui == null) {
            return;
        }
        ui.maybeReady();
        this.maybeRunAfterUpdate();
    }

    private void maybeRunAfterUpdate() {
        TreeRunnable runnable = new TreeRunnable("AbstractTreeUpdater.maybeRunAfterUpdate"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                ArrayList<Runnable> runAfterUpdate = null;
                List<Runnable> list = AbstractTreeUpdater.this.myRunAfterUpdate;
                synchronized (list) {
                    if (!AbstractTreeUpdater.this.myRunAfterUpdate.isEmpty()) {
                        runAfterUpdate = new ArrayList<Runnable>(AbstractTreeUpdater.this.myRunAfterUpdate);
                        AbstractTreeUpdater.this.myRunAfterUpdate.clear();
                    }
                }
                if (runAfterUpdate != null) {
                    for (Runnable r : runAfterUpdate) {
                        r.run();
                    }
                }
            }
        };
        this.myTreeBuilder.getReady(this).doWhenDone(runnable);
    }

    private boolean isReleased() {
        return this.myTreeBuilder.getUi() == null;
    }

    protected ActionCallback beforeUpdate(TreeUpdatePass pass) {
        return ActionCallback.DONE;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public boolean addSubtreeToUpdateByElement(@NotNull Object element) {
        DefaultMutableTreeNode node;
        if (element == null) {
            AbstractTreeUpdater.$$$reportNull$$$0(5);
        }
        if ((node = this.myTreeBuilder.getNodeForElement(element)) != null) {
            this.myTreeBuilder.queueUpdateFrom(element, false);
            return true;
        }
        return false;
    }

    public synchronized void cancelAllRequests() {
        this.myNodeQueue.clear();
        this.myUpdateQueue.cancelAllUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterUpdate(Runnable runnable) {
        if (runnable != null) {
            List<Runnable> list = this.myRunAfterUpdate;
            synchronized (list) {
                this.myRunAfterUpdate.add(runnable);
            }
        }
    }

    public synchronized long getUpdateCount() {
        return this.myUpdateCount;
    }

    boolean isRerunNeededFor(TreeUpdatePass pass) {
        return pass.getUpdateStamp() < this.getUpdateCount();
    }

    boolean isInPostponeMode() {
        return !this.myUpdateQueue.isActive() && !this.myUpdateQueue.isPassThrough();
    }

    @Override
    public void showNotify() {
        this.myUpdateQueue.showNotify();
    }

    @Override
    public void hideNotify() {
        this.myUpdateQueue.hideNotify();
    }

    @NonNls
    public synchronized String toString() {
        return "AbstractTreeUpdater updateCount=" + this.myUpdateCount + " queue=[" + this.myUpdateQueue + "]  nodeQueue=" + this.myNodeQueue + " builder=" + this.myTreeBuilder;
    }

    public void flush() {
        this.myUpdateQueue.sendFlush();
    }

    synchronized boolean isEnqueuedToUpdate(DefaultMutableTreeNode node) {
        for (TreeUpdatePass pass : this.myNodeQueue) {
            if (!pass.willUpdate(node)) continue;
            return true;
        }
        return false;
    }

    final void queueSelection(final SelectionRequest request) {
        this.queue(new Update("UserSelection", 999){

            @Override
            public void run() {
                AbstractTreeUi ui = AbstractTreeUpdater.this.myTreeBuilder.getUi();
                if (ui != null) {
                    request.execute(ui);
                }
            }

            @Override
            public boolean isExpired() {
                return AbstractTreeUpdater.this.myTreeBuilder.isDisposed();
            }

            @Override
            public void setRejected() {
                request.reject();
            }
        });
    }

    public synchronized void requestRelease() {
        this.myReleaseRequested = true;
        this.reset();
        this.myUpdateQueue.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        TreeUpdatePass[] passes;
        AbstractTreeUpdater abstractTreeUpdater = this;
        synchronized (abstractTreeUpdater) {
            passes = this.myNodeQueue.toArray(new TreeUpdatePass[0]);
            this.myNodeQueue.clear();
        }
        this.myUpdateQueue.cancelAllUpdates();
        AbstractTreeUi ui = this.myTreeBuilder.getUi();
        if (ui != null) {
            for (TreeUpdatePass each : passes) {
                ui.addToCancelled(each.getNode());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/treeView/AbstractTreeUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addSubtreeToUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "requeue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "queue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addSubtreeToUpdateByElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

