/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStyleFieldAccessor;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleProvider;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageCodeStyleSettingsProvider
extends CodeStyleSettingsProvider
implements LanguageCodeStyleProvider {
    public static final ExtensionPointName<LanguageCodeStyleSettingsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.langCodeStyleSettingsProvider");
    private static final AtomicReference<Set<LanguageCodeStyleSettingsProvider>> ourSettingsPagesProviders = new AtomicReference();

    @Nullable
    public abstract String getCodeSample(@NotNull SettingsType var1);

    public int getRightMargin(@NotNull SettingsType settingsType) {
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return settingsType == SettingsType.WRAPPING_AND_BRACES_SETTINGS ? 30 : -1;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer2, @NotNull SettingsType settingsType) {
        if (consumer2 == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
    }

    @Nullable
    public String getFileExt() {
        return null;
    }

    @Nullable
    @NlsContexts.Label
    public String getLanguageName() {
        return null;
    }

    @NotNull
    public String getExternalLanguageId() {
        String string = StringUtil.toLowerCase((String)this.getLanguage().getID());
        if (string == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text2) {
        return null;
    }

    @Override
    @Deprecated
    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings defaultSettings = new CommonCodeStyleSettings(this.getLanguage());
        defaultSettings.initIndentOptions();
        this.customizeDefaults(defaultSettings, defaultSettings.getIndentOptions());
        CommonCodeStyleSettings commonCodeStyleSettings = defaultSettings;
        if (commonCodeStyleSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return commonCodeStyleSettings;
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (indentOptions == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
    }

    @Deprecated
    public DisplayPriority getDisplayPriority() {
        return this.getPriority();
    }

    public List<Language> getApplicableLanguages() {
        return LanguageCodeStyleSettingsProvider.getLanguagesWithCodeStyleSettings();
    }

    @NotNull
    public static List<Language> getLanguagesWithCodeStyleSettings() {
        ArrayList<Language> languages = new ArrayList<Language>();
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            languages.add(provider.getLanguage());
        }
        languages.sort((l1, l2) -> Comparing.compare((Comparable)((Object)LanguageCodeStyleSettingsProvider.getLanguageName(l1)), (Comparable)((Object)LanguageCodeStyleSettingsProvider.getLanguageName(l2))));
        ArrayList<Language> arrayList = languages;
        if (arrayList == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    public static String getCodeSample(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return (provider = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider.getCodeSample(settingsType) : null;
    }

    public static int getRightMargin(Language lang, @NotNull SettingsType settingsType) {
        LanguageCodeStyleSettingsProvider provider;
        if (settingsType == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        return (provider = LanguageCodeStyleSettingsProvider.forLanguage(lang)) != null ? provider.getRightMargin(settingsType) : -1;
    }

    @Override
    @NotNull
    public abstract Language getLanguage();

    @Nullable
    public static Language getLanguage(String langName) {
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            String name = provider.getLanguageName();
            if (name == null) {
                name = provider.getLanguage().getDisplayName();
            }
            if (!langName.equals(name)) continue;
            return provider.getLanguage();
        }
        return null;
    }

    @Nullable
    public static CommonCodeStyleSettings getDefaultCommonSettings(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getDefaultCommonSettings() : null;
    }

    @Nullable
    public static String getFileExt(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        return provider != null ? provider.getFileExt() : null;
    }

    @NotNull
    @NlsSafe
    public static String getLanguageName(Language lang) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(lang);
        String providerLangName = provider != null ? provider.getLanguageName() : null;
        String string = providerLangName != null ? providerLangName : lang.getDisplayName();
        if (string == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    public static PsiFile createFileFromText(Language language, Project project, String text2) {
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(language);
        return provider != null ? provider.createFileFromText(project, text2) : null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider forLanguage(Language language) {
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            if (!((Object)((Object)provider.getLanguage())).equals((Object)language)) continue;
            return provider;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findUsingBaseLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        for (Language currLang = language; currLang != null; currLang = currLang.getBaseLanguage()) {
            LanguageCodeStyleSettingsProvider curr = LanguageCodeStyleSettingsProvider.forLanguage(currLang);
            if (curr == null) continue;
            return curr;
        }
        return null;
    }

    @Nullable
    public static LanguageCodeStyleSettingsProvider findByExternalLanguageId(@NotNull String languageId) {
        if (languageId == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        return (LanguageCodeStyleSettingsProvider)ContainerUtil.find((Iterable)EP_NAME.getExtensionList(), provider -> provider.getExternalLanguageId().equals(languageId));
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return null;
    }

    @Override
    public Set<String> getSupportedFields() {
        return new SupportedFieldCollector().collectFields();
    }

    public Set<String> getSupportedFields(SettingsType type) {
        return new SupportedFieldCollector().collectFields(type);
    }

    @Override
    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(13);
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(14);
        }
        return docCommentSettings;
    }

    @Override
    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(15);
        }
        if (modelSettings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(16);
        }
        throw new RuntimeException(this.getClass().getCanonicalName() + " for language #" + this.getLanguage().getID() + " doesn't implement createConfigurable()");
    }

    @ApiStatus.Internal
    public static void resetSettingsPagesProviders() {
        ourSettingsPagesProviders.set(null);
    }

    public static Set<LanguageCodeStyleSettingsProvider> getSettingsPagesProviders() {
        return ourSettingsPagesProviders.updateAndGet(__ -> __ != null ? __ : LanguageCodeStyleSettingsProvider.calcSettingPagesProviders());
    }

    @NotNull
    protected static Set<LanguageCodeStyleSettingsProvider> calcSettingPagesProviders() {
        HashSet<LanguageCodeStyleSettingsProvider> settingsPagesProviders = new HashSet<LanguageCodeStyleSettingsProvider>();
        for (LanguageCodeStyleSettingsProvider provider : EP_NAME.getExtensionList()) {
            LanguageCodeStyleSettingsProvider.registerSettingsPageProvider(settingsPagesProviders, provider);
        }
        HashSet<LanguageCodeStyleSettingsProvider> hashSet = settingsPagesProviders;
        if (hashSet == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    @ApiStatus.Internal
    public static void registerSettingsPageProvider(@NotNull LanguageCodeStyleSettingsProvider provider) {
        if (provider == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(18);
        }
        LanguageCodeStyleSettingsProvider.registerSettingsPageProvider(LanguageCodeStyleSettingsProvider.getSettingsPagesProviders(), provider);
    }

    @ApiStatus.Internal
    public static void unregisterSettingsPageProvider(@NotNull LanguageCodeStyleSettingsProvider provider) {
        if (provider == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(19);
        }
        LanguageCodeStyleSettingsProvider.getSettingsPagesProviders().remove(provider);
    }

    private static void registerSettingsPageProvider(@NotNull Set<? super LanguageCodeStyleSettingsProvider> settingsPagesProviders, @NotNull LanguageCodeStyleSettingsProvider provider) {
        if (settingsPagesProviders == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(20);
        }
        if (provider == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(21);
        }
        try {
            Method configMethod = provider.getClass().getMethod("createConfigurable", CodeStyleSettings.class, CodeStyleSettings.class);
            Class<?> declaringClass = configMethod.getDeclaringClass();
            if (!declaringClass.equals(LanguageCodeStyleSettingsProvider.class)) {
                settingsPagesProviders.add(provider);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @ApiStatus.Experimental
    @NotNull
    public final AbstractCodeStylePropertyMapper getPropertyMapper(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(22);
        }
        return new LanguageCodeStylePropertyMapper(settings, this.getLanguage(), this.getExternalLanguageId());
    }

    @ApiStatus.Experimental
    @Nullable
    public CodeStyleFieldAccessor getAccessor(@NotNull Object codeStyleObject, @NotNull Field field) {
        if (codeStyleObject == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(23);
        }
        if (field == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(24);
        }
        return null;
    }

    public List<CodeStylePropertyAccessor> getAdditionalAccessors(@NotNull Object codeStyleObject) {
        if (codeStyleObject == null) {
            LanguageCodeStyleSettingsProvider.$$$reportNull$$$0(25);
        }
        return Collections.emptyList();
    }

    public boolean supportsExternalFormats() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsPagesProviders";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleObject";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLanguageId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCommonSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesWithCodeStyleSettings";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSettingPagesProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findUsingBaseLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findByExternalLanguageId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerSettingsPageProvider";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSettingsPageProvider";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyMapper";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAccessor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAccessors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class SupportedFieldCollector
    implements CodeStyleSettingsCustomizable {
        private final Set<String> myCollectedFields = new HashSet<String>();
        private SettingsType myCurrSettingsType;

        private SupportedFieldCollector() {
        }

        public Set<String> collectFields() {
            SettingsType[] settingsTypeArray = SettingsType.values();
            int n = settingsTypeArray.length;
            for (int j = 0; j < n; ++j) {
                SettingsType settingsType;
                this.myCurrSettingsType = settingsType = settingsTypeArray[j];
                LanguageCodeStyleSettingsProvider.this.customizeSettings(this, settingsType);
            }
            return this.myCollectedFields;
        }

        public Set<String> collectFields(SettingsType type) {
            this.myCurrSettingsType = type;
            LanguageCodeStyleSettingsProvider.this.customizeSettings(this, type);
            return this.myCollectedFields;
        }

        @Override
        public void showAllStandardOptions() {
            switch (this.myCurrSettingsType) {
                case BLANK_LINES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.BlankLinesOption blankLinesOption : CodeStyleSettingsCustomizable.BlankLinesOption.values()) {
                        this.myCollectedFields.add(blankLinesOption.name());
                    }
                    break;
                }
                case SPACING_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.SpacingOption spacingOption : CodeStyleSettingsCustomizable.SpacingOption.values()) {
                        this.myCollectedFields.add(spacingOption.name());
                    }
                    break;
                }
                case WRAPPING_AND_BRACES_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.WrappingOrBraceOption wrappingOrBraceOption : CodeStyleSettingsCustomizable.WrappingOrBraceOption.values()) {
                        this.myCollectedFields.add(wrappingOrBraceOption.name());
                    }
                    break;
                }
                case COMMENTER_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.CommenterOption commenterOption : CodeStyleSettingsCustomizable.CommenterOption.values()) {
                        this.myCollectedFields.add(commenterOption.name());
                    }
                    break;
                }
                case INDENT_SETTINGS: {
                    for (CodeStyleSettingsCustomizable.IndentOption indentOption : CodeStyleSettingsCustomizable.IndentOption.values()) {
                        this.myCollectedFields.add(indentOption.name());
                    }
                    break;
                }
            }
        }

        @Override
        public void showStandardOptions(String ... optionNames) {
            ContainerUtil.addAll(this.myCollectedFields, (Object[])optionNames);
        }

        @Override
        public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, Object ... options) {
            if (settingsClass == null) {
                SupportedFieldCollector.$$$reportNull$$$0(0);
            }
            if (fieldName == null) {
                SupportedFieldCollector.$$$reportNull$$$0(1);
            }
            if (title == null) {
                SupportedFieldCollector.$$$reportNull$$$0(2);
            }
            this.myCollectedFields.add(fieldName);
        }

        @Override
        public void showCustomOption(@NotNull Class<? extends CustomCodeStyleSettings> settingsClass, @NonNls @NotNull String fieldName, @NlsContexts.Label @NotNull String title, @Nls @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @NonNls @Nullable String anchorFieldName, Object ... options) {
            if (settingsClass == null) {
                SupportedFieldCollector.$$$reportNull$$$0(3);
            }
            if (fieldName == null) {
                SupportedFieldCollector.$$$reportNull$$$0(4);
            }
            if (title == null) {
                SupportedFieldCollector.$$$reportNull$$$0(5);
            }
            this.myCollectedFields.add(fieldName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingsClass";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fieldName";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SupportedFieldCollector";
            objectArray[2] = "showCustomOption";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum SettingsType {
        BLANK_LINES_SETTINGS,
        SPACING_SETTINGS,
        WRAPPING_AND_BRACES_SETTINGS,
        INDENT_SETTINGS,
        COMMENTER_SETTINGS,
        LANGUAGE_SPECIFIC;

    }
}

