/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.ByModifierArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNameArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNamespaceArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTypeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.CompositeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrangementUtil {
    private static final Logger LOG = Logger.getInstance(ArrangementUtil.class);

    private ArrangementUtil() {
    }

    @Nullable
    public static ArrangementSettings getArrangementSettings(@NotNull CodeStyleSettings settings, @NotNull Language language) {
        ArrangementSettings arrangementSettings;
        if (settings == null) {
            ArrangementUtil.$$$reportNull$$$0(0);
        }
        if (language == null) {
            ArrangementUtil.$$$reportNull$$$0(1);
        }
        if ((arrangementSettings = settings.getCommonSettings(language).getArrangementSettings()) != null) {
            return arrangementSettings;
        }
        Rearranger<?> rearranger = Rearranger.EXTENSION.forLanguage(language);
        if (rearranger instanceof ArrangementStandardSettingsAware) {
            return ((ArrangementStandardSettingsAware)((Object)rearranger)).getDefaultSettings();
        }
        return null;
    }

    @Nullable
    public static ArrangementSettings readExternal(@NotNull Element element, @NotNull Language language) {
        ArrangementSettingsSerializer serializer;
        if (element == null) {
            ArrangementUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            ArrangementUtil.$$$reportNull$$$0(3);
        }
        if ((serializer = ArrangementUtil.getSerializer(language)) == null) {
            LOG.warn("Can't find serializer for language: " + language.getDisplayName() + "(" + language.getID() + ")");
            return null;
        }
        return serializer.deserialize(element);
    }

    public static void writeExternal(@NotNull Element element, @NotNull ArrangementSettings settings, @NotNull Language language) {
        ArrangementSettingsSerializer serializer;
        if (element == null) {
            ArrangementUtil.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            ArrangementUtil.$$$reportNull$$$0(5);
        }
        if (language == null) {
            ArrangementUtil.$$$reportNull$$$0(6);
        }
        if ((serializer = ArrangementUtil.getSerializer(language)) == null) {
            LOG.error("Can't find serializer for language: " + language.getDisplayName() + "(" + language.getID() + ")");
            return;
        }
        serializer.serialize(settings, element);
    }

    @Nullable
    private static ArrangementSettingsSerializer getSerializer(@NotNull Language language) {
        Rearranger<?> rearranger;
        if (language == null) {
            ArrangementUtil.$$$reportNull$$$0(7);
        }
        return (rearranger = Rearranger.EXTENSION.forLanguage(language)) == null ? null : rearranger.getSerializer();
    }

    @NotNull
    public static ArrangementMatchCondition combine(ArrangementMatchCondition ... nodes) {
        if (nodes == null) {
            ArrangementUtil.$$$reportNull$$$0(8);
        }
        final ArrangementCompositeMatchCondition result = new ArrangementCompositeMatchCondition();
        ArrangementMatchConditionVisitor visitor = new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.addOperand(node);
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (ArrangementMatchCondition operand : node.getOperands()) {
                    operand.invite(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$1", "visit"));
            }
        };
        for (ArrangementMatchCondition node : nodes) {
            node.invite(visitor);
        }
        ArrangementMatchCondition arrangementMatchCondition = result.getOperands().size() == 1 ? result.getOperands().iterator().next() : result;
        if (arrangementMatchCondition == null) {
            ArrangementUtil.$$$reportNull$$$0(9);
        }
        return arrangementMatchCondition;
    }

    @NotNull
    public static TextRange expandToLineIfPossible(@NotNull TextRange initialRange, @NotNull Document document) {
        if (initialRange == null) {
            ArrangementUtil.$$$reportNull$$$0(10);
        }
        if (document == null) {
            ArrangementUtil.$$$reportNull$$$0(11);
        }
        CharSequence text2 = document.getCharsSequence();
        String ws = " \t";
        int startLine = document.getLineNumber(initialRange.getStartOffset());
        int lineStartOffset = document.getLineStartOffset(startLine);
        int i2 = CharArrayUtil.shiftBackward((CharSequence)text2, (int)(lineStartOffset + 1), (int)(initialRange.getStartOffset() - 1), (String)ws);
        if (i2 != lineStartOffset) {
            TextRange textRange = initialRange;
            if (textRange == null) {
                ArrangementUtil.$$$reportNull$$$0(12);
            }
            return textRange;
        }
        int endLine = document.getLineNumber(initialRange.getEndOffset());
        int lineEndOffset = document.getLineEndOffset(endLine);
        i2 = CharArrayUtil.shiftForward((CharSequence)text2, (int)initialRange.getEndOffset(), (int)lineEndOffset, (String)ws);
        TextRange textRange = i2 == lineEndOffset ? TextRange.create((int)lineStartOffset, (int)lineEndOffset) : initialRange;
        if (textRange == null) {
            ArrangementUtil.$$$reportNull$$$0(13);
        }
        return textRange;
    }

    @Nullable
    public static ArrangementSettingsToken parseType(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            ArrangementUtil.$$$reportNull$$$0(14);
        }
        final Ref result = new Ref();
        condition.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    2.$$$reportNull$$$0(0);
                }
                ArrangementSettingsToken type = condition.getType();
                if (StdArrangementTokenType.ENTRY_TYPE.is(condition.getType()) || StdArrangementTokens.Modifier.MODIFIER_AS_TYPE.contains(type)) {
                    result.set((Object)condition.getType());
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                    if (result.get() == null) continue;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$2", "visit"));
            }
        });
        return (ArrangementSettingsToken)result.get();
    }

    public static <T> Set<T> flatten(@NotNull Iterable<? extends Iterable<? extends T>> data) {
        if (data == null) {
            ArrangementUtil.$$$reportNull$$$0(15);
        }
        HashSet<T> result = new HashSet<T>();
        for (Iterable<T> i2 : data) {
            for (T t : i2) {
                result.add(t);
            }
        }
        return result;
    }

    @NotNull
    public static Map<ArrangementSettingsToken, Object> extractTokens(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            ArrangementUtil.$$$reportNull$$$0(16);
        }
        final HashMap<ArrangementSettingsToken, Object> result = new HashMap<ArrangementSettingsToken, Object>();
        condition.invite(new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                if (condition == null) {
                    3.$$$reportNull$$$0(0);
                }
                ArrangementSettingsToken type = condition.getType();
                Object value2 = condition.getValue();
                result.put(condition.getType(), type.equals(value2) ? null : value2);
                if (type instanceof CompositeArrangementToken) {
                    Set<ArrangementSettingsToken> tokens = ((CompositeArrangementToken)type).getAdditionalTokens();
                    for (ArrangementSettingsToken token : tokens) {
                        result.put(token, null);
                    }
                }
            }

            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    3.$$$reportNull$$$0(1);
                }
                for (ArrangementMatchCondition operand : condition.getOperands()) {
                    operand.invite(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$3", "visit"));
            }
        });
        HashMap<ArrangementSettingsToken, Object> hashMap = result;
        if (hashMap == null) {
            ArrangementUtil.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    @Nullable
    public static ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            ArrangementUtil.$$$reportNull$$$0(18);
        }
        final Ref result = new Ref();
        final Stack composites = new Stack();
        ArrangementMatchConditionVisitor visitor = new ArrangementMatchConditionVisitor(){

            @Override
            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                ArrangementEntryMatcher matcher;
                if (condition == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((matcher = ArrangementUtil.buildMatcher(condition)) == null) {
                    return;
                }
                if (composites.isEmpty()) {
                    result.set((Object)matcher);
                } else {
                    ((CompositeArrangementEntryMatcher)composites.peek()).addMatcher(matcher);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    4.$$$reportNull$$$0(1);
                }
                composites.push((Object)new CompositeArrangementEntryMatcher(new ArrangementEntryMatcher[0]));
                try {
                    for (ArrangementMatchCondition operand : condition.getOperands()) {
                        operand.invite(this);
                    }
                }
                finally {
                    CompositeArrangementEntryMatcher matcher = (CompositeArrangementEntryMatcher)composites.pop();
                    if (composites.isEmpty()) {
                        result.set((Object)matcher);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/psi/codeStyle/arrangement/ArrangementUtil$4", "visit"));
            }
        };
        condition.invite(visitor);
        return (ArrangementEntryMatcher)result.get();
    }

    @Nullable
    public static ArrangementEntryMatcher buildMatcher(@NotNull ArrangementAtomMatchCondition condition) {
        if (condition == null) {
            ArrangementUtil.$$$reportNull$$$0(19);
        }
        if (StdArrangementTokenType.ENTRY_TYPE.is(condition.getType())) {
            return new ByTypeArrangementEntryMatcher(condition);
        }
        if (StdArrangementTokenType.MODIFIER.is(condition.getType())) {
            return new ByModifierArrangementEntryMatcher(condition);
        }
        if (StdArrangementTokens.Regexp.NAME.equals(condition.getType())) {
            return new ByNameArrangementEntryMatcher(condition.getValue().toString());
        }
        if (StdArrangementTokens.Regexp.XML_NAMESPACE.equals(condition.getType())) {
            return new ByNamespaceArrangementEntryMatcher(condition.getValue().toString());
        }
        return null;
    }

    @NotNull
    public static List<CompositeArrangementSettingsToken> flatten(@NotNull CompositeArrangementSettingsToken base) {
        if (base == null) {
            ArrangementUtil.$$$reportNull$$$0(20);
        }
        ArrayList<CompositeArrangementSettingsToken> result = new ArrayList<CompositeArrangementSettingsToken>();
        LinkedList toProcess = ContainerUtil.newLinkedList((Object[])new CompositeArrangementSettingsToken[]{base});
        while (!toProcess.isEmpty()) {
            CompositeArrangementSettingsToken token = (CompositeArrangementSettingsToken)toProcess.remove();
            result.add(token);
            toProcess.addAll(token.getChildren());
        }
        ArrayList<CompositeArrangementSettingsToken> arrayList = result;
        if (arrayList == null) {
            ArrangementUtil.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @NotNull
    public static List<StdArrangementMatchRule> collectMatchRules(@NotNull List<? extends ArrangementSectionRule> sections) {
        if (sections == null) {
            ArrangementUtil.$$$reportNull$$$0(22);
        }
        ArrayList<StdArrangementMatchRule> matchRules = new ArrayList<StdArrangementMatchRule>();
        for (ArrangementSectionRule arrangementSectionRule : sections) {
            matchRules.addAll(arrangementSectionRule.getMatchRules());
        }
        ArrayList<StdArrangementMatchRule> arrayList = matchRules;
        if (arrayList == null) {
            ArrangementUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    public static List<ArrangementSectionRule> getExtendedSectionRules(@NotNull ArrangementSettings settings) {
        if (settings == null) {
            ArrangementUtil.$$$reportNull$$$0(24);
        }
        return settings instanceof ArrangementExtendableSettings ? ((ArrangementExtendableSettings)settings).getExtendedSectionRules() : settings.getSections();
    }

    public static boolean isAliasedCondition(@NotNull ArrangementAtomMatchCondition condition) {
        if (condition == null) {
            ArrangementUtil.$$$reportNull$$$0(25);
        }
        return StdArrangementTokenType.ALIAS.is(condition.getType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/ArrangementUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/ArrangementUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "combine";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "expandToLineIfPossible";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTokens";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMatchRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getArrangementSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSerializer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "combine";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "expandToLineIfPossible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 15: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractTokens";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchRules";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedSectionRules";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAliasedCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

