/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.presentation;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.presentation.CodeStyleBoundedIntegerSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleCommaSeparatedIdentifiersPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSelectSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSettingPresentation;
import com.intellij.psi.codeStyle.presentation.CodeStyleSoftMarginsPresentation;
import com.intellij.util.LocaleSensitiveApplicationCacheService;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class CodeStyleSettingsPresentations {
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> myBlankLinesStandardSettings;
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> mySpacingStandardSettings;
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> myWrappingAndBracesStandardSettings;
    @NotNull
    private final Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> myIndentStandardSettings;

    private CodeStyleSettingsPresentations() {
        LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> result = new LinkedHashMap<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>>();
        CodeStyleSettingsCustomizableOptions customizableOptions = CodeStyleSettingsCustomizableOptions.getInstance();
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.BLANK_LINES_KEEP), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("KEEP_BLANK_LINES_IN_DECLARATIONS", ApplicationBundle.message("editbox.keep.blanklines.in.declarations", new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_IN_CODE", ApplicationBundle.message("editbox.keep.blanklines.in.code", new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_BEFORE_RBRACE", ApplicationBundle.message("editbox.keep.blanklines.before.rbrace", new Object[0])), new CodeStyleSettingPresentation("KEEP_BLANK_LINES_BETWEEN_PACKAGE_DECLARATION_AND_HEADER", ApplicationBundle.message("editbox.keep.blanklines.between.header.and.package", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.BLANK_LINES), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_PACKAGE", ApplicationBundle.message("editbox.blanklines.before.package.statement", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_PACKAGE", ApplicationBundle.message("editbox.blanklines.after.package.statement", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_IMPORTS", ApplicationBundle.message("editbox.blanklines.before.imports", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_IMPORTS", ApplicationBundle.message("editbox.blanklines.after.imports", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_CLASS", ApplicationBundle.message("editbox.blanklines.around.class", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_CLASS_HEADER", ApplicationBundle.message("editbox.blanklines.after.class.header", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_CLASS_END", ApplicationBundle.message("editbox.blanklines.before.class.end", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AFTER_ANONYMOUS_CLASS_HEADER", ApplicationBundle.message("editbox.blanklines.after.anonymous.class.header", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_FIELD_IN_INTERFACE", ApplicationBundle.message("editbox.blanklines.around.field.in.interface", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_FIELD", ApplicationBundle.message("editbox.blanklines.around.field", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_METHOD_IN_INTERFACE", ApplicationBundle.message("editbox.blanklines.around.method.in.interface", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_AROUND_METHOD", ApplicationBundle.message("editbox.blanklines.around.method", new Object[0])), new CodeStyleSettingPresentation("BLANK_LINES_BEFORE_METHOD_BODY", ApplicationBundle.message("editbox.blanklines.before.method.body", new Object[0]))}));
        this.myBlankLinesStandardSettings = Collections.unmodifiableMap(result);
        result = new LinkedHashMap();
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_BEFORE_PARENTHESES), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_PARENTHESES", ApplicationBundle.message("checkbox.spaces.method.declaration.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_CALL_PARENTHESES", ApplicationBundle.message("checkbox.spaces.method.call.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_IF_PARENTHESES", ApplicationBundle.message("checkbox.spaces.if.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FOR_PARENTHESES", ApplicationBundle.message("checkbox.spaces.for.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_PARENTHESES", ApplicationBundle.message("checkbox.spaces.while.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SWITCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.switch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_TRY_PARENTHESES", ApplicationBundle.message("checkbox.spaces.try.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.catch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SYNCHRONIZED_PARENTHESES", ApplicationBundle.message("checkbox.spaces.synchronized.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ANOTATION_PARAMETER_LIST", ApplicationBundle.message("checkbox.spaces.annotation.parameters", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_AROUND_OPERATORS), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_AROUND_ASSIGNMENT_OPERATORS", ApplicationBundle.message("checkbox.spaces.assignment.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_LOGICAL_OPERATORS", ApplicationBundle.message("checkbox.spaces.logical.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_EQUALITY_OPERATORS", ApplicationBundle.message("checkbox.spaces.equality.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_RELATIONAL_OPERATORS", ApplicationBundle.message("checkbox.spaces.relational.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_BITWISE_OPERATORS", ApplicationBundle.message("checkbox.spaces.bitwise.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_ADDITIVE_OPERATORS", ApplicationBundle.message("checkbox.spaces.additive.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_MULTIPLICATIVE_OPERATORS", ApplicationBundle.message("checkbox.spaces.multiplicative.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_SHIFT_OPERATORS", ApplicationBundle.message("checkbox.spaces.shift.operators", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_UNARY_OPERATOR", ApplicationBundle.message("checkbox.spaces.around.unary.operator", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_LAMBDA_ARROW", ApplicationBundle.message("checkbox.spaces.around.lambda.arrow", new Object[0])), new CodeStyleSettingPresentation("SPACE_AROUND_METHOD_REF_DBL_COLON", ApplicationBundle.message("checkbox.spaces.around.method.ref.dbl.colon.arrow", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_BEFORE_LEFT_BRACE), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_CLASS_LBRACE", ApplicationBundle.message("checkbox.spaces.class.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_METHOD_LBRACE", ApplicationBundle.message("checkbox.spaces.method.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_IF_LBRACE", ApplicationBundle.message("checkbox.spaces.if.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ELSE_LBRACE", ApplicationBundle.message("checkbox.spaces.else.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FOR_LBRACE", ApplicationBundle.message("checkbox.spaces.for.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_LBRACE", ApplicationBundle.message("checkbox.spaces.while.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_DO_LBRACE", ApplicationBundle.message("checkbox.spaces.do.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SWITCH_LBRACE", ApplicationBundle.message("checkbox.spaces.switch.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_TRY_LBRACE", ApplicationBundle.message("checkbox.spaces.try.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_LBRACE", ApplicationBundle.message("checkbox.spaces.catch.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FINALLY_LBRACE", ApplicationBundle.message("checkbox.spaces.finally.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SYNCHRONIZED_LBRACE", ApplicationBundle.message("checkbox.spaces.synchronized.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ARRAY_INITIALIZER_LBRACE", ApplicationBundle.message("checkbox.spaces.array.initializer.left.brace", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_ANNOTATION_ARRAY_INITIALIZER_LBRACE", ApplicationBundle.message("checkbox.spaces.annotation.array.initializer.left.brace", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_BEFORE_KEYWORD), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_ELSE_KEYWORD", ApplicationBundle.message("checkbox.spaces.else.keyword", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_WHILE_KEYWORD", ApplicationBundle.message("checkbox.spaces.while.keyword", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_CATCH_KEYWORD", ApplicationBundle.message("checkbox.spaces.catch.keyword", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_FINALLY_KEYWORD", ApplicationBundle.message("checkbox.spaces.finally.keyword", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_WITHIN), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_WITHIN_BRACES", ApplicationBundle.message("checkbox.spaces.within.braces", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_BRACKETS", ApplicationBundle.message("checkbox.spaces.within.brackets", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", ApplicationBundle.message("checkbox.spaces.within.array.initializer.braces", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES", ApplicationBundle.message("checkbox.spaces.within.empty.array.initializer.braces", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_PARENTHESES", ApplicationBundle.message("checkbox.spaces.within.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_METHOD_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.method.declaration.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_METHOD_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.empty.method.declaration.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_METHOD_CALL_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.method.call.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES", ApplicationBundle.message("checkbox.spaces.checkbox.spaces.empty.method.call.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_IF_PARENTHESES", ApplicationBundle.message("checkbox.spaces.if.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_FOR_PARENTHESES", ApplicationBundle.message("checkbox.spaces.for.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_WHILE_PARENTHESES", ApplicationBundle.message("checkbox.spaces.while.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_SWITCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.switch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_TRY_PARENTHESES", ApplicationBundle.message("checkbox.spaces.try.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_CATCH_PARENTHESES", ApplicationBundle.message("checkbox.spaces.catch.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_SYNCHRONIZED_PARENTHESES", ApplicationBundle.message("checkbox.spaces.synchronized.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_CAST_PARENTHESES", ApplicationBundle.message("checkbox.spaces.type.cast.parentheses", new Object[0])), new CodeStyleSettingPresentation("SPACE_WITHIN_ANNOTATION_PARENTHESES", ApplicationBundle.message("checkbox.spaces.annotation.parentheses", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_IN_TERNARY_OPERATOR), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_QUEST", ApplicationBundle.message("checkbox.spaces.before.question", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_QUEST", ApplicationBundle.message("checkbox.spaces.after.question", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_COLON", ApplicationBundle.message("checkbox.spaces.before.colon", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_COLON", ApplicationBundle.message("checkbox.spaces.after.colon", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_WITHIN_TYPE_ARGUMENTS), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS", ApplicationBundle.message("checkbox.spaces.after.comma", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_IN_TYPE_ARGUMENTS), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_TYPE_PARAMETER_LIST", ApplicationBundle.message("checkbox.spaces.before.opening.angle.bracket", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_IN_TYPE_PARAMETERS), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[0]));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.SPACES_OTHER), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("SPACE_BEFORE_COMMA", ApplicationBundle.message("checkbox.spaces.before.comma", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_COMMA", ApplicationBundle.message("checkbox.spaces.after.comma", new Object[0])), new CodeStyleSettingPresentation("SPACE_BEFORE_SEMICOLON", ApplicationBundle.message("checkbox.spaces.before.semicolon", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_SEMICOLON", ApplicationBundle.message("checkbox.spaces.after.semicolon", new Object[0])), new CodeStyleSettingPresentation("SPACE_AFTER_TYPE_CAST", ApplicationBundle.message("checkbox.spaces.after.type.cast", new Object[0]))}));
        this.mySpacingStandardSettings = Collections.unmodifiableMap(result);
        result = new LinkedHashMap();
        result.put(new CodeStyleSettingPresentation.SettingsGroup(null), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleBoundedIntegerSettingPresentation("RIGHT_MARGIN", ApplicationBundle.message("editbox.right.margin.columns", new Object[0]), 0, 999, -1, ApplicationBundle.message("settings.code.style.default.general", new Object[0])), new CodeStyleSelectSettingPresentation("WRAP_ON_TYPING", ApplicationBundle.message("wrapping.wrap.on.typing", new Object[0]), CodeStyleSettingsCustomizable.WRAP_ON_TYPING_VALUES, customizableOptions.WRAP_ON_TYPING_OPTIONS), new CodeStyleSoftMarginsPresentation()}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_KEEP), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("KEEP_LINE_BREAKS", ApplicationBundle.message("wrapping.keep.line.breaks", new Object[0])), new CodeStyleSettingPresentation("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message("wrapping.keep.comment.at.first.column", new Object[0])), new CodeStyleSettingPresentation("KEEP_CONTROL_STATEMENT_IN_ONE_LINE", ApplicationBundle.message("checkbox.keep.when.reformatting.control.statement.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_MULTIPLE_EXPRESSIONS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.multiple.expressions.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.blocks.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_METHODS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.methods.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.lambdas.in.one.line", new Object[0])), new CodeStyleSettingPresentation("KEEP_SIMPLE_CLASSES_IN_ONE_LINE", ApplicationBundle.message("wrapping.keep.simple.classes.in.one.line", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(null), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("WRAP_LONG_LINES", ApplicationBundle.message("wrapping.long.lines", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_COMMENTS), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("WRAP_COMMENTS", ApplicationBundle.message("wrapping.comments.wrap.at.right.margin", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_BRACES), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("CLASS_BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.class.declaration", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("METHOD_BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.method.declaration", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("LAMBDA_BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.lambda", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS), new CodeStyleSelectSettingPresentation("BRACE_STYLE", ApplicationBundle.message("wrapping.brace.placement.other", new Object[0]), CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES, customizableOptions.BRACE_PLACEMENT_OPTIONS)}));
        CodeStyleSettingsPresentations.putGroupTop(result, "EXTENDS_LIST_WRAP", customizableOptions.WRAPPING_EXTENDS_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_EXTENDS_LIST), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_EXTENDS_LIST", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "EXTENDS_KEYWORD_WRAP", customizableOptions.WRAPPING_EXTENDS_KEYWORD, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON, customizableOptions.WRAP_OPTIONS_FOR_SINGLETON);
        CodeStyleSettingsPresentations.putGroupTop(result, "THROWS_LIST_WRAP", customizableOptions.WRAPPING_THROWS_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_THROWS_LIST), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_THROWS_LIST", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("ALIGN_THROWS_KEYWORD", ApplicationBundle.message("wrapping.align.throws.keyword", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "THROWS_KEYWORD_WRAP", customizableOptions.WRAPPING_THROWS_KEYWORD, CodeStyleSettingsCustomizable.WRAP_VALUES_FOR_SINGLETON, customizableOptions.WRAP_OPTIONS_FOR_SINGLETON);
        CodeStyleSettingsPresentations.putGroupTop(result, "METHOD_PARAMETERS_WRAP", customizableOptions.WRAPPING_METHOD_PARAMETERS, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_METHOD_PARAMETERS), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARAMETERS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "CALL_PARAMETERS_WRAP", customizableOptions.WRAPPING_METHOD_ARGUMENTS_WRAPPING, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_METHOD_ARGUMENTS_WRAPPING), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARAMETERS_IN_CALLS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("PREFER_PARAMETERS_WRAP", ApplicationBundle.message("wrapping.take.priority.over.call.chain.wrapping", new Object[0])), new CodeStyleSettingPresentation("CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_METHOD_PARENTHESES), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_METHOD_BRACKETS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "METHOD_CALL_CHAIN_WRAP", customizableOptions.WRAPPING_CALL_CHAIN, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_CALL_CHAIN), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("WRAP_FIRST_METHOD_IN_CALL_CHAIN", ApplicationBundle.message("wrapping.chained.method.call.first.on.new.line", new Object[0])), new CodeStyleSettingPresentation("ALIGN_MULTILINE_CHAINED_METHODS", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleCommaSeparatedIdentifiersPresentation("BUILDER_METHODS", ApplicationBundle.message("wrapping.builder.methods", new Object[0])), new CodeStyleSettingPresentation("KEEP_BUILDER_METHODS_INDENTS", ApplicationBundle.message("wrapping.builder.methods.keep.indents", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_IF_STATEMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("IF_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS), new CodeStyleSettingPresentation("ELSE_ON_NEW_LINE", ApplicationBundle.message("wrapping.else.on.new.line", new Object[0])), new CodeStyleSettingPresentation("SPECIAL_ELSE_IF_TREATMENT", ApplicationBundle.message("wrapping.special.else.if.braces.treatment", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "FOR_STATEMENT_WRAP", customizableOptions.WRAPPING_FOR_STATEMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_FOR_STATEMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_FOR", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("FOR_STATEMENT_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("FOR_STATEMENT_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0])), new CodeStyleSelectSettingPresentation("FOR_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS)}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_WHILE_STATEMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("WHILE_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS)}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_DOWHILE_STATEMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation("DOWHILE_BRACE_FORCE", ApplicationBundle.message("wrapping.force.braces", new Object[0]), CodeStyleSettingsCustomizable.BRACE_VALUES, customizableOptions.BRACE_OPTIONS), new CodeStyleSettingPresentation("WHILE_ON_NEW_LINE", ApplicationBundle.message("wrapping.while.on.new.line", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_SWITCH_STATEMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("INDENT_CASE_FROM_SWITCH", ApplicationBundle.message("wrapping.indent.case.from.switch", new Object[0])), new CodeStyleSettingPresentation("INDENT_BREAK_FROM_CASE", ApplicationBundle.message("wrapping.indent.break.from.case", new Object[0])), new CodeStyleSettingPresentation("CASE_STATEMENT_ON_NEW_LINE", ApplicationBundle.message("wrapping.case.statements.on.one.line", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "RESOURCE_LIST_WRAP", customizableOptions.WRAPPING_TRY_RESOURCE_LIST, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_TRY_RESOURCE_LIST), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_RESOURCES", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("RESOURCE_LIST_LPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("RESOURCE_LIST_RPAREN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_TRY_STATEMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("CATCH_ON_NEW_LINE", ApplicationBundle.message("wrapping.catch.on.new.line", new Object[0])), new CodeStyleSettingPresentation("FINALLY_ON_NEW_LINE", ApplicationBundle.message("wrapping.finally.on.new.line", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "BINARY_OPERATION_WRAP", customizableOptions.WRAPPING_BINARY_OPERATION, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_BINARY_OPERATION), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_BINARY_OPERATION", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("BINARY_OPERATION_SIGN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.operation.sign.on.next.line", new Object[0])), new CodeStyleSettingPresentation("ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION", ApplicationBundle.message("wrapping.align.parenthesised.when.multiline", new Object[0])), new CodeStyleSettingPresentation("PARENTHESES_EXPRESSION_LPAREN_WRAP", ApplicationBundle.message("wrapping.new.line.after.lpar", new Object[0])), new CodeStyleSettingPresentation("PARENTHESES_EXPRESSION_RPAREN_WRAP", ApplicationBundle.message("wrapping.rpar.on.new.line", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "ASSIGNMENT_WRAP", customizableOptions.WRAPPING_ASSIGNMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_ASSIGNMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_ASSIGNMENT", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", ApplicationBundle.message("wrapping.assignment.sign.on.next.line", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_FIELDS_VARIABLES_GROUPS), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_GROUP_FIELD_DECLARATIONS", ApplicationBundle.message("wrapping.align.fields.in.columns", new Object[0])), new CodeStyleSettingPresentation("ALIGN_CONSECUTIVE_VARIABLE_DECLARATIONS", ApplicationBundle.message("wrapping.align.variables.in.columns", new Object[0])), new CodeStyleSettingPresentation("ALIGN_CONSECUTIVE_ASSIGNMENTS", ApplicationBundle.message("wrapping.align.assignments.in.columns", new Object[0])), new CodeStyleSettingPresentation("ALIGN_SUBSEQUENT_SIMPLE_METHODS", ApplicationBundle.message("wrapping.align.simple.methods.in.columns", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "TERNARY_OPERATION_WRAP", customizableOptions.WRAPPING_TERNARY_OPERATION, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_TERNARY_OPERATION), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_TERNARY_OPERATION", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", ApplicationBundle.message("wrapping.quest.and.colon.signs.on.next.line", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "ARRAY_INITIALIZER_WRAP", customizableOptions.WRAPPING_ARRAY_INITIALIZER, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_ARRAY_INITIALIZER), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", ApplicationBundle.message("wrapping.align.when.multiline", new Object[0])), new CodeStyleSettingPresentation("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", ApplicationBundle.message("wrapping.new.line.after.lbrace", new Object[0])), new CodeStyleSettingPresentation("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", ApplicationBundle.message("wrapping.rbrace.on.new.line", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_MODIFIER_LIST), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("MODIFIER_LIST_WRAP", ApplicationBundle.message("wrapping.after.modifier.list", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "ASSERT_STATEMENT_WRAP", customizableOptions.WRAPPING_ASSERT_STATEMENT, CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        result.put(new CodeStyleSettingPresentation.SettingsGroup(customizableOptions.WRAPPING_ASSERT_STATEMENT), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("ASSERT_STATEMENT_COLON_ON_NEXT_LINE", ApplicationBundle.message("wrapping.colon.signs.on.next.line", new Object[0]))}));
        CodeStyleSettingsPresentations.putGroupTop(result, "ENUM_CONSTANTS_WRAP", ApplicationBundle.message("wrapping.enum.constants", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result, "CLASS_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.classes.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result, "METHOD_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.methods.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result, "FIELD_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.fields.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result, "PARAMETER_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.parameters.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        CodeStyleSettingsPresentations.putGroupTop(result, "VARIABLE_ANNOTATION_WRAP", ApplicationBundle.message("wrapping.local.variables.annotation", new Object[0]), CodeStyleSettingsCustomizable.WRAP_VALUES, customizableOptions.WRAP_OPTIONS);
        this.myWrappingAndBracesStandardSettings = Collections.unmodifiableMap(result);
        result = new LinkedHashMap();
        result.put(new CodeStyleSettingPresentation.SettingsGroup(null), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("INDENT_SIZE", ApplicationBundle.message("editbox.indent.indent", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(null), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("CONTINUATION_INDENT_SIZE", ApplicationBundle.message("editbox.indent.continuation.indent", new Object[0]))}));
        result.put(new CodeStyleSettingPresentation.SettingsGroup(null), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSettingPresentation("TAB_SIZE", ApplicationBundle.message("editbox.indent.tab.size", new Object[0]))}));
        this.myIndentStandardSettings = Collections.unmodifiableMap(result);
    }

    private static void putGroupTop(@NotNull Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> result, @NotNull String fieldName, @NlsContexts.Label @NotNull String uiName, int[] values, String[] valueUiNames) {
        if (result == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(0);
        }
        if (fieldName == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(1);
        }
        if (uiName == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(2);
        }
        result.put(new CodeStyleSettingPresentation.SettingsGroup(null), (List<CodeStyleSettingPresentation>)ContainerUtil.immutableList((Object[])new CodeStyleSettingPresentation[]{new CodeStyleSelectSettingPresentation(fieldName, uiName, values, valueUiNames)}));
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getBlankLinesStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map = this.myBlankLinesStandardSettings;
        if (map == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getSpacingStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map = this.mySpacingStandardSettings;
        if (map == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getWrappingAndBracesStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map = this.myWrappingAndBracesStandardSettings;
        if (map == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> getIndentStandardSettings() {
        Map<CodeStyleSettingPresentation.SettingsGroup, List<CodeStyleSettingPresentation>> map = this.myIndentStandardSettings;
        if (map == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(6);
        }
        return map;
    }

    @NotNull
    static CodeStyleSettingsPresentations getInstance() {
        CodeStyleSettingsPresentations codeStyleSettingsPresentations = LocaleSensitiveApplicationCacheService.getInstance().getData(CodeStyleSettingsPresentations.class, CodeStyleSettingsPresentations::new);
        if (codeStyleSettingsPresentations == null) {
            CodeStyleSettingsPresentations.$$$reportNull$$$0(7);
        }
        return codeStyleSettingsPresentations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/presentation/CodeStyleSettingsPresentations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/presentation/CodeStyleSettingsPresentations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlankLinesStandardSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpacingStandardSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappingAndBracesStandardSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentStandardSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "putGroupTop";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

