/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SingleTargetRequestResultProcessor
extends RequestResultProcessor {
    private static final PsiReferenceService ourReferenceService = PsiReferenceService.getService();
    private final PsiElement myTarget;

    public SingleTargetRequestResultProcessor(@NotNull PsiElement target) {
        if (target == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(0);
        }
        super(target);
        this.myTarget = target;
    }

    @Override
    public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer2) {
        if (element == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(2);
        }
        if (!this.myTarget.isValid()) {
            return false;
        }
        List<PsiReference> references = ourReferenceService.getReferences(element, new PsiReferenceService.Hints(this.myTarget, offsetInElement));
        for (int i2 = 0; i2 < references.size(); ++i2) {
            PsiReference ref = references.get(i2);
            ProgressManager.checkCanceled();
            if (!ReferenceRange.containsOffsetInElement(ref, offsetInElement) || !ref.isReferenceTo(this.myTarget) || consumer2.process((Object)ref)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SingleTarget: " + this.myTarget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/SingleTargetRequestResultProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processTextOccurrence";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

