/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatisticsInfo {
    public static final StatisticsInfo EMPTY = new StatisticsInfo("empty", "empty");
    private final String myContext;
    private final String myValue;
    private final List<StatisticsInfo> myConjuncts;

    public StatisticsInfo(@NonNls @NotNull String context, @NonNls @NotNull String value2) {
        if (context == null) {
            StatisticsInfo.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            StatisticsInfo.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myValue = value2;
        this.myConjuncts = Collections.singletonList(this);
    }

    private StatisticsInfo(String context, String value2, List<StatisticsInfo> conjuncts) {
        this.myContext = context;
        this.myValue = value2;
        this.myConjuncts = conjuncts;
    }

    public static StatisticsInfo createComposite(List<? extends StatisticsInfo> conjuncts) {
        if (conjuncts.isEmpty()) {
            return EMPTY;
        }
        ArrayList<StatisticsInfo> flattened = new ArrayList<StatisticsInfo>(conjuncts.size());
        for (StatisticsInfo statisticsInfo : conjuncts) {
            flattened.addAll(statisticsInfo.getConjuncts());
        }
        return new StatisticsInfo(conjuncts.get(0).getContext(), conjuncts.get(0).getValue(), flattened);
    }

    @NotNull
    public String getContext() {
        String string = this.myContext;
        if (string == null) {
            StatisticsInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            StatisticsInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    public List<StatisticsInfo> getConjuncts() {
        return this.myConjuncts;
    }

    public String toString() {
        return this.myContext + "::::" + this.myValue + (String)(this.myConjuncts.size() == 1 ? "" : "::::" + this.myConjuncts);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/statistics/StatisticsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/statistics/StatisticsInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

