/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;

public class RefactoringEventData
extends UserDataHolderBase {
    public static final Key<Collection<? extends String>> CONFLICTS_KEY = Key.create((String)"conflicts");
    public static final Key<PsiElement> PSI_ELEMENT_KEY = Key.create((String)"element");
    public static final Key<String[]> STRING_PROPERTIES = Key.create((String)"stringProperties");
    public static final Key<PsiElement[]> PSI_ELEMENT_ARRAY_KEY = Key.create((String)"elementArray");
    public static final Key<Collection<? extends UsageInfo>> USAGE_INFOS_KEY = Key.create((String)"usageInfos");

    public void addElement(PsiElement element) {
        this.putUserData(PSI_ELEMENT_KEY, element);
    }

    public <T> void addMembers(T[] members, Function<? super T, ? extends PsiElement> converter) {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (T info : members) {
            elements.add((PsiElement)converter.fun(info));
        }
        this.addElements(elements);
    }

    public void addElements(Collection<? extends PsiElement> elements) {
        this.putUserData(PSI_ELEMENT_ARRAY_KEY, elements.toArray(PsiElement.EMPTY_ARRAY));
    }

    public void addElements(PsiElement[] elements) {
        this.putUserData(PSI_ELEMENT_ARRAY_KEY, elements);
    }

    public void addUsages(Collection<? extends UsageInfo> usageInfos) {
        this.putUserData(USAGE_INFOS_KEY, usageInfos);
    }

    public void addStringProperties(String ... properties) {
        this.putUserData(STRING_PROPERTIES, properties);
    }
}

