/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.AbstractFieldPanel;
import com.intellij.ui.DocumentAdapter;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ComboBoxFieldPanel
extends AbstractFieldPanel {
    private final JComboBox myComboBox = (JComboBox)this.getComponent();
    private String oldText;

    public ComboBoxFieldPanel() {
        super(new ComboBox());
    }

    public ComboBoxFieldPanel(String[] items, @NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle, ActionListener browseButtonActionListener) {
        this(items, labelText, viewerDialogTitle, browseButtonActionListener, null);
    }

    public ComboBoxFieldPanel(String[] items, @NlsContexts.Label String labelText, @NlsContexts.DialogTitle String viewerDialogTitle, ActionListener browseButtonActionListener, Runnable documentListener) {
        super(new ComboBox<String>(items), labelText, viewerDialogTitle, browseButtonActionListener, documentListener);
        this.createComponent();
    }

    @Override
    public void createComponent() {
        super.createComponent();
        ComponentWithBrowseButton.MyDoClickAction doClickAction = this.getDoClickAction();
        if (doClickAction != null) {
            doClickAction.registerShortcut(this.myComboBox);
        }
        this.myComboBox.setMaximumRowCount(8);
        this.myComboBox.setEditable(true);
        JTextField editorComponent = (JTextField)this.myComboBox.getEditor().getEditorComponent();
        editorComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String text2;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!Comparing.equal((String)(text2 = ComboBoxFieldPanel.this.getText()), (String)ComboBoxFieldPanel.this.oldText, (boolean)true)) {
                    ComboBoxFieldPanel.this.oldText = text2;
                    Runnable changeListener = ComboBoxFieldPanel.this.getChangeListener();
                    if (changeListener != null) {
                        changeListener.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/ComboBoxFieldPanel$1", "textChanged"));
            }
        });
    }

    @Override
    public String getText() {
        Object selectedItem = this.myComboBox.isEditable() ? this.myComboBox.getEditor().getItem() : this.myComboBox.getSelectedItem();
        return selectedItem instanceof String ? (String)selectedItem : null;
    }

    @Override
    public void setText(String text2) {
        this.myComboBox.setSelectedItem(text2);
    }

    public JComboBox getComboBox() {
        return this.myComboBox;
    }

    public void setItems(Object[] items) {
        this.myComboBox.removeAllItems();
        for (Object item : items) {
            this.myComboBox.addItem(item);
        }
    }

    public void addItemSetText(@NlsContexts.ListItem String text2) {
        JComboBox comboBox = this.getComboBox();
        int n = comboBox.getItemCount();
        boolean found = false;
        for (int i2 = 0; i2 < n; ++i2) {
            String item = (String)comboBox.getItemAt(i2);
            if (!Comparing.strEqual((String)item, (String)text2)) continue;
            found = true;
            break;
        }
        if (!found) {
            comboBox.addItem(text2);
        }
        comboBox.getEditor().setItem(text2);
        this.setText(text2);
    }
}

