/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MouseDragHelper<T extends JComponent>
extends MouseAdapter
implements MouseMotionListener,
KeyEventDispatcher,
Weighted {
    public static final int DRAG_START_DEADZONE = 7;
    @NonNls
    private static final String DRAGGABLE_MARKER = "DRAGGABLE_MARKER";
    private static int ourLastDragHash = 0;
    @NotNull
    protected final T myDragComponent;
    private Point myPressPointScreen;
    protected Point myPressedOnScreenPoint;
    private boolean myDraggingNow;
    private boolean myDragJustStarted;
    private IdeGlassPane myGlassPane;
    @NotNull
    private final Disposable myParentDisposable;
    private boolean myDetachPostponed;
    private boolean myDetachingMode;
    private boolean myCancelled;
    private Disposable myGlassPaneListenersDisposable;
    private boolean myStopped;

    public MouseDragHelper(@NotNull Disposable parent, @NotNull T dragComponent) {
        if (parent == null) {
            MouseDragHelper.$$$reportNull$$$0(0);
        }
        if (dragComponent == null) {
            MouseDragHelper.$$$reportNull$$$0(1);
        }
        this.myGlassPaneListenersDisposable = Disposer.newDisposable();
        this.myDragComponent = dragComponent;
        this.myParentDisposable = parent;
    }

    public static void setComponentDraggable(@NotNull JComponent c, boolean draggable) {
        if (c == null) {
            MouseDragHelper.$$$reportNull$$$0(2);
        }
        c.putClientProperty(DRAGGABLE_MARKER, draggable ? Boolean.TRUE : null);
    }

    public static boolean isComponentDraggable(@NotNull Component c) {
        if (c == null) {
            MouseDragHelper.$$$reportNull$$$0(3);
        }
        return c instanceof JComponent && ((JComponent)c).getClientProperty(DRAGGABLE_MARKER) == Boolean.TRUE;
    }

    public static boolean checkModifiers(@Nullable InputEvent event) {
        if (event == null || !UISettings.getInstance().getDndWithPressedAltOnly()) {
            return true;
        }
        return (event.getModifiers() & 8) != 0;
    }

    public void start() {
        if (this.myGlassPane != null) {
            return;
        }
        new UiNotifyConnector((Component)this.myDragComponent, new Activatable(){

            @Override
            public void showNotify() {
                MouseDragHelper.this.attach();
            }

            @Override
            public void hideNotify() {
                MouseDragHelper.this.detach(true);
            }
        });
        Disposer.register((Disposable)this.myParentDisposable, () -> this.stop());
    }

    private void attach() {
        if (this.myDetachPostponed) {
            this.myDetachPostponed = false;
            return;
        }
        if (this.myStopped || this.myGlassPane != null) {
            return;
        }
        this.myGlassPane = IdeGlassPaneUtil.find(this.myDragComponent);
        this.myGlassPaneListenersDisposable = Disposer.newDisposable((String)"myGlassPaneListeners");
        Disposer.register((Disposable)this.myParentDisposable, (Disposable)this.myGlassPaneListenersDisposable);
        this.myGlassPane.addMousePreprocessor(this, this.myGlassPaneListenersDisposable);
        this.myGlassPane.addMouseMotionPreprocessor(this, this.myGlassPaneListenersDisposable);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public void stop() {
        this.myStopped = true;
        this.detach(false);
    }

    private void detach(boolean canPostponeDetach) {
        if (canPostponeDetach && this.myDraggingNow) {
            this.myDetachPostponed = true;
            return;
        }
        if (this.myGlassPane != null) {
            Disposer.dispose((Disposable)this.myGlassPaneListenersDisposable);
            this.myGlassPaneListenersDisposable = Disposer.newDisposable();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            this.myGlassPane = null;
        }
    }

    @Override
    public double getWeight() {
        return 2.0;
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (!this.canStartDragging(e) || ourLastDragHash == System.identityHashCode(e)) {
            return;
        }
        this.myPressPointScreen = new RelativePoint(e).getScreenPoint();
        this.myPressedOnScreenPoint = new Point(this.myPressPointScreen);
        this.processMousePressed(e);
        ourLastDragHash = System.identityHashCode(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.myCancelled) {
            this.myCancelled = false;
            return;
        }
        if (this.myDraggingNow && !this.canFinishDragging(e)) {
            this.cancelDragging();
            e.consume();
            this.myPressedOnScreenPoint = null;
            this.myCancelled = false;
            return;
        }
        boolean wasDragging = this.myDraggingNow;
        this.myPressPointScreen = null;
        this.myDraggingNow = false;
        this.myDragJustStarted = false;
        if (wasDragging) {
            try {
                if (this.myDetachingMode) {
                    this.processDragOutFinish(e);
                } else {
                    this.processDragFinish(e, false);
                }
            }
            finally {
                this.myPressedOnScreenPoint = null;
                this.resetDragState();
                e.consume();
                if (this.myDetachPostponed) {
                    this.myDetachPostponed = false;
                    this.detach(false);
                }
            }
        }
    }

    private void resetDragState() {
        this.myDraggingNow = false;
        this.myDragJustStarted = false;
        this.myPressPointScreen = null;
        this.myDetachingMode = false;
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        if (e == null) {
            MouseDragHelper.$$$reportNull$$$0(4);
        }
        if (this.myPressPointScreen == null || this.myCancelled) {
            return;
        }
        boolean deadZone = this.isWithinDeadZone(e);
        if (!this.myDraggingNow && !deadZone) {
            this.myDraggingNow = true;
            this.myDragJustStarted = true;
        } else if (this.myDraggingNow) {
            this.myDragJustStarted = false;
        }
        if (this.myDraggingNow && this.myPressPointScreen != null) {
            Point draggedTo = new RelativePoint(e).getScreenPoint();
            boolean dragOutStarted = false;
            if (!this.myDetachingMode && this.isDragOut(e, draggedTo, (Point)this.myPressPointScreen.clone())) {
                this.myDetachingMode = true;
                this.processDragFinish(e, true);
                dragOutStarted = true;
            }
            if (this.myDetachingMode) {
                this.processDragOut(e, draggedTo, (Point)this.myPressPointScreen.clone(), dragOutStarted);
            } else {
                this.processDrag(e, draggedTo, (Point)this.myPressPointScreen.clone());
            }
        }
    }

    private boolean canStartDragging(@NotNull MouseEvent me) {
        if (me == null) {
            MouseDragHelper.$$$reportNull$$$0(5);
        }
        if (me.getButton() != 1) {
            return false;
        }
        if (!((Component)this.myDragComponent).isShowing()) {
            return false;
        }
        Component component = me.getComponent();
        if (NullableComponent.Check.isNullOrHidden((Component)component)) {
            return false;
        }
        Point dragComponentPoint = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), this.myDragComponent);
        return this.canStartDragging((JComponent)this.myDragComponent, dragComponentPoint);
    }

    protected boolean canStartDragging(@NotNull JComponent dragComponent, @NotNull Point dragComponentPoint) {
        if (dragComponent == null) {
            MouseDragHelper.$$$reportNull$$$0(6);
        }
        if (dragComponentPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(7);
        }
        return true;
    }

    protected boolean canFinishDragging(@NotNull MouseEvent me) {
        if (me == null) {
            MouseDragHelper.$$$reportNull$$$0(8);
        }
        if (!((Component)this.myDragComponent).isShowing()) {
            return false;
        }
        Component component = me.getComponent();
        if (NullableComponent.Check.isNullOrHidden((Component)component)) {
            return false;
        }
        return this.canFinishDragging((JComponent)this.myDragComponent, new RelativePoint(me));
    }

    protected boolean canFinishDragging(@NotNull JComponent component, @NotNull RelativePoint point) {
        if (component == null) {
            MouseDragHelper.$$$reportNull$$$0(9);
        }
        if (point == null) {
            MouseDragHelper.$$$reportNull$$$0(10);
        }
        return true;
    }

    protected void processMousePressed(@NotNull MouseEvent event) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(11);
        }
    }

    protected void processDragCancel() {
    }

    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(12);
        }
    }

    protected void processDragOutFinish(@NotNull MouseEvent event) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(13);
        }
    }

    protected void processDragOutCancel() {
    }

    protected final boolean isDragJustStarted() {
        return this.myDragJustStarted;
    }

    protected abstract void processDrag(@NotNull MouseEvent var1, @NotNull Point var2, @NotNull Point var3);

    protected boolean isDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(14);
        }
        if (dragToScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(15);
        }
        if (startScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(16);
        }
        return false;
    }

    protected void processDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint, boolean justStarted) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(17);
        }
        if (dragToScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(18);
        }
        if (startScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(19);
        }
        event.consume();
    }

    private boolean isWithinDeadZone(@NotNull MouseEvent e) {
        if (e == null) {
            MouseDragHelper.$$$reportNull$$$0(20);
        }
        return this.myPressPointScreen.distance(e.getLocationOnScreen()) < (double)this.getDragStartDeadzone(this.myPressedOnScreenPoint.getLocation(), e.getLocationOnScreen());
    }

    protected int getDragStartDeadzone(@NotNull Point pressedScreenPoint, @NotNull Point draggedScreenPoint) {
        if (pressedScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(21);
        }
        if (draggedScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(22);
        }
        return JBUI.scale((int)7);
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        if (e == null) {
            MouseDragHelper.$$$reportNull$$$0(23);
        }
    }

    @Override
    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        if (e == null) {
            MouseDragHelper.$$$reportNull$$$0(24);
        }
        if (e.getKeyCode() == 27 && e.getID() == 401) {
            return this.cancelDragging();
        }
        return false;
    }

    public boolean cancelDragging() {
        if (!this.myDraggingNow) {
            return false;
        }
        this.myCancelled = true;
        if (this.myDetachingMode) {
            this.processDragOutCancel();
        } else {
            this.processDragCancel();
        }
        this.resetDragState();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragComponentPoint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragToScreenPoint";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startScreenPoint";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pressedScreenPoint";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedScreenPoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/MouseDragHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponentDraggable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isComponentDraggable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseDragged";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canStartDragging";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canFinishDragging";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processMousePressed";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragFinish";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragOutFinish";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragOut";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "isWithinDeadZone";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getDragStartDeadzone";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "dispatchKeyEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

