/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ui.jcef.JBCefLoadHtmlResourceHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;

final class JBCefFileSchemeHandlerFactory
implements CefSchemeHandlerFactory {
    public static final String FILE_SCHEME_NAME = "file";
    public static final String LOADHTML_RANDOM_URL_PREFIX = "file:///jbcefbrowser/";
    public static final Map<CefBrowser, Map<String, String>> LOADHTML_REQUEST_MAP = ContainerUtil.createWeakMap();

    JBCefFileSchemeHandlerFactory() {
    }

    public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
        String html;
        if (!FILE_SCHEME_NAME.equals(schemeName)) {
            return null;
        }
        String url = request.getURL();
        if (url == null) {
            return null;
        }
        Map<String, String> map = LOADHTML_REQUEST_MAP.get(browser);
        if (map != null && (html = map.remove(request.getURL())) != null) {
            return new JBCefLoadHtmlResourceHandler(html);
        }
        return null;
    }

    @NotNull
    public static String registerLoadHTMLRequest(@NotNull CefBrowser browser, @NotNull String html, @NotNull String origUrl) {
        if (browser == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(0);
        }
        if (html == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(1);
        }
        if (origUrl == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(2);
        }
        String fileUrl = JBCefFileSchemeHandlerFactory.makeFileUrl(origUrl);
        JBCefFileSchemeHandlerFactory.getInitMap(browser).put(fileUrl, html);
        String string = fileUrl;
        if (string == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Map<String, String> getInitMap(@NotNull CefBrowser browser) {
        Map<String, String> map;
        if (browser == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(4);
        }
        if ((map = LOADHTML_REQUEST_MAP.get(browser)) == null) {
            Map<CefBrowser, Map<String, String>> map2 = LOADHTML_REQUEST_MAP;
            synchronized (map2) {
                map = LOADHTML_REQUEST_MAP.get(browser);
                if (map == null) {
                    map = Collections.synchronizedMap(new HashMap());
                    LOADHTML_REQUEST_MAP.put(browser, map);
                }
            }
        }
        Map<String, String> map3 = map;
        if (map3 == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(5);
        }
        return map3;
    }

    @NotNull
    public static String makeFileUrl(@NotNull String url) {
        if (url == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(6);
        }
        if (url.startsWith("file://")) {
            String string = url;
            if (string == null) {
                JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = LOADHTML_RANDOM_URL_PREFIX + new Random().nextInt(Integer.MAX_VALUE) + "#url=" + url;
        if (string == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origUrl";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefFileSchemeHandlerFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefFileSchemeHandlerFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerLoadHTMLRequest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFileUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerLoadHTMLRequest";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInitMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "makeFileUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

