/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.application.options.RegistryManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.jcef.JBCefFpsMeter;
import com.intellij.ui.jcef.JBCefOSRHandlerFactory;
import com.intellij.ui.jcef.JBCefOsrComponent;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.Function;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.RetinaImage;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cef.JCefAppConfig;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefScreenInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBCefOsrHandler
implements CefRenderHandler {
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final Function<JComponent, Rectangle> myScreenBoundsProvider;
    @NotNull
    private final AtomicReference<Point> myLocationOnScreenRef;
    @NotNull
    private final JBCefOsrComponent.MyScale myScale;
    @NotNull
    private final JBCefFpsMeter myFpsMeter;
    @Nullable
    private volatile JBHiDPIScaledImage myImage;
    @Nullable
    private volatile VolatileImage myVolatileImage;
    @NotNull
    private static final Point ZERO_POINT = new Point();
    @NotNull
    private static final Rectangle ZERO_RECT = new Rectangle();
    @NotNull
    private Rectangle myPopupBounds;
    private boolean myPopupShown;

    JBCefOsrHandler(@NotNull JBCefOsrComponent component, @Nullable Function<JComponent, Rectangle> screenBoundsProvider) {
        if (component == null) {
            JBCefOsrHandler.$$$reportNull$$$0(0);
        }
        this.myLocationOnScreenRef = new AtomicReference<Point>(new Point());
        this.myScale = new JBCefOsrComponent.MyScale();
        this.myFpsMeter = JBCefFpsMeter.register(RegistryManager.getInstance().get("ide.browser.jcef.osr.measureFPS.id").asString());
        this.myPopupBounds = ZERO_RECT;
        this.myComponent = component;
        component.setRenderHandler(this);
        this.myScreenBoundsProvider = (Function)ObjectUtils.notNull(screenBoundsProvider, JBCefOSRHandlerFactory.DEFAULT.createScreenBoundsProvider());
        this.myComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JBCefOsrHandler.this.updateLocation();
            }
        });
        this.myComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JBCefOsrHandler.this.updateLocation();
            }
        });
        this.myFpsMeter.registerComponent(this.myComponent);
    }

    public Rectangle getViewRect(CefBrowser browser) {
        double scale = this.myScale.getIdeBiased();
        return new Rectangle(0, 0, PaintUtil.RoundingMode.CEIL.round((double)this.myComponent.getWidth() / scale), PaintUtil.RoundingMode.CEIL.round((double)this.myComponent.getHeight() / scale));
    }

    public boolean getScreenInfo(CefBrowser browser, CefScreenInfo screenInfo) {
        Rectangle rect = (Rectangle)this.myScreenBoundsProvider.fun((Object)this.myComponent);
        screenInfo.Set(this.getDeviceScaleFactor(browser), 32, 4, false, rect, rect);
        return true;
    }

    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        Point pt = viewPoint.getLocation();
        Point loc = this.getLocation();
        if (SystemInfoRt.isMac) {
            Rectangle rect = (Rectangle)this.myScreenBoundsProvider.fun((Object)this.myComponent);
            pt.setLocation(loc.x + pt.x, rect.height - loc.y - pt.y);
        } else {
            pt.translate(loc.x, loc.y);
        }
        return SystemInfoRt.isWindows ? this.scaleUp(pt) : pt;
    }

    public double getDeviceScaleFactor(CefBrowser browser) {
        return JCefAppConfig.getDeviceScaleFactor((Component)this.myComponent);
    }

    public void onPopupShow(CefBrowser browser, boolean show) {
        this.myPopupShown = show;
    }

    public void onPopupSize(CefBrowser browser, Rectangle size) {
        this.myPopupBounds = this.scaleUp(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        Object outerRect;
        JBHiDPIScaledImage image = this.myImage;
        VolatileImage volatileImage = this.myVolatileImage;
        if (!popup) {
            Dimension size = this.getDevImageSize();
            if (size.width != width || size.height != height) {
                image = (JBHiDPIScaledImage)RetinaImage.createFrom((Image)new BufferedImage(width, height, 3), (double)this.myScale.getJreBiased(), null);
                volatileImage = this.myComponent.createVolatileImage(width, height);
                dirtyRects = new Rectangle[]{new Rectangle(0, 0, width, height)};
            }
        }
        assert (image != null);
        BufferedImage bufferedImage = (BufferedImage)image.getDelegate();
        assert (bufferedImage != null);
        int imageWidth = bufferedImage.getWidth();
        int imageHeight = bufferedImage.getHeight();
        if (volatileImage != null && volatileImage.contentsLost()) {
            int result = volatileImage.validate(this.myComponent.getGraphicsConfiguration());
            if (result != 0) {
                dirtyRects = new Rectangle[]{new Rectangle(0, 0, width, height)};
            }
            if (result == 2) {
                volatileImage = this.myComponent.createVolatileImage(imageWidth, imageHeight);
            }
        }
        int[] dst = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        IntBuffer src = buffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        if (!popup && !this.myPopupShown && this.myPopupBounds != ZERO_RECT) {
            ArrayList<Rectangle> rects = new ArrayList<Rectangle>(Arrays.asList(dirtyRects));
            rects.add(this.myPopupBounds);
            outerRect = JBCefOsrHandler.findOuterRect(rects.toArray(new Rectangle[0]));
            outerRect = ((Rectangle)outerRect).intersection(new Rectangle(0, 0, width, height));
            dirtyRects = new Rectangle[]{outerRect};
            this.myPopupBounds = ZERO_RECT;
        }
        Point popupLoc = popup ? this.myPopupBounds.getLocation() : ZERO_POINT;
        for (Rectangle rect : dirtyRects) {
            if (rect.width < imageWidth) {
                for (int line = rect.y; line < rect.y + rect.height; ++line) {
                    int srcOffset = line * width + rect.x;
                    int dstOffset = (line + popupLoc.y) * imageWidth + (rect.x + popupLoc.x);
                    src.position(srcOffset).get(dst, dstOffset, Math.min(rect.width, src.capacity() - srcOffset));
                }
                continue;
            }
            int srcOffset = rect.y * width;
            int dstOffset = (rect.y + popupLoc.y) * imageWidth;
            src.position(srcOffset).get(dst, dstOffset, Math.min(rect.height * width, src.capacity() - srcOffset));
        }
        outerRect = JBCefOsrHandler.findOuterRect(dirtyRects);
        if (popup) {
            ((Rectangle)outerRect).translate(popupLoc.x, popupLoc.y);
        }
        if (volatileImage != null) {
            Graphics2D viGr = (Graphics2D)volatileImage.getGraphics().create();
            try {
                double sx = viGr.getTransform().getScaleX();
                double sy = viGr.getTransform().getScaleY();
                viGr.scale(1.0 / sx, 1.0 / sy);
                viGr.drawImage(bufferedImage, ((Rectangle)outerRect).x, ((Rectangle)outerRect).y, ((Rectangle)outerRect).x + ((Rectangle)outerRect).width, ((Rectangle)outerRect).y + ((Rectangle)outerRect).height, ((Rectangle)outerRect).x, ((Rectangle)outerRect).y, ((Rectangle)outerRect).x + ((Rectangle)outerRect).width, ((Rectangle)outerRect).y + ((Rectangle)outerRect).height, null);
            }
            finally {
                viGr.dispose();
            }
        }
        this.myImage = image;
        this.myVolatileImage = volatileImage;
        this.myComponent.repaint(popup ? this.scaleDown(new Rectangle(0, 0, imageWidth, imageHeight)) : this.scaleDown((Rectangle)outerRect));
    }

    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        SwingUtilities.invokeLater(() -> this.myComponent.setCursor(new Cursor(cursorType)));
        return true;
    }

    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    public void paint(Graphics2D g) {
        this.myFpsMeter.paintFrameStarted();
        VolatileImage volatileImage = this.myVolatileImage;
        JBHiDPIScaledImage image = this.myImage;
        if (volatileImage != null) {
            g.drawImage(volatileImage, 0, 0, null);
        } else if (image != null) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
        }
        this.myFpsMeter.paintFrameFinished(g);
    }

    @NotNull
    private static Rectangle findOuterRect(Rectangle @NotNull [] rects) {
        if (rects == null) {
            JBCefOsrHandler.$$$reportNull$$$0(1);
        }
        if (rects.length == 1) {
            Rectangle rectangle = rects[0];
            if (rectangle == null) {
                JBCefOsrHandler.$$$reportNull$$$0(2);
            }
            return rectangle;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        for (Rectangle rect : rects) {
            int rY;
            int rX;
            if (rect.x < minX) {
                minX = rect.x;
            }
            if (rect.y < minY) {
                minY = rect.y;
            }
            if ((rX = rect.x + rect.width) > maxX) {
                maxX = rX;
            }
            if ((rY = rect.y + rect.height) <= maxY) continue;
            maxY = rY;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public void updateScale(JBCefOsrComponent.MyScale scale) {
        this.myScale.update(scale);
    }

    private void updateLocation() {
        this.myLocationOnScreenRef.set(this.myComponent.getLocationOnScreen());
    }

    @NotNull
    private Point getLocation() {
        Point point = this.myLocationOnScreenRef.get().getLocation();
        if (point == null) {
            JBCefOsrHandler.$$$reportNull$$$0(3);
        }
        return point;
    }

    @NotNull
    private Dimension getDevImageSize() {
        JBHiDPIScaledImage image = this.myImage;
        if (image == null) {
            return new Dimension(0, 0);
        }
        BufferedImage bi = (BufferedImage)image.getDelegate();
        assert (bi != null);
        return new Dimension(bi.getWidth(), bi.getHeight());
    }

    @NotNull
    private Rectangle scaleDown(@NotNull Rectangle rect) {
        if (rect == null) {
            JBCefOsrHandler.$$$reportNull$$$0(4);
        }
        double scale = this.myScale.getJreBiased();
        return new Rectangle(PaintUtil.RoundingMode.FLOOR.round((double)rect.x / scale), PaintUtil.RoundingMode.FLOOR.round((double)rect.y / scale), PaintUtil.RoundingMode.CEIL.round((double)rect.width / scale), PaintUtil.RoundingMode.CEIL.round((double)rect.height / scale));
    }

    @NotNull
    private Rectangle scaleUp(@NotNull Rectangle rect) {
        if (rect == null) {
            JBCefOsrHandler.$$$reportNull$$$0(5);
        }
        double scale = this.myScale.getJreBiased();
        return new Rectangle(PaintUtil.RoundingMode.FLOOR.round((double)rect.x * scale), PaintUtil.RoundingMode.FLOOR.round((double)rect.y * scale), PaintUtil.RoundingMode.CEIL.round((double)rect.width * scale), PaintUtil.RoundingMode.CEIL.round((double)rect.height * scale));
    }

    @NotNull
    private Point scaleUp(@NotNull Point pt) {
        if (pt == null) {
            JBCefOsrHandler.$$$reportNull$$$0(6);
        }
        double scale = this.myScale.getJreBiased();
        return new Point(PaintUtil.RoundingMode.ROUND.round((double)pt.x * scale), PaintUtil.RoundingMode.ROUND.round((double)pt.y * scale));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rects";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefOsrHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefOsrHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findOuterRect";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findOuterRect";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scaleDown";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scaleUp";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

