/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CertificateManager", storages={@Storage(value="certificates.xml")}, reportStatistic=false)
public final class CertificateManager
implements PersistentStateComponent<Config> {
    @NonNls
    public static final String COMPONENT_NAME = "Certificate Manager";
    @NonNls
    public static final String DEFAULT_PATH = String.join((CharSequence)File.separator, PathManager.getConfigPath(), "ssl", "cacerts");
    @NonNls
    public static final String DEFAULT_PASSWORD = "changeit";
    private static final Logger LOG = Logger.getInstance(CertificateManager.class);
    static final long DIALOG_VISIBILITY_TIMEOUT = 5000L;
    private Config myConfig = new Config();
    private final NotNullLazyValue<ConfirmingTrustManager> myTrustManager = NotNullLazyValue.atomicLazy(() -> ConfirmingTrustManager.createForStorage(CertificateManager.tryMigratingDefaultTruststore(), DEFAULT_PASSWORD));
    private final NotNullLazyValue<SSLContext> mySslContext = NotNullLazyValue.atomicLazy(this::calcSslContext);

    public static CertificateManager getInstance() {
        return (CertificateManager)ApplicationManager.getApplication().getService(CertificateManager.class);
    }

    @NotNull
    private static String tryMigratingDefaultTruststore() {
        Path legacySystemPath = Paths.get(PathManager.getSystemPath(), "tasks", "cacerts");
        Path configPath = Paths.get(DEFAULT_PATH, new String[0]);
        if (!Files.exists(configPath, new LinkOption[0]) && Files.exists(legacySystemPath, new LinkOption[0])) {
            LOG.info("Migrating the default truststore from " + legacySystemPath + " to " + configPath);
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                try {
                    Files.move(legacySystemPath, configPath, new CopyOption[0]);
                }
                catch (FileAlreadyExistsException | NoSuchFileException fileSystemException) {}
            }
            catch (IOException e) {
                LOG.error("Cannot move the default truststore from " + legacySystemPath + " to " + configPath, (Throwable)e);
                String string = legacySystemPath.toString();
                if (string == null) {
                    CertificateManager.$$$reportNull$$$0(0);
                }
                return string;
            }
        }
        String string = DEFAULT_PATH;
        if (string == null) {
            CertificateManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    public CertificateManager() {
        AppExecutorUtil.getAppExecutorService().execute(() -> {
            try {
                SSLContext.setDefault(this.getSslContext());
                LOG.info("Default SSL context initialized");
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        });
    }

    @NotNull
    public synchronized SSLContext getSslContext() {
        SSLContext sSLContext = (SSLContext)this.mySslContext.getValue();
        if (sSLContext == null) {
            CertificateManager.$$$reportNull$$$0(2);
        }
        return sSLContext;
    }

    @NotNull
    private SSLContext calcSslContext() {
        SSLContext context = CertificateManager.getSystemSslContext();
        try {
            context.init(CertificateManager.getDefaultKeyManagers(), new TrustManager[]{this.getTrustManager()}, null);
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
        }
        SSLContext sSLContext = context;
        if (sSLContext == null) {
            CertificateManager.$$$reportNull$$$0(3);
        }
        return sSLContext;
    }

    @NotNull
    public static SSLContext getSystemSslContext() {
        SSLContext sSLContext;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            sSLContext = context;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Throwable)e);
            throw new AssertionError((Object)"Cannot get system SSL context");
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
            throw new AssertionError((Object)"Cannot initialize system SSL context");
        }
        if (sSLContext == null) {
            CertificateManager.$$$reportNull$$$0(4);
        }
        return sSLContext;
    }

    public static KeyManager @Nullable [] getDefaultKeyManagers() {
        String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
        if (keyStorePath == null) {
            return null;
        }
        LOG.info("Loading custom key store specified with VM options: " + keyStorePath);
        try {
            KeyStore keyStore;
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
            try {
                keyStore = KeyStore.getInstance(keyStoreType);
            }
            catch (KeyStoreException e) {
                if (e.getCause() instanceof NoSuchAlgorithmException) {
                    LOG.error("Wrong key store type: " + keyStoreType, (Throwable)e);
                    return null;
                }
                throw e;
            }
            Path keyStoreFile = Paths.get(keyStorePath, new String[0]);
            String password = System.getProperty("javax.net.ssl.keyStorePassword", "");
            if (password.isEmpty() && SystemInfoRt.isMac) {
                try {
                    String itemName = FileUtilRt.getNameWithoutExtension((String)keyStoreFile.getFileName().toString());
                    password = PasswordSafe.getInstance().getPassword(new CredentialAttributes(itemName, itemName));
                    if (password == null) {
                        password = "";
                    }
                }
                catch (Throwable e) {
                    LOG.error("Cannot get password for " + keyStorePath, e);
                }
            }
            try (InputStream inputStream = Files.newInputStream(keyStoreFile, new OpenOption[0]);){
                keyStore.load(inputStream, password.toCharArray());
                factory.init(keyStore, password.toCharArray());
            }
            catch (NoSuchFileException e) {
                LOG.error("Key store file not found: " + keyStorePath);
                return null;
            }
            catch (Exception e) {
                if (e.getCause() instanceof BadPaddingException || e.getCause() instanceof UnrecoverableKeyException) {
                    LOG.error("Wrong key store password (sha-256): " + DigestUtil.sha256Hex((byte[])password.getBytes(StandardCharsets.UTF_8)), (Throwable)e);
                    return null;
                }
                throw e;
            }
            return factory.getKeyManagers();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public String getCacertsPath() {
        String string = DEFAULT_PATH;
        if (string == null) {
            CertificateManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getPassword() {
        return DEFAULT_PASSWORD;
    }

    @NotNull
    public ConfirmingTrustManager getTrustManager() {
        ConfirmingTrustManager confirmingTrustManager = (ConfirmingTrustManager)this.myTrustManager.getValue();
        if (confirmingTrustManager == null) {
            CertificateManager.$$$reportNull$$$0(6);
        }
        return confirmingTrustManager;
    }

    @NotNull
    public ConfirmingTrustManager.MutableTrustManager getCustomTrustManager() {
        ConfirmingTrustManager.MutableTrustManager mutableTrustManager = this.getTrustManager().getCustomManager();
        if (mutableTrustManager == null) {
            CertificateManager.$$$reportNull$$$0(7);
        }
        return mutableTrustManager;
    }

    public static boolean showAcceptDialog(@NotNull Callable<? extends DialogWrapper> dialogFactory) {
        if (dialogFactory == null) {
            CertificateManager.$$$reportNull$$$0(8);
        }
        Application app = ApplicationManager.getApplication();
        CountDownLatch proceeded = new CountDownLatch(1);
        AtomicBoolean accepted = new AtomicBoolean();
        AtomicReference dialogRef = new AtomicReference();
        Runnable showDialog = () -> {
            if (proceeded.getCount() == 0L) {
                return;
            }
            try {
                DialogWrapper dialog = (DialogWrapper)dialogFactory.call();
                dialogRef.set(dialog);
                accepted.set(dialog.showAndGet());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                proceeded.countDown();
            }
        };
        if (app.isDispatchThread()) {
            showDialog.run();
        } else {
            app.invokeLater(showDialog, ModalityState.any());
        }
        try {
            boolean inTime = proceeded.await(5000L, TimeUnit.MILLISECONDS);
            if (!inTime) {
                DialogWrapper dialog = (DialogWrapper)dialogRef.get();
                if (dialog == null || !dialog.isShowing()) {
                    LOG.debug("After 5000 ms dialog was not shown. Rejecting certificate. Current thread: " + Thread.currentThread().getName());
                    proceeded.countDown();
                    return false;
                }
                proceeded.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            proceeded.countDown();
        }
        return accepted.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T runWithUntrustedCertificateStrategy(@NotNull ThrowableComputable<T, E> computable, @NotNull UntrustedCertificateStrategy strategy) throws E {
        if (computable == null) {
            CertificateManager.$$$reportNull$$$0(9);
        }
        if (strategy == null) {
            CertificateManager.$$$reportNull$$$0(10);
        }
        ConfirmingTrustManager trustManager = this.getTrustManager();
        trustManager.myUntrustedCertificateStrategy.set(strategy);
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            trustManager.myUntrustedCertificateStrategy.remove();
        }
    }

    @Override
    @NotNull
    public Config getState() {
        Config config = this.myConfig;
        if (config == null) {
            CertificateManager.$$$reportNull$$$0(11);
        }
        return config;
    }

    @Override
    public void loadState(@NotNull Config state) {
        if (state == null) {
            CertificateManager.$$$reportNull$$$0(12);
        }
        this.myConfig = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogFactory";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "tryMigratingDefaultTruststore";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSslContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcSslContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemSslContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacertsPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrustManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTrustManager";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showAcceptDialog";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithUntrustedCertificateStrategy";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Config {
        public boolean ACCEPT_AUTOMATICALLY = false;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Config config = (Config)o;
            return this.ACCEPT_AUTOMATICALLY == config.ACCEPT_AUTOMATICALLY;
        }

        public int hashCode() {
            return this.ACCEPT_AUTOMATICALLY ? 1 : 0;
        }
    }
}

