/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import com.intellij.junit4.ExpectedPatterns;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.CompositeTestSource;
import org.junit.platform.engine.support.descriptor.FileSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;
import org.opentest4j.ValueWrapper;

public class JUnit5TestExecutionListener
implements TestExecutionListener {
    private static final String NO_LOCATION_HINT = "";
    private static final String NO_LOCATION_HINT_VALUE = "";
    private final PrintStream myPrintStream;
    private TestPlan myTestPlan;
    private long myCurrentTestStart;
    private int myFinishCount = 0;
    private String myRootName;
    private boolean mySuccessful = true;
    private String myIdSuffix = "";
    private final Set<TestIdentifier> myActiveRoots = new LinkedHashSet<TestIdentifier>();
    private boolean mySendTree;

    public JUnit5TestExecutionListener() {
        this(System.out);
    }

    public JUnit5TestExecutionListener(PrintStream printStream) {
        this.myPrintStream = printStream;
        this.myPrintStream.println("##teamcity[enteredTheMatrix]");
    }

    public boolean wasSuccessful() {
        return this.mySuccessful;
    }

    public void initializeIdSuffix(boolean forked) {
        if (forked && this.myIdSuffix.length() == 0) {
            this.myIdSuffix = String.valueOf(System.currentTimeMillis());
        }
    }

    public void initializeIdSuffix(int i) {
        this.myIdSuffix = i + "th";
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        StringBuilder builder = new StringBuilder();
        builder.append("timestamp = ").append(entry.getTimestamp());
        entry.getKeyValuePairs().forEach((key, value) -> builder.append(", ").append((String)key).append(" = ").append((String)value));
        builder.append("\n");
        this.myPrintStream.println("##teamcity[testStdOut" + this.idAndName(testIdentifier) + " out = '" + JUnit5TestExecutionListener.escapeName(builder.toString()) + "']");
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.myTestPlan = testPlan;
        if (this.mySendTree) {
            if (Boolean.parseBoolean(System.getProperty("idea.junit.show.engines", "true"))) {
                this.myTestPlan.getRoots().stream().filter(root1 -> !this.myTestPlan.getChildren(root1).isEmpty()).forEach(this.myActiveRoots::add);
            }
            if (this.myActiveRoots.size() > 1) {
                for (TestIdentifier root : this.myActiveRoots) {
                    this.sendTreeUnderRoot(root, new HashSet<TestIdentifier>());
                }
            } else {
                for (TestIdentifier root : this.myTestPlan.getRoots()) {
                    assert (root.isContainer());
                    for (TestIdentifier testIdentifier : this.myTestPlan.getChildren(root)) {
                        this.sendTreeUnderRoot(testIdentifier, new HashSet<TestIdentifier>());
                    }
                }
            }
            this.myPrintStream.println("##teamcity[treeEnded]");
        }
        if (this.myRootName != null) {
            int lastPointIdx = this.myRootName.lastIndexOf(46);
            String name = this.myRootName;
            String comment = null;
            if (lastPointIdx >= 0) {
                name = this.myRootName.substring(lastPointIdx + 1);
                comment = this.myRootName.substring(0, lastPointIdx);
            }
            this.myPrintStream.println("##teamcity[rootName name = '" + JUnit5TestExecutionListener.escapeName(name) + (comment != null ? "' comment = '" + JUnit5TestExecutionListener.escapeName(comment) : "") + "' location = 'java:suite://" + JUnit5TestExecutionListener.escapeName(this.myRootName) + "']");
        }
    }

    private void sendTreeUnderRoot(TestIdentifier root, HashSet<TestIdentifier> visited) {
        String idAndName = this.idAndName(root);
        if (root.isContainer()) {
            this.myPrintStream.println("##teamcity[suiteTreeStarted" + idAndName + " " + this.getLocationHint(root) + "]");
            for (TestIdentifier childIdentifier : this.myTestPlan.getChildren(root)) {
                if (visited.add(childIdentifier)) {
                    this.sendTreeUnderRoot(childIdentifier, visited);
                    continue;
                }
                System.err.println("Identifier '" + this.getId(childIdentifier) + "' is reused");
            }
            this.myPrintStream.println("##teamcity[suiteTreeEnded" + idAndName + "]");
        } else if (root.isTest()) {
            this.myPrintStream.println("##teamcity[suiteTreeNode " + idAndName + " " + this.getLocationHint(root) + "]");
        }
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.executionStarted(testIdentifier);
        this.executionFinished(testIdentifier, TestExecutionResult.Status.ABORTED, null, reason);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.testStarted(testIdentifier);
            this.myCurrentTestStart = System.currentTimeMillis();
        } else if (this.hasNonTrivialParent(testIdentifier)) {
            this.myFinishCount = 0;
            this.myPrintStream.println("##teamcity[testSuiteStarted" + this.idAndName(testIdentifier) + this.getLocationHint(testIdentifier) + "]");
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        Throwable throwableOptional = testExecutionResult.getThrowable().orElse(null);
        this.executionFinished(testIdentifier, status, throwableOptional, null);
        this.mySuccessful &= TestExecutionResult.Status.SUCCESSFUL == testExecutionResult.getStatus();
    }

    private void executionFinished(TestIdentifier testIdentifier, TestExecutionResult.Status status, Throwable throwableOptional, String reason) {
        String displayName = testIdentifier.getDisplayName();
        if (testIdentifier.isTest()) {
            long duration = this.getDuration();
            if (status == TestExecutionResult.Status.FAILED) {
                this.testFailure(testIdentifier, "testFailed", throwableOptional, duration, reason, true);
            } else if (status == TestExecutionResult.Status.ABORTED) {
                this.testFailure(testIdentifier, "testIgnored", throwableOptional, duration, reason, true);
            }
            this.testFinished(testIdentifier, duration);
            ++this.myFinishCount;
        } else if (this.hasNonTrivialParent(testIdentifier)) {
            String messageName = null;
            if (status == TestExecutionResult.Status.FAILED) {
                messageName = "testFailed";
            } else if (status == TestExecutionResult.Status.ABORTED) {
                messageName = "testIgnored";
            }
            if (messageName != null) {
                Set descendants;
                if (status == TestExecutionResult.Status.FAILED) {
                    String parentId = this.getParentId(testIdentifier);
                    String nameAndId = " name='Class Configuration' nodeId='" + JUnit5TestExecutionListener.escapeName(this.getId(testIdentifier)) + "' parentNodeId='" + JUnit5TestExecutionListener.escapeName(parentId) + "' ";
                    this.testFailure("Class Configuration", this.getId(testIdentifier), parentId, messageName, throwableOptional, 0L, reason, true);
                    this.myPrintStream.println("##teamcity[testFinished" + nameAndId + "]");
                }
                Set set = descendants = this.myTestPlan != null ? this.myTestPlan.getDescendants(testIdentifier) : Collections.emptySet();
                if (!descendants.isEmpty() && this.myFinishCount == 0) {
                    for (TestIdentifier childIdentifier : descendants) {
                        this.testStarted(childIdentifier);
                        this.testFailure(childIdentifier, "testIgnored", status == TestExecutionResult.Status.ABORTED ? throwableOptional : null, 0L, reason, status == TestExecutionResult.Status.ABORTED);
                        this.testFinished(childIdentifier, 0L);
                    }
                    this.myFinishCount = 0;
                }
            }
            this.myPrintStream.println("##teamcity[testSuiteFinished " + this.idAndName(testIdentifier, displayName) + "]");
        }
    }

    private boolean hasNonTrivialParent(TestIdentifier testIdentifier) {
        return testIdentifier.getParentId().isPresent() || this.myActiveRoots.size() > 1 && this.myActiveRoots.contains(testIdentifier);
    }

    protected long getDuration() {
        return System.currentTimeMillis() - this.myCurrentTestStart;
    }

    private void testStarted(TestIdentifier testIdentifier) {
        this.myPrintStream.println("##teamcity[testStarted" + this.idAndName(testIdentifier) + " " + this.getLocationHint(testIdentifier) + "]");
    }

    private void testFinished(TestIdentifier testIdentifier, long duration) {
        this.myPrintStream.println("##teamcity[testFinished" + this.idAndName(testIdentifier) + (duration > 0L ? " duration='" + duration + "'" : "") + "]");
    }

    private void testFailure(TestIdentifier testIdentifier, String messageName, Throwable ex, long duration, String reason, boolean includeThrowable) {
        this.testFailure(testIdentifier.getDisplayName(), this.getId(testIdentifier), this.getParentId(testIdentifier), messageName, ex, duration, reason, includeThrowable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFailure(String methodName, String id, String parentId, String messageName, Throwable ex, long duration, String reason, boolean includeThrowable) {
        block14: {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("name", methodName);
            attrs.put("id", id);
            attrs.put("nodeId", id);
            attrs.put("parentNodeId", parentId);
            if (duration > 0L) {
                attrs.put("duration", Long.toString(duration));
            }
            if (reason != null) {
                attrs.put("message", reason);
            }
            try {
                if (ex == null) break block14;
                ComparisonFailureData failureData = null;
                if (ex instanceof MultipleFailuresError && ((MultipleFailuresError)ex).hasFailures()) {
                    for (Throwable assertionError : ((MultipleFailuresError)ex).getFailures()) {
                        this.testFailure(methodName, id, parentId, messageName, assertionError, duration, reason, false);
                    }
                } else if (ex instanceof AssertionFailedError && ((AssertionFailedError)ex).isActualDefined() && ((AssertionFailedError)ex).isExpectedDefined()) {
                    ValueWrapper actual = ((AssertionFailedError)ex).getActual();
                    ValueWrapper expected = ((AssertionFailedError)ex).getExpected();
                    failureData = new ComparisonFailureData(expected.getStringRepresentation(), actual.getStringRepresentation());
                } else {
                    try {
                        failureData = ExpectedPatterns.createExceptionNotification((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (includeThrowable || failureData == null) {
                    ComparisonFailureData.registerSMAttributes((ComparisonFailureData)failureData, (String)this.getTrace(ex), (String)ex.getMessage(), attrs, (Throwable)ex, (String)"Comparison Failure: ", (String)"expected: <");
                } else {
                    ComparisonFailureData.registerSMAttributes((ComparisonFailureData)failureData, (String)"", (String)ex.getMessage(), attrs, (Throwable)ex, (String)"Comparison Failure: ", (String)"expected: <");
                }
            }
            finally {
                this.myPrintStream.println(MapSerializerUtil.asString((String)messageName, attrs));
            }
        }
    }

    protected String getTrace(Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        ex.printStackTrace(writer);
        return stringWriter.toString();
    }

    public void setRootName(String rootName) {
        this.myRootName = rootName;
    }

    void setSendTree() {
        this.mySendTree = true;
    }

    private String getId(TestIdentifier identifier) {
        return identifier.getUniqueId() + this.myIdSuffix;
    }

    private String idAndName(TestIdentifier testIdentifier) {
        return this.idAndName(testIdentifier, testIdentifier.getDisplayName());
    }

    private String idAndName(TestIdentifier testIdentifier, String displayName) {
        return " id='" + JUnit5TestExecutionListener.escapeName(this.getId(testIdentifier)) + "' name='" + JUnit5TestExecutionListener.escapeName(displayName) + "' nodeId='" + JUnit5TestExecutionListener.escapeName(this.getId(testIdentifier)) + "' parentNodeId='" + JUnit5TestExecutionListener.escapeName(this.getParentId(testIdentifier)) + "'";
    }

    private String getParentId(TestIdentifier testIdentifier) {
        Optional parent = this.myTestPlan.getParent(testIdentifier);
        if (this.myActiveRoots.size() <= 1 && !parent.flatMap(TestIdentifier::getParentId).isPresent()) {
            return "0";
        }
        return parent.map(identifier -> identifier.getUniqueId() + this.myIdSuffix).orElse("0");
    }

    private String getLocationHint(TestIdentifier root) {
        return JUnit5TestExecutionListener.getLocationHint(root, this.myTestPlan.getParent(root).orElse(null));
    }

    static String getLocationHint(TestIdentifier root, TestIdentifier rootParent) {
        return root.getSource().map(testSource -> JUnit5TestExecutionListener.getLocationHintValue(testSource, rootParent != null ? (TestSource)rootParent.getSource().orElse(null) : null)).filter(maybeLocationHintValue -> !"".equals(maybeLocationHintValue)).map(locationHintValue -> "locationHint='" + locationHintValue + "'" + JUnit5TestExecutionListener.getMetainfo(root)).orElse("");
    }

    private static String getMetainfo(TestIdentifier root) {
        return root.getSource().map(testSource -> {
            if (testSource instanceof MethodSource) {
                return " metainfo='" + ((MethodSource)testSource).getMethodParameterTypes() + "'";
            }
            if (testSource instanceof ClassSource) {
                return ((ClassSource)testSource).getPosition().map(position -> " metainfo='" + position.getLine() + ":" + position.getColumn() + "'").orElse("");
            }
            return "";
        }).orElse("");
    }

    static String getLocationHintValue(TestSource testSource, TestSource parentSource) {
        if (testSource instanceof CompositeTestSource) {
            CompositeTestSource compositeTestSource = (CompositeTestSource)testSource;
            for (TestSource sourceFromComposite : compositeTestSource.getSources()) {
                String locationHintValue = JUnit5TestExecutionListener.getLocationHintValue(sourceFromComposite, parentSource);
                if ("".equals(locationHintValue)) continue;
                return locationHintValue;
            }
            return "";
        }
        if (testSource instanceof FileSource) {
            FileSource fileSource = (FileSource)testSource;
            File file = fileSource.getFile();
            String line = fileSource.getPosition().map(position -> ":" + position.getLine()).orElse("");
            return "file://" + file.getAbsolutePath() + line;
        }
        if (testSource instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)testSource;
            return JUnit5TestExecutionListener.javaLocation(methodSource.getClassName(), methodSource.getMethodName(), true);
        }
        if (testSource instanceof ClassSource) {
            String className = ((ClassSource)testSource).getClassName();
            return JUnit5TestExecutionListener.javaLocation(className, null, false);
        }
        if (parentSource != null) {
            return JUnit5TestExecutionListener.getLocationHintValue(parentSource, null);
        }
        return "";
    }

    private static String javaLocation(String className, String maybeMethodName, boolean isTest) {
        String type = isTest ? "test" : "suite";
        String methodName = maybeMethodName == null ? "" : "/" + maybeMethodName;
        String location = JUnit5TestExecutionListener.escapeName(className + methodName);
        return "java:" + type + "://" + location;
    }

    private static String escapeName(String str) {
        return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }

    static String getClassName(TestIdentifier description) {
        return description.getSource().map(source -> {
            if (source instanceof MethodSource) {
                return ((MethodSource)source).getClassName();
            }
            if (source instanceof ClassSource) {
                return ((ClassSource)source).getClassName();
            }
            return null;
        }).orElse(null);
    }

    static String getMethodName(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().map(source -> {
            if (source instanceof MethodSource) {
                return ((MethodSource)source).getMethodName();
            }
            return null;
        }).orElse(null);
    }

    static String getMethodSignature(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().map(source -> {
            if (source instanceof MethodSource) {
                String parameterTypes = ((MethodSource)source).getMethodParameterTypes();
                return ((MethodSource)source).getMethodName() + (parameterTypes != null ? "(" + parameterTypes + ")" : "");
            }
            return null;
        }).orElse(null);
    }
}

