/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndexExtension;
import com.intellij.indexing.shared.platform.impl.HashIndexKey;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfigurationImpl;
import com.intellij.indexing.shared.platform.impl.SharedIndexInfrastructure;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.impl.forward.AbstractForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntBinaryOperator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u00112\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex;", "Lcom/intellij/util/indexing/impl/forward/ForwardIndex;", "hashIndexId", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "(Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;)V", "indexVersion", "Ljava/util/concurrent/atomic/AtomicInteger;", "clear", "", "close", "force", "get", "Lcom/intellij/openapi/util/io/ByteArraySequence;", "fileId", "", "put", "value", "Companion", "IndexData", "MultiHashes", "MultiHashesExternalizer", "ReindexCountFile", "intellij.indexing.shared"})
public final class AttrBasedFileContentHashForwardIndex
implements ForwardIndex {
    private volatile AtomicInteger indexVersion;
    private final HashIndexKey hashIndexId;
    private static final Logger log;
    private static final com.intellij.openapi.vfs.newvfs.FileAttribute multiHashesAttr;
    private static final ConcurrentHashMap<Integer, MultiHashes> unsavedMultiHashes;
    @NotNull
    private static final ExecutorService executor;
    private static final Cache<Integer, MultiHashes> cachedMultiHashes;
    private static final ConcurrentHashMap<HashIndexKey, AtomicInteger> indexVersions;
    private static final ReindexCountFile indexVersionFile;
    @NotNull
    public static final Companion Companion;

    public void close() {
        this.force();
    }

    public void force() {
        AttrBasedFileContentHashForwardIndex.Companion.flush();
    }

    public void clear() {
        Companion.bumpForwardIndexVersion(this.hashIndexId);
        try {
            this.force();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public void put(int fileId, @Nullable ByteArraySequence value) {
        cachedMultiHashes.asMap().compute(fileId, new BiFunction(this, fileId, value){
            final /* synthetic */ AttrBasedFileContentHashForwardIndex this$0;
            final /* synthetic */ int $fileId;
            final /* synthetic */ ByteArraySequence $value;

            @NotNull
            public final MultiHashes apply(Integer $noName_0, @Nullable MultiHashes hashes) {
                MultiHashes multiHashes = hashes;
                return (multiHashes == null ? com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex$Companion.access$readMultiHashes(AttrBasedFileContentHashForwardIndex.Companion, this.$fileId) : hashes).setSerializedHash(AttrBasedFileContentHashForwardIndex.access$getHashIndexId$p(this.this$0).getUniqueId(), this.$value, AttrBasedFileContentHashForwardIndex.access$getIndexVersion$p(this.this$0).get());
            }
            {
                this.this$0 = attrBasedFileContentHashForwardIndex;
                this.$fileId = n;
                this.$value = byteArraySequence;
            }
        });
    }

    @Nullable
    public ByteArraySequence get(int fileId) {
        return ((MultiHashes)cachedMultiHashes.get((Object)fileId, new Function(fileId){
            final /* synthetic */ int $fileId;

            public final MultiHashes apply(Integer it) {
                return com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex$Companion.access$readMultiHashes(AttrBasedFileContentHashForwardIndex.Companion, this.$fileId);
            }
            {
                this.$fileId = n;
            }
        })).getSerializedHash(this.hashIndexId.getUniqueId(), this.indexVersion.get());
    }

    public AttrBasedFileContentHashForwardIndex(@NotNull HashIndexKey hashIndexId) {
        Intrinsics.checkNotNullParameter((Object)((Object)hashIndexId), (String)"hashIndexId");
        this.hashIndexId = hashIndexId;
        this.indexVersion = AttrBasedFileContentHashForwardIndex.Companion.getForwardIndexVersion(this.hashIndexId);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AttrBasedFileContentHashForwardIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        log = logger;
        multiHashesAttr = new com.intellij.openapi.vfs.newvfs.FileAttribute("file.content.hash.forward.multi.index", 1, false);
        unsavedMultiHashes = new ConcurrentHashMap();
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Shared Index Hash Index Flushing Queue");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026sh Index Flushing Queue\")");
        executor = executorService;
        cachedMultiHashes = Caffeine.newBuilder().maximumSize(128L).executor((Executor)executor).removalListener((RemovalListener)Companion.cachedMultiHashes.1.INSTANCE).build();
        indexVersions = new ConcurrentHashMap();
        Path path = SharedIndexChunkConfigurationImpl.getSharedIndexConfigurationRoot().resolve("forward.index.versions");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"SharedIndexChunkConfigur\u2026\"forward.index.versions\")");
        indexVersionFile = new ReindexCountFile(path);
    }

    public static final /* synthetic */ HashIndexKey access$getHashIndexId$p(AttrBasedFileContentHashForwardIndex $this) {
        return $this.hashIndexId;
    }

    public static final /* synthetic */ AtomicInteger access$getIndexVersion$p(AttrBasedFileContentHashForwardIndex $this) {
        return $this.indexVersion;
    }

    public static final /* synthetic */ void access$setIndexVersion$p(AttrBasedFileContentHashForwardIndex $this, AtomicInteger atomicInteger) {
        $this.indexVersion = atomicInteger;
    }

    @JvmStatic
    public static final synchronized void bumpForwardIndexVersion(@NotNull HashIndexKey hashIndexId) {
        Companion.bumpForwardIndexVersion(hashIndexId);
    }

    @JvmStatic
    public static final void disposeAllCaches() {
        Companion.disposeAllCaches();
    }

    @JvmStatic
    public static final void readVersions() {
        Companion.readVersions();
    }

    @JvmStatic
    public static final void bumpBaseVersion() {
        Companion.bumpBaseVersion();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData;", "", "version", "", "hashId", "", "(IJ)V", "getHashId", "()J", "getVersion", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "EXTERNALIZER", "intellij.indexing.shared"})
    private static final class IndexData {
        private final int version;
        private final long hashId;

        public final int getVersion() {
            return this.version;
        }

        public final long getHashId() {
            return this.hashId;
        }

        public IndexData(int version, long hashId) {
            this.version = version;
            this.hashId = hashId;
        }

        public final int component1() {
            return this.version;
        }

        public final long component2() {
            return this.hashId;
        }

        @NotNull
        public final IndexData copy(int version, long hashId) {
            return new IndexData(version, hashId);
        }

        public static /* synthetic */ IndexData copy$default(IndexData indexData, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = indexData.version;
            }
            if ((n2 & 2) != 0) {
                l = indexData.hashId;
            }
            return indexData.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "IndexData(version=" + this.version + ", hashId=" + this.hashId + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.version) * 31 + Long.hashCode(this.hashId);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IndexData)) break block3;
                    IndexData indexData = (IndexData)object;
                    if (this.version != indexData.version || this.hashId != indexData.hashId) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData$EXTERNALIZER;", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData;", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "intellij.indexing.shared"})
        public static final class EXTERNALIZER
        implements DataExternalizer<IndexData> {
            @NotNull
            public static final EXTERNALIZER INSTANCE;

            public void save(@NotNull DataOutput out, @NotNull IndexData value) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.getVersion());
                DataInputOutputUtil.writeLONG((DataOutput)out, (long)value.getHashId());
            }

            @NotNull
            public IndexData read(@NotNull DataInput in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new IndexData(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readLONG((DataInput)in));
            }

            private EXTERNALIZER() {
            }

            static {
                EXTERNALIZER eXTERNALIZER;
                INSTANCE = eXTERNALIZER = new EXTERNALIZER();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\r\u001a\u00020\u0000J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J \u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashes;", "", "hashes", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMaps$SynchronizedMap;", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$IndexData;", "(Lit/unimi/dsi/fastutil/ints/Int2ObjectMaps$SynchronizedMap;)V", "getHashes", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMaps$SynchronizedMap;", "isDirty", "", "()Z", "setDirty", "(Z)V", "copy", "getSerializedHash", "Lcom/intellij/openapi/util/io/ByteArraySequence;", "indexId", "", "forwardIndexVersion", "setSerializedHash", "serializedHashId", "intellij.indexing.shared"})
    private static final class MultiHashes {
        private volatile boolean isDirty;
        @NotNull
        private final Int2ObjectMaps.SynchronizedMap<IndexData> hashes;

        public final boolean isDirty() {
            return this.isDirty;
        }

        public final void setDirty(boolean bl) {
            this.isDirty = bl;
        }

        @Nullable
        public final ByteArraySequence getSerializedHash(int indexId2, int forwardIndexVersion) {
            IndexData indexData = (IndexData)this.hashes.get(indexId2);
            if (indexData == null) {
                return null;
            }
            IndexData hashData = indexData;
            if (hashData.getVersion() != forwardIndexVersion) {
                return null;
            }
            return AbstractForwardIndexAccessor.serializeKeyToByteSeq((Object)hashData.getHashId(), (DataExternalizer)((DataExternalizer)FileContentHashIndexExtension.HASH_ID_DESCRIPTOR), (int)8);
        }

        @NotNull
        public final MultiHashes setSerializedHash(int indexId2, @Nullable ByteArraySequence serializedHashId, int forwardIndexVersion) {
            Long hashId;
            if (serializedHashId == null) {
                IndexData oldData = (IndexData)this.hashes.remove(indexId2);
                if (!this.isDirty && oldData != null) {
                    this.isDirty = true;
                }
                return this;
            }
            Long l = hashId = (Long)AbstractForwardIndexAccessor.deserializeFromByteSeq((ByteArraySequence)serializedHashId, (DataExternalizer)((DataExternalizer)FileContentHashIndexExtension.HASH_ID_DESCRIPTOR));
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"hashId");
            IndexData indexData = new IndexData(forwardIndexVersion, l);
            IndexData oldIndexData = (IndexData)this.hashes.put(indexId2, (Object)indexData);
            if (!this.isDirty && Intrinsics.areEqual((Object)oldIndexData, (Object)indexData) ^ true) {
                this.isDirty = true;
            }
            return this;
        }

        @NotNull
        public final MultiHashes copy() {
            return new MultiHashes(this.hashes);
        }

        @NotNull
        public final Int2ObjectMaps.SynchronizedMap<IndexData> getHashes() {
            return this.hashes;
        }

        public MultiHashes(@NotNull Int2ObjectMaps.SynchronizedMap<IndexData> hashes) {
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            this.hashes = hashes;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashesExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashes;", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "data", "intellij.indexing.shared"})
    private static final class MultiHashesExternalizer
    implements DataExternalizer<MultiHashes> {
        @NotNull
        public static final MultiHashesExternalizer INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void save(@NotNull DataOutput out, @NotNull MultiHashes data) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Int2ObjectMaps.SynchronizedMap<IndexData> synchronizedMap = data.getHashes();
            boolean bl = false;
            boolean bl2 = false;
            synchronized (synchronizedMap) {
                boolean bl3 = false;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)data.getHashes().size());
                ObjectIterator objectIterator = data.getHashes().int2ObjectEntrySet().iterator();
                while (objectIterator.hasNext()) {
                    Int2ObjectMap.Entry entry;
                    Int2ObjectMap.Entry entry2 = entry = (Int2ObjectMap.Entry)objectIterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"entry");
                    int indexId2 = entry2.getIntKey();
                    IndexData indexData = (IndexData)entry.getValue();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)indexId2);
                    IndexData indexData2 = indexData;
                    Intrinsics.checkNotNullExpressionValue((Object)indexData2, (String)"indexData");
                    IndexData.EXTERNALIZER.INSTANCE.save(out, indexData2);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @NotNull
        public MultiHashes read(@NotNull DataInput in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            int size = DataInputOutputUtil.readINT((DataInput)in);
            Int2ObjectOpenHashMap result2 = new Int2ObjectOpenHashMap(size);
            boolean bl = false;
            int n = 0;
            n = 0;
            int n2 = size;
            while (n < n2) {
                int it = n++;
                boolean bl2 = false;
                result2.put(DataInputOutputUtil.readINT((DataInput)in), (Object)IndexData.EXTERNALIZER.INSTANCE.read(in));
            }
            Int2ObjectMap int2ObjectMap = Int2ObjectMaps.synchronize((Int2ObjectMap)((Int2ObjectMap)result2));
            if (int2ObjectMap == null) {
                throw new NullPointerException("null cannot be cast to non-null type it.unimi.dsi.fastutil.ints.Int2ObjectMaps.SynchronizedMap<com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex.IndexData>");
            }
            return new MultiHashes((Int2ObjectMaps.SynchronizedMap<IndexData>)((Int2ObjectMaps.SynchronizedMap)int2ObjectMap));
        }

        private MultiHashesExternalizer() {
        }

        static {
            MultiHashesExternalizer multiHashesExternalizer;
            INSTANCE = multiHashesExternalizer = new MultiHashesExternalizer();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile;", "", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "idToVersion", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "", "bumpBaseVersion", "", "bumpVersion", "key", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "getBaseVersion", "", "getIndexVersion", "readVersions", "Companion", "intellij.indexing.shared"})
    private static final class ReindexCountFile {
        private Object2IntMap<String> idToVersion;
        private final Path file;
        @Deprecated
        private static final String baseVersionPropertyName = "shared.index.file.content.hash.forward.index.base";
        @NotNull
        private static final Companion Companion = new Companion(null);

        public final synchronized void readVersions() {
            this.idToVersion = ReindexCountFile.Companion.readFile(this.file);
        }

        public final synchronized int getBaseVersion() {
            return this.idToVersion.getInt((Object)baseVersionPropertyName);
        }

        public final synchronized int getIndexVersion(@NotNull HashIndexKey key) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            return this.idToVersion.getInt((Object)ReindexCountFile.Companion.versionPropertyName(key));
        }

        public final synchronized void bumpBaseVersion() {
            ((Map)this.idToVersion).put(baseVersionPropertyName, Integer.valueOf((short)System.currentTimeMillis()));
            ReindexCountFile.Companion.writeFile(this.file, (Object2IntMap<String>)this.idToVersion);
        }

        public final synchronized void bumpVersion(@NotNull HashIndexKey key) {
            Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
            this.idToVersion.mergeInt((Object)ReindexCountFile.Companion.versionPropertyName(key), 1, (IntBinaryOperator)bumpVersion.1.INSTANCE);
            ReindexCountFile.Companion.writeFile(this.file, (Object2IntMap<String>)this.idToVersion);
        }

        public ReindexCountFile(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.idToVersion = ReindexCountFile.Companion.readFile(this.file);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile$Companion;", "", "()V", "baseVersionPropertyName", "", "readFile", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "file", "Ljava/nio/file/Path;", "setupNewFile", "versionPropertyName", "hashIndexId", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "writeFile", "", "versions", "intellij.indexing.shared"})
        private static final class Companion {
            private final String versionPropertyName(HashIndexKey hashIndexId) {
                return "shared.index.file.content.hash.forward.index." + (Object)((Object)hashIndexId);
            }

            private final Object2IntMap<String> readFile(Path file) {
                Object2IntMap object2IntMap;
                if (!PathKt.exists((Path)file)) {
                    return this.setupNewFile(file);
                }
                try {
                    Object2IntOpenHashMap versions = new Object2IntOpenHashMap();
                    List<String> list = Files.readAllLines(file, Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(file, Charsets.UTF_8)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        String string = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                        String name = StringsKt.substringBeforeLast$default((String)string, (String)":", null, (int)2, null);
                        String string2 = StringsKt.substringAfterLast$default((String)it, (String)":", null, (int)2, null);
                        boolean bl2 = false;
                        int version = Integer.parseInt(string2);
                        ((Map)versions).put(name, version);
                    }
                    object2IntMap = (Object2IntMap)versions;
                }
                catch (IOException e) {
                    object2IntMap = this.setupNewFile(file);
                }
                return object2IntMap;
            }

            private final Object2IntMap<String> setupNewFile(Path file) {
                Object2IntOpenHashMap versions = new Object2IntOpenHashMap();
                this.writeFile(file, (Object2IntMap<String>)((Object2IntMap)versions));
                return (Object2IntMap)versions;
            }

            /*
             * WARNING - void declaration
             */
            private final void writeFile(Path file, Object2IntMap<String> versions) {
                void $this$mapTo$iv$iv;
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                ObjectIterable objectIterable = Object2IntMaps.fastIterable(versions);
                Intrinsics.checkNotNullExpressionValue((Object)objectIterable, (String)"Object2IntMaps.fastIterable(versions)");
                Iterable $this$map$iv = (Iterable)objectIterable;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    StringBuilder stringBuilder = new StringBuilder().append((String)it.getKey()).append(':');
                    void v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    String string = stringBuilder.append(v2.getIntValue()).toString();
                    collection.add(string);
                }
                List lines = (List)destination$iv$iv;
                Files.write(file, (Iterable<? extends CharSequence>)lines, Charsets.UTF_8, new OpenOption[0]);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0011H\u0007J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0007J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u0007H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u0005H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u0019H\u0007J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0007H\u0002RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$Companion;", "", "()V", "cachedMultiHashes", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$MultiHashes;", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "indexVersionFile", "Lcom/intellij/indexing/shared/platform/impl/AttrBasedFileContentHashForwardIndex$ReindexCountFile;", "indexVersions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/indexing/shared/platform/impl/HashIndexKey;", "Ljava/util/concurrent/atomic/AtomicInteger;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "multiHashesAttr", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "unsavedMultiHashes", "bumpBaseVersion", "", "bumpForwardIndexVersion", "hashIndexId", "calculateForwardIndexVersion", "disposeAllCaches", "flush", "getCurrentReindexCount", "getForwardIndexVersion", "newMultiHashes", "readFromAttrs", "fileId", "readMultiHashes", "readVersions", "writeHashes", "multiHashes", "intellij.indexing.shared"})
    public static final class Companion {
        @NotNull
        public final ExecutorService getExecutor() {
            return executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void writeHashes(int fileId, MultiHashes multiHashes) {
            block10: {
                try {
                    if (!multiHashes.isDirty()) break block10;
                    try {
                        Closeable closeable = (Closeable)FSRecords.writeAttribute((int)fileId, (com.intellij.openapi.vfs.newvfs.FileAttribute)multiHashesAttr);
                        boolean bl = false;
                        boolean bl2 = false;
                        Throwable throwable = null;
                        try {
                            DataOutputStream it = (DataOutputStream)closeable;
                            boolean bl3 = false;
                            DataOutputStream dataOutputStream = it;
                            Intrinsics.checkNotNullExpressionValue((Object)dataOutputStream, (String)"it");
                            MultiHashesExternalizer.INSTANCE.save((DataOutput)dataOutputStream, multiHashes);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    catch (Throwable e) {
                        log.error(e);
                        throw e;
                    }
                }
                finally {
                    unsavedMultiHashes.remove(fileId, multiHashes);
                }
            }
        }

        private final MultiHashes readMultiHashes(int fileId) {
            Object v = unsavedMultiHashes.compute(fileId, new BiFunction(fileId){
                final /* synthetic */ int $fileId;

                @NotNull
                public final MultiHashes apply(@NotNull Integer $noName_0, @Nullable MultiHashes oldUnsavedHashes) {
                    MultiHashes multiHashes;
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                    MultiHashes multiHashes2 = oldUnsavedHashes;
                    if (multiHashes2 == null) {
                        multiHashes = com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex$Companion.access$readFromAttrs(AttrBasedFileContentHashForwardIndex.Companion, this.$fileId);
                        if (multiHashes == null) {
                            multiHashes = com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex$Companion.access$newMultiHashes(AttrBasedFileContentHashForwardIndex.Companion);
                        }
                    } else {
                        multiHashes = oldUnsavedHashes.copy();
                    }
                    return multiHashes;
                }
                {
                    this.$fileId = n;
                }
            });
            Intrinsics.checkNotNull(v);
            return (MultiHashes)v;
        }

        private final MultiHashes newMultiHashes() {
            Int2ObjectMap int2ObjectMap = Int2ObjectMaps.synchronize((Int2ObjectMap)((Int2ObjectMap)new Int2ObjectOpenHashMap()));
            if (int2ObjectMap == null) {
                throw new NullPointerException("null cannot be cast to non-null type it.unimi.dsi.fastutil.ints.Int2ObjectMaps.SynchronizedMap<com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex.IndexData>");
            }
            return new MultiHashes((Int2ObjectMaps.SynchronizedMap<IndexData>)((Int2ObjectMaps.SynchronizedMap)int2ObjectMap));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final MultiHashes readFromAttrs(int fileId) {
            MultiHashes multiHashes;
            DataInputStream dataInputStream = FSRecords.readAttributeWithLock((int)fileId, (com.intellij.openapi.vfs.newvfs.FileAttribute)multiHashesAttr);
            if (dataInputStream != null) {
                Closeable closeable = dataInputStream;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    DataInputStream input = (DataInputStream)closeable;
                    boolean bl3 = false;
                    DataInputStream dataInputStream2 = input;
                    Intrinsics.checkNotNullExpressionValue((Object)dataInputStream2, (String)"input");
                    MultiHashes multiHashes2 = MultiHashesExternalizer.INSTANCE.read(dataInputStream2);
                    multiHashes = multiHashes2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                multiHashes = null;
            }
            return multiHashes;
        }

        private final int calculateForwardIndexVersion(HashIndexKey hashIndexId) {
            return this.getCurrentReindexCount(hashIndexId) + SharedIndexInfrastructure.SHARED_INDEX_INFRASTRUCTURE_VERSION;
        }

        @JvmStatic
        public final synchronized void bumpForwardIndexVersion(@NotNull HashIndexKey hashIndexId) {
            Intrinsics.checkNotNullParameter((Object)((Object)hashIndexId), (String)"hashIndexId");
            indexVersionFile.bumpVersion(hashIndexId);
            ((AtomicInteger)indexVersions.computeIfAbsent(hashIndexId, bumpForwardIndexVersion.1.INSTANCE)).set(this.calculateForwardIndexVersion(hashIndexId));
        }

        private final AtomicInteger getForwardIndexVersion(HashIndexKey hashIndexId) {
            Object v = indexVersions.computeIfAbsent(hashIndexId, new Function(hashIndexId){
                final /* synthetic */ HashIndexKey $hashIndexId;

                @NotNull
                public final AtomicInteger apply(@NotNull HashIndexKey it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return new AtomicInteger(com.intellij.indexing.shared.platform.impl.AttrBasedFileContentHashForwardIndex$Companion.access$calculateForwardIndexVersion(AttrBasedFileContentHashForwardIndex.Companion, this.$hashIndexId));
                }
                {
                    this.$hashIndexId = hashIndexKey;
                }
            });
            Intrinsics.checkNotNullExpressionValue(v, (String)"indexVersions.computeIfA\u2026exVersion(hashIndexId)) }");
            return (AtomicInteger)v;
        }

        private final int getCurrentReindexCount(HashIndexKey hashIndexId) {
            return indexVersionFile.getIndexVersion(hashIndexId) + indexVersionFile.getBaseVersion();
        }

        @JvmStatic
        public final void disposeAllCaches() {
            indexVersions.clear();
            this.flush();
        }

        /*
         * WARNING - void declaration
         */
        private final void flush() {
            cachedMultiHashes.invalidateAll();
            Future<?> flusher = this.getExecutor().submit(EmptyRunnable.getInstance());
            int n = 0;
            int n2 = 10;
            while (n <= n2) {
                void i;
                try {
                    flusher.get(1L, TimeUnit.MINUTES);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
                Future<?> future2 = flusher;
                Intrinsics.checkNotNullExpressionValue(future2, (String)"flusher");
                if (future2.isDone()) break;
                ++i;
            }
            Future<?> future3 = flusher;
            Intrinsics.checkNotNullExpressionValue(future3, (String)"flusher");
            if (!future3.isDone()) {
                Object object = unsavedMultiHashes;
                n2 = 0;
                if (!object.isEmpty()) {
                    log.error("Too long flush operation. Trying to flush manually...");
                    Iterator iterator = unsavedMultiHashes.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void fileId;
                        Object object2 = object = iterator.next();
                        boolean bl = false;
                        Integer n3 = (Integer)object2.getKey();
                        object2 = object;
                        bl = false;
                        MultiHashes multiHashes = (MultiHashes)object2.getValue();
                        void v2 = fileId;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"fileId");
                        int n4 = v2.intValue();
                        MultiHashes multiHashes2 = multiHashes;
                        Intrinsics.checkNotNullExpressionValue((Object)multiHashes2, (String)"multiHashes");
                        this.writeHashes(n4, multiHashes2);
                    }
                }
            }
            Map map = unsavedMultiHashes;
            boolean bl = false;
            if (!map.isEmpty()) {
                throw (Throwable)new IOException("data was not flushed");
            }
        }

        @JvmStatic
        public final void readVersions() {
            indexVersionFile.readVersions();
        }

        @JvmStatic
        public final void bumpBaseVersion() {
            indexVersionFile.bumpBaseVersion();
        }

        private Companion() {
        }

        public static final /* synthetic */ MultiHashes access$readMultiHashes(Companion $this, int fileId) {
            return $this.readMultiHashes(fileId);
        }

        public static final /* synthetic */ MultiHashes access$readFromAttrs(Companion $this, int fileId) {
            return $this.readFromAttrs(fileId);
        }

        public static final /* synthetic */ MultiHashes access$newMultiHashes(Companion $this) {
            return $this.newMultiHashes();
        }

        public static final /* synthetic */ int access$calculateForwardIndexVersion(Companion $this, HashIndexKey hashIndexId) {
            return $this.calculateForwardIndexVersion(hashIndexId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$writeHashes(Companion $this, int fileId, MultiHashes multiHashes) {
            $this.writeHashes(fileId, multiHashes);
        }
    }
}

