/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.io.File;
import java.util.Set;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;

@Service(value={Service.Level.APP})
public final class MavenDomConvertersRegistry {
    private GenericDomValueConvertersRegistry myConvertersRegistry;
    private final Set<String> mySoftConverterTypes = ContainerUtil.immutableSet((Object[])new String[]{File.class.getCanonicalName()});

    public static MavenDomConvertersRegistry getInstance() {
        return (MavenDomConvertersRegistry)ApplicationManager.getApplication().getService(MavenDomConvertersRegistry.class);
    }

    public MavenDomConvertersRegistry() {
        this.myConvertersRegistry = new GenericDomValueConvertersRegistry();
        this.initConverters();
    }

    private void initConverters() {
        this.myConvertersRegistry.registerDefaultConverters();
        this.myConvertersRegistry.registerConverter((Converter)new MavenPathReferenceConverter(), File.class);
    }

    public GenericDomValueConvertersRegistry getConvertersRegistry() {
        return this.myConvertersRegistry;
    }

    public boolean isSoft(String type2) {
        return this.mySoftConverterTypes.contains(type2);
    }
}

