/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenServerManager;

public class MavenPropertyInParentInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenPropertyInParent";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        DomManager domManager;
        DomFileElement model2;
        if (file == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(3);
        }
        if (file instanceof XmlFile && file.isPhysical() && (model2 = (domManager = DomManager.getDomManager((Project)file.getProject())).getFileElement((XmlFile)file, MavenDomProjectModel.class)) != null) {
            MavenDistribution distribution = MavenServerManager.getInstance().getConnector(file.getProject(), file.getVirtualFile().getPath()).getMavenDistribution();
            boolean maven35 = distribution == null || StringUtil.compareVersionNumbers((String)distribution.getVersion(), (String)"3.5") >= 0;
            ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(3);
            MavenDomParent mavenParent = ((MavenDomProjectModel)model2.getRootElement()).getMavenParent();
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, maven35, problems, (GenericDomValue<String>)mavenParent.getGroupId());
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, maven35, problems, (GenericDomValue<String>)mavenParent.getArtifactId());
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, maven35, problems, mavenParent.getVersion());
            if (problems.isEmpty()) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    private static void validate(@NotNull InspectionManager manager, boolean isOnTheFly, boolean maven35, @NotNull List<ProblemDescriptor> problems, @NotNull GenericDomValue<String> domValue) {
        String valueToCheck;
        String unresolvedValue;
        if (manager == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(5);
        }
        if (domValue == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(6);
        }
        if ((unresolvedValue = domValue.getRawText()) == null) {
            return;
        }
        String string = valueToCheck = maven35 ? unresolvedValue.replaceAll("\\$\\{(revision|sha1|changelist)}", "") : unresolvedValue;
        if (valueToCheck.contains("${")) {
            XmlText[] textElements;
            XmlTag xmlTag;
            LocalQuickFix fix = null;
            String resolvedValue = domValue.getStringValue();
            if (resolvedValue == null) {
                return;
            }
            if (unresolvedValue.equals(resolvedValue) || resolvedValue.contains("${")) {
                resolvedValue = MavenPropertyInParentInspection.resolveXmlElement(domValue.getXmlElement());
            }
            if (!unresolvedValue.equals(resolvedValue) && !StringUtil.isEmpty((String)resolvedValue)) {
                final String finalResolvedValue = resolvedValue;
                fix = new LocalQuickFix(){

                    @IntentionFamilyName
                    @NotNull
                    public String getFamilyName() {
                        String string = MavenDomBundle.message("refactoring.inline.property", new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                        PsiElement psiElement;
                        if (project2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if ((psiElement = descriptor2.getPsiElement()) instanceof XmlTag) {
                            ((XmlTag)psiElement).getValue().setText(finalResolvedValue);
                        } else if (psiElement instanceof XmlText) {
                            ((XmlText)psiElement).setValue(finalResolvedValue);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                            case 1: 
                            case 2: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 2;
                                break;
                            }
                            case 1: 
                            case 2: {
                                n2 = 3;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "descriptor";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getFamilyName";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "applyFix";
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                            case 1: 
                            case 2: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }
            if ((xmlTag = domValue.getXmlTag()) != null && (textElements = xmlTag.getValue().getTextElements()).length > 0) {
                problems.add(manager.createProblemDescriptor((PsiElement)textElements[0], MavenDomBundle.message("inspection.property.in.parent.description", new Object[0]), fix, ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
            }
        }
    }

    @Nullable
    private static String resolveXmlElement(@Nullable XmlElement xmlElement) {
        if (xmlElement == null) {
            return null;
        }
        MavenPropertyPsiReference psiReference = (MavenPropertyPsiReference)ContainerUtil.findInstance((Object[])xmlElement.getReferences(), MavenPropertyPsiReference.class);
        if (psiReference == null) {
            return null;
        }
        PsiElement resolvedElement = psiReference.resolve();
        if (!(resolvedElement instanceof MavenPsiElementWrapper)) {
            return null;
        }
        PsiElement xmlTag = ((MavenPsiElementWrapper)resolvedElement).getWrappee();
        if (!(xmlTag instanceof XmlTag)) {
            return null;
        }
        return ((XmlTag)xmlTag).getValue().getTrimmedText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

