/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenImportingSettingsQuickFix;
import org.jetbrains.idea.maven.buildtool.quickfix.OpenMavenRunnerSettingsQuickFix;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenJvmConfigOpenQuickFix;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.MavenRunConfigurationOpenQuickFix;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/MavenJvmConfigBuildIssue;", "", "()V", "VM_INIT_ERROR", "", "getImportIssue", "Lcom/intellij/build/issue/BuildIssue;", "title", "errorMessage", "project", "Lcom/intellij/openapi/project/Project;", "getRunnerIssue", "runConfiguration", "Lorg/jetbrains/idea/maven/execution/MavenRunConfiguration;", "intellij.maven"})
public final class MavenJvmConfigBuildIssue {
    @NotNull
    public static final String VM_INIT_ERROR = "Error occurred during initialization of VM";
    @NotNull
    public static final MavenJvmConfigBuildIssue INSTANCE;

    @NotNull
    public final BuildIssue getRunnerIssue(@NotNull String title, @NotNull String errorMessage, @NotNull Project project2, @NotNull MavenRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        MavenRunnerParameters mavenRunnerParameters = runConfiguration.getRunnerParameters();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"runConfiguration.runnerParameters");
        VirtualFile jvmConfig = MavenExternalParameters.getJvmConfig(mavenRunnerParameters.getWorkingDirPath());
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        List<VirtualFile> list = mavenProjectsManager.getProjectsFiles();
        Intrinsics.checkNotNullExpressionValue(list, (String)"MavenProjectsManager.get\u2026ce(project).projectsFiles");
        MavenProject mavenProject2 = (MavenProject)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<VirtualFile, Boolean>(runConfiguration){
            final /* synthetic */ MavenRunConfiguration $runConfiguration;

            public final boolean invoke(VirtualFile it) {
                MavenRunnerParameters mavenRunnerParameters = this.$runConfiguration.getRunnerParameters();
                Intrinsics.checkNotNullExpressionValue((Object)mavenRunnerParameters, (String)"runConfiguration.runnerParameters");
                Path path = Paths.get(mavenRunnerParameters.getWorkingDirPath(), new String[0]);
                Path path2 = it.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it.toNioPath()");
                return ((Object)path).equals(path2.getParent());
            }
            {
                this.$runConfiguration = mavenRunConfiguration;
                super(1);
            }
        })), (Function1)((Function1)new Function1<VirtualFile, MavenProject>(project2){
            final /* synthetic */ Project $project;

            @Nullable
            public final MavenProject invoke(VirtualFile it) {
                return MavenProjectsManager.getInstance(this.$project).findProject(it);
            }
            {
                this.$project = project2;
                super(1);
            }
        })));
        boolean bl = false;
        List quickFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.header.possible.solution", new Object[0]));
        issueDescription.append("\n");
        OpenMavenRunnerSettingsQuickFix openMavenRunnerSettingsQuickFix = new OpenMavenRunnerSettingsQuickFix(MavenConfigurableBundle.message("maven.settings.runner.vm.options", new Object[0]));
        quickFixes.add(openMavenRunnerSettingsQuickFix);
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.runner.settings", openMavenRunnerSettingsQuickFix.getId()));
        issueDescription.append("\n");
        MavenRunConfiguration mavenRunConfiguration = runConfiguration;
        boolean bl2 = false;
        boolean bl3 = false;
        MavenRunConfiguration it = mavenRunConfiguration;
        boolean bl4 = false;
        RunManagerImpl runManagerImpl = RunManagerImpl.Companion.getInstanceImpl(project2);
        MavenRunConfigurationType mavenRunConfigurationType = MavenRunConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mavenRunConfigurationType, (String)"MavenRunConfigurationType.getInstance()");
        ConfigurationType configurationType = mavenRunConfigurationType;
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
        RunnerAndConfigurationSettings configurationById = runManagerImpl.findConfigurationByTypeAndName(configurationType, string);
        if (configurationById != null && configurationById.getConfiguration() instanceof MavenRunConfiguration) {
            RunConfiguration runConfiguration2 = configurationById.getConfiguration();
            if (runConfiguration2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.idea.maven.execution.MavenRunConfiguration");
            }
            MavenRunConfiguration configuration = (MavenRunConfiguration)runConfiguration2;
            MavenRunnerSettings mavenRunnerSettings = configuration.getRunnerSettings();
            CharSequence charSequence = mavenRunnerSettings != null ? mavenRunnerSettings.getVmOptions() : null;
            bl3 = false;
            boolean bl5 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                MavenRunConfigurationOpenQuickFix mavenRunConfigurationOpenQuickFix = new MavenRunConfigurationOpenQuickFix(configurationById);
                quickFixes.add(mavenRunConfigurationOpenQuickFix);
                issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.run.configuration", mavenRunConfigurationOpenQuickFix.getId()));
                issueDescription.append("\n");
            }
        }
        if (jvmConfig != null) {
            MavenJvmConfigOpenQuickFix mavenJvmConfigOpenQuickFix = new MavenJvmConfigOpenQuickFix(jvmConfig);
            quickFixes.add(mavenJvmConfigOpenQuickFix);
            Object[] objectArray = new Object[2];
            Object object = mavenProject2;
            if (object == null || (object = ((MavenProject)object).getDisplayName()) == null) {
                object = "";
            }
            objectArray[0] = object;
            objectArray[1] = mavenJvmConfigOpenQuickFix.getId();
            issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.config.file", objectArray));
        }
        return new BuildIssue(title, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $title;
            final /* synthetic */ StringBuilder $issueDescription;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$title = $captured_local_variable$0;
                this.$issueDescription = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                String string = $captured_local_variable$1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    @NotNull
    public final BuildIssue getImportIssue(@NotNull String title, @NotNull String errorMessage, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean bl = false;
        List quickFixes = new ArrayList();
        StringBuilder issueDescription = new StringBuilder(errorMessage);
        issueDescription.append("\n\n");
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.header.possible.solution", new Object[0]));
        issueDescription.append("\n");
        OpenMavenImportingSettingsQuickFix openMavenImportingSettingsQuickFix = new OpenMavenImportingSettingsQuickFix(MavenConfigurableBundle.message("maven.settings.importing.vm.options", new Object[0]));
        quickFixes.add(openMavenImportingSettingsQuickFix);
        issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.import.settings", openMavenImportingSettingsQuickFix.getId()));
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        List<MavenProject> list = mavenProjectsManager.getRootProjects();
        Intrinsics.checkNotNullExpressionValue(list, (String)"MavenProjectsManager.get\u2026nce(project).rootProjects");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenProject it = (MavenProject)element$iv;
            boolean bl2 = false;
            MavenProject mavenProject2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"it");
            VirtualFile virtualFile = mavenProject2.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it.file");
            String string = virtualFile.getPath();
            boolean bl3 = false;
            boolean bl4 = false;
            String it2 = string;
            boolean bl5 = false;
            string = MavenDistributionsCache.getInstance(project2).getMultimoduleDirectory(it2);
            bl3 = false;
            bl4 = false;
            it2 = string;
            boolean bl6 = false;
            VirtualFile jvmConfig = MavenExternalParameters.getJvmConfig(it2);
            if (jvmConfig == null) continue;
            MavenJvmConfigOpenQuickFix mavenJvmConfigOpenQuickFix = new MavenJvmConfigOpenQuickFix(jvmConfig);
            quickFixes.add(mavenJvmConfigOpenQuickFix);
            issueDescription.append("\n");
            issueDescription.append(MavenProjectBundle.message("maven.quickfix.jvm.options.config.file", it.getDisplayName(), mavenJvmConfigOpenQuickFix.getId()));
        }
        return new BuildIssue(title, issueDescription, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final List<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $title;
            final /* synthetic */ StringBuilder $issueDescription;
            final /* synthetic */ List $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public List<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                return null;
            }
            {
                this.$title = $captured_local_variable$0;
                this.$issueDescription = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                String string = $captured_local_variable$1.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issueDescription.toString()");
                this.description = string;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    private MavenJvmConfigBuildIssue() {
    }

    static {
        MavenJvmConfigBuildIssue mavenJvmConfigBuildIssue;
        INSTANCE = mavenJvmConfigBuildIssue = new MavenJvmConfigBuildIssue();
    }
}

