/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.configurers;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsConfiguration;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenIdeaPluginConfigurer
extends MavenModuleConfigurer {
    @Override
    public void configure(@NotNull MavenProject mavenProject2, @NotNull Project project2, @NotNull Module module) {
        String reformatCodeBeforeCommit;
        String performCodeAnalisisBeforeCommit;
        String optimizeImportsBeforeCommit;
        String hideEmptyPackages;
        String autoscrollFromSource;
        String autoscrollToSource;
        String assertNotNull;
        String downloadJavadocs;
        Element cfg;
        if (mavenProject2 == null) {
            MavenIdeaPluginConfigurer.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            MavenIdeaPluginConfigurer.$$$reportNull$$$0(1);
        }
        if (module == null) {
            MavenIdeaPluginConfigurer.$$$reportNull$$$0(2);
        }
        if ((cfg = mavenProject2.getPluginConfiguration("com.googlecode", "maven-idea-plugin")) == null) {
            return;
        }
        MavenIdeaPluginConfigurer.configureJdk(cfg, module);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        String downloadSources = cfg.getChildTextTrim("downloadSources");
        if (!StringUtil.isEmptyOrSpaces((String)downloadSources)) {
            projectsManager.getImportingSettings().setDownloadSourcesAutomatically(Boolean.parseBoolean(downloadSources));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(downloadJavadocs = cfg.getChildTextTrim("downloadJavadocs")))) {
            projectsManager.getImportingSettings().setDownloadDocsAutomatically(Boolean.parseBoolean(downloadJavadocs));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(assertNotNull = cfg.getChildTextTrim("assertNotNull")))) {
            CompilerConfiguration.getInstance((Project)project2).setAddNotNullAssertions(Boolean.parseBoolean(assertNotNull));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(autoscrollToSource = cfg.getChildTextTrim("autoscrollToSource")))) {
            ((ProjectViewImpl)ProjectView.getInstance((Project)project2)).setAutoscrollToSource(Boolean.parseBoolean(autoscrollToSource), "ProjectPane");
        }
        if (!StringUtil.isEmptyOrSpaces((String)(autoscrollFromSource = cfg.getChildTextTrim("autoscrollFromSource")))) {
            ((ProjectViewImpl)ProjectView.getInstance((Project)project2)).setAutoscrollFromSource(Boolean.parseBoolean(autoscrollFromSource), "ProjectPane");
        }
        if (!StringUtil.isEmptyOrSpaces((String)(hideEmptyPackages = cfg.getChildTextTrim("hideEmptyPackages")))) {
            ProjectView.getInstance((Project)project2).setHideEmptyPackages("ProjectPane", Boolean.parseBoolean(hideEmptyPackages));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(optimizeImportsBeforeCommit = cfg.getChildTextTrim("optimizeImportsBeforeCommit")))) {
            VcsConfiguration.getInstance((Project)module.getProject()).OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = Boolean.parseBoolean(optimizeImportsBeforeCommit);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(performCodeAnalisisBeforeCommit = cfg.getChildTextTrim("performCodeAnalisisBeforeCommit")))) {
            VcsConfiguration.getInstance((Project)module.getProject()).CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = Boolean.parseBoolean(performCodeAnalisisBeforeCommit);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(reformatCodeBeforeCommit = cfg.getChildTextTrim("reformatCodeBeforeCommit")))) {
            VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)module.getProject());
            vcsConfiguration.REFORMAT_BEFORE_PROJECT_COMMIT = Boolean.parseBoolean(reformatCodeBeforeCommit);
        }
    }

    private static void configureJdk(Element cfg, @NotNull Module module) {
        String jdkName;
        if (module == null) {
            MavenIdeaPluginConfigurer.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)(jdkName = cfg.getChildTextTrim("jdkName")))) {
            return;
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        String currentSdkName = null;
        Sdk sdk = rootManager.getSdk();
        if (sdk != null) {
            currentSdkName = sdk.getName();
        }
        if (!jdkName.equals(currentSdkName)) {
            ModifiableRootModel model2 = rootManager.getModifiableModel();
            if (jdkName.equals(ProjectRootManager.getInstance((Project)model2.getProject()).getProjectSdkName())) {
                model2.inheritSdk();
            } else {
                Sdk jdk2 = ProjectJdkTable.getInstance().findJdk(jdkName);
                if (jdk2 != null) {
                    model2.setSdk(jdk2);
                } else {
                    model2.setInvalidSdk(jdkName, JavaSdk.getInstance().getName());
                }
            }
            WriteAction.run(() -> model2.commit());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/configurers/MavenIdeaPluginConfigurer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "configureJdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

