/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.actions;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="mavenExecuteGoalHistory", storages={@Storage(value="$WORKSPACE_FILE$")})
@Service(value={Service.Level.PROJECT})
public final class ExecuteMavenGoalHistoryService
implements PersistentStateComponent<String[]> {
    private static final int MAX_HISTORY_LENGTH = 20;
    private final LinkedList<String> myHistory = new LinkedList();
    private String myWorkDirectory = "";
    private String myCanceledCommand;

    public static ExecuteMavenGoalHistoryService getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ExecuteMavenGoalHistoryService.$$$reportNull$$$0(0);
        }
        return (ExecuteMavenGoalHistoryService)project2.getService(ExecuteMavenGoalHistoryService.class);
    }

    @Nullable
    public String getCanceledCommand() {
        return this.myCanceledCommand;
    }

    public void setCanceledCommand(@Nullable String canceledCommand) {
        this.myCanceledCommand = canceledCommand;
    }

    public void addCommand(@NotNull String command, @NotNull String projectPath) {
        if (command == null) {
            ExecuteMavenGoalHistoryService.$$$reportNull$$$0(1);
        }
        if (projectPath == null) {
            ExecuteMavenGoalHistoryService.$$$reportNull$$$0(2);
        }
        this.myWorkDirectory = projectPath.trim();
        if ((command = command.trim()).length() == 0) {
            return;
        }
        this.myHistory.remove(command);
        this.myHistory.addFirst(command);
        while (this.myHistory.size() > 20) {
            this.myHistory.removeLast();
        }
    }

    public List<String> getHistory() {
        return new ArrayList<String>(this.myHistory);
    }

    @NotNull
    public String getWorkDirectory() {
        String string = this.myWorkDirectory;
        if (string == null) {
            ExecuteMavenGoalHistoryService.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String @Nullable [] getState() {
        String[] res = new String[this.myHistory.size() + 1];
        res[0] = this.myWorkDirectory;
        int i = 1;
        for (String goal : this.myHistory) {
            res[i++] = goal;
        }
        return res;
    }

    public void loadState(String @NotNull [] state2) {
        if (state2 == null) {
            ExecuteMavenGoalHistoryService.$$$reportNull$$$0(4);
        }
        if (state2.length == 0) {
            this.myWorkDirectory = "";
            this.myHistory.clear();
        } else {
            this.myWorkDirectory = state2[0];
            this.myHistory.addAll(Arrays.asList(state2).subList(1, state2.length));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/navigator/actions/ExecuteMavenGoalHistoryService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/navigator/actions/ExecuteMavenGoalHistoryService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCommand";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

