/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.StatisticsNotificationManager;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogMigration;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.connection.StatisticsService;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.uploader.EventLogExternalUploader;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@InternalIgnoreDependencyViolation
final class StatisticsJobsScheduler
implements ApplicationInitializedListener {
    private static final int SEND_STATISTICS_INITIAL_DELAY_IN_MILLIS = 300000;
    private static final int CHECK_STATISTICS_PROVIDERS_DELAY_IN_MIN = 1;
    private static final int CHECK_EXTERNAL_UPLOADER_DELAY_IN_MIN = 3;

    StatisticsJobsScheduler() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
    }

    public void componentsInitialized() {
        StatisticsNotificationManager notificationManager = (StatisticsNotificationManager)ApplicationManager.getApplication().getService(StatisticsNotificationManager.class);
        if (notificationManager != null) {
            notificationManager.showNotificationIfNeeded();
        }
        StatisticsJobsScheduler.checkPreviousExternalUploadResult();
        StatisticsJobsScheduler.runEventLogStatisticsService();
        StatisticsJobsScheduler.runValidationRulesUpdate();
        StatisticsEventLogMigration.performMigration();
    }

    private static void runValidationRulesUpdate() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLogProviderUtil.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider2 : providers) {
                if (!provider2.isRecordEnabled()) continue;
                IntellijSensitiveDataValidator.getInstance(provider2.getRecorderId()).update();
            }
        }, 3L, 180L, TimeUnit.MINUTES);
    }

    private static void checkPreviousExternalUploadResult() {
        JobScheduler.getScheduler().schedule(() -> {
            StatisticsEventLoggerProvider config = FeatureUsageLogger.INSTANCE.getConfig();
            if (config.isRecordEnabled()) {
                EventLogExternalUploader.INSTANCE.logPreviousExternalUploadResult(config.getRecorderId());
            }
        }, 3L, TimeUnit.MINUTES);
    }

    private static void runEventLogStatisticsService() {
        JobScheduler.getScheduler().schedule(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLogProviderUtil.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider2 : providers) {
                if (!provider2.isSendEnabled()) continue;
                StatisticsService statisticsService = StatisticsUploadAssistant.getEventLogStatisticsService(provider2.getRecorderId());
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(statisticsService, provider2.getSendFrequencyMs());
            }
        }, 1L, TimeUnit.MINUTES);
    }

    private static void runStatisticsServiceWithDelay(@NotNull StatisticsService statisticsService, long delayInMs) {
        if (statisticsService == null) {
            StatisticsJobsScheduler.$$$reportNull$$$0(0);
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(statisticsService::send, 300000L, delayInMs, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statisticsService", "com/intellij/internal/statistic/updater/StatisticsJobsScheduler", "runStatisticsServiceWithDelay"));
    }
}

