/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageClassesEnumerator;
import com.intellij.coverage.JavaCoverageEngineExtension;
import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaCoverageClassesAnnotator
extends JavaCoverageClassesEnumerator {
    private final PackageAnnotator.Annotator myAnnotator;
    private final ProjectData myProjectData;
    private Map<String, PackageAnnotator.AtomicPackageCoverageInfo> myFlattenPackages;
    private Map<VirtualFile, PackageAnnotator.AtomicPackageCoverageInfo> myFlattenDirectories;
    private ExecutorService myExecutor;
    private final PackageAnnotator myPackageAnnotator;

    public JavaCoverageClassesAnnotator(@NotNull CoverageSuitesBundle suite, @NotNull Project project, @NotNull PackageAnnotator.Annotator annotator) {
        if (suite == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(1);
        }
        if (annotator == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(2);
        }
        this(suite, project, annotator, 0);
    }

    public JavaCoverageClassesAnnotator(@NotNull CoverageSuitesBundle suite, @NotNull Project project, @NotNull PackageAnnotator.Annotator annotator, int totalRoots) {
        if (suite == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(4);
        }
        if (annotator == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(5);
        }
        super(suite, project, totalRoots);
        this.myAnnotator = annotator;
        this.myProjectData = this.mySuite.getCoverageData();
        JavaCoverageOptionsProvider optionsProvider = JavaCoverageOptionsProvider.getInstance(this.myProject);
        this.myPackageAnnotator = new PackageAnnotator(suite, project, this.myProjectData, this, optionsProvider.ignoreEmptyPrivateConstructors(), optionsProvider.ignoreImplicitConstructors());
    }

    @Override
    public void visitRootPackage(PsiPackage psiPackage) {
        if (this.myProjectData == null) {
            return;
        }
        this.myFlattenPackages = new ConcurrentHashMap<String, PackageAnnotator.AtomicPackageCoverageInfo>();
        super.visitRootPackage(psiPackage);
        HashMap<String, PackageAnnotator.PackageCoverageInfo> packages = new HashMap<String, PackageAnnotator.PackageCoverageInfo>();
        for (Map.Entry<String, PackageAnnotator.AtomicPackageCoverageInfo> entry : this.myFlattenPackages.entrySet()) {
            String packageFQName = entry.getKey().replace('/', '.');
            PackageAnnotator.PackageCoverageInfo info = entry.getValue().toPackageCoverageInfo();
            this.myAnnotator.annotatePackage(packageFQName, info, true);
            while (true) {
                packages.computeIfAbsent(packageFQName, k -> new PackageAnnotator.PackageCoverageInfo()).append(info);
                int index = packageFQName.lastIndexOf(46);
                if (index < 0) break;
                packageFQName = packageFQName.substring(0, index);
            }
            packages.computeIfAbsent("", k -> new PackageAnnotator.PackageCoverageInfo()).append(info);
        }
        this.myFlattenPackages = null;
        for (Map.Entry<String, PackageAnnotator.AtomicPackageCoverageInfo> entry : packages.entrySet()) {
            this.myAnnotator.annotatePackage(entry.getKey(), (PackageAnnotator.PackageCoverageInfo)((Object)entry.getValue()));
        }
    }

    @Override
    protected void visitSource(PsiPackage psiPackage, Module module, GlobalSearchScope scope, String rootPackageVMName, boolean isTestSource, Set<VirtualFile> productionRootsSet) {
        this.myFlattenDirectories = new ConcurrentHashMap<VirtualFile, PackageAnnotator.AtomicPackageCoverageInfo>();
        super.visitSource(psiPackage, module, scope, rootPackageVMName, isTestSource, productionRootsSet);
        List sourceRoots = ContainerUtil.filter((Object[])JavaCoverageClassesAnnotator.prepareRoots(module, rootPackageVMName, isTestSource), Objects::nonNull);
        HashMap<VirtualFile, PackageAnnotator.DirCoverageInfo> directories = new HashMap<VirtualFile, PackageAnnotator.DirCoverageInfo>();
        block0: for (Map.Entry<VirtualFile, PackageAnnotator.AtomicPackageCoverageInfo> entry : this.myFlattenDirectories.entrySet()) {
            PackageAnnotator.PackageCoverageInfo info = entry.getValue().toPackageCoverageInfo();
            for (VirtualFile dir = entry.getKey(); dir != null; dir = dir.getParent()) {
                directories.computeIfAbsent(dir, PackageAnnotator.DirCoverageInfo::new).append(info);
                if (sourceRoots.contains(dir)) continue block0;
            }
        }
        this.myFlattenDirectories = null;
        for (PackageAnnotator.DirCoverageInfo dir : directories.values()) {
            if (isTestSource) {
                this.myAnnotator.annotateTestDirectory(dir.sourceRoot, dir, module);
                continue;
            }
            this.myAnnotator.annotateSourceDirectory(dir.sourceRoot, dir, module);
        }
    }

    @Override
    protected void visitRoot(File packageOutputRoot, String rootPackageVMName, GlobalSearchScope scope) {
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Coverage Loading", (int)JavaCoverageClassesAnnotator.getWorkingThreads());
        super.visitRoot(packageOutputRoot, rootPackageVMName, scope);
        this.myExecutor.shutdown();
        try {
            this.myExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myExecutor = null;
        }
    }

    @Override
    protected void visitClassFiles(String toplevelClassSrcFQName, List<File> files, String packageVMName, GlobalSearchScope scope) {
        if (files.isEmpty()) {
            return;
        }
        for (File file : files) {
            if (!JavaCoverageClassesAnnotator.ignoreClass(this.mySuite, file, toplevelClassSrcFQName)) continue;
            return;
        }
        this.myExecutor.execute(() -> this.myPackageAnnotator.visitFiles(toplevelClassSrcFQName, files, packageVMName, scope));
    }

    @Override
    protected void visitClass(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        PackageAnnotator.ClassCoverageInfo info = this.myPackageAnnotator.visitClass(psiClass);
        if (info != null && info.totalClassCount > 0) {
            this.myAnnotator.annotateClass(qualifiedName, info);
        }
    }

    public void annotateClass(String toplevelClassSrcFQName, PackageAnnotator.ClassCoverageInfo info, String packageVMName, VirtualFile directory) {
        this.myAnnotator.annotateClass(toplevelClassSrcFQName, info);
        this.getOrCreateFlattenPackage(packageVMName).append(info);
        if (directory != null) {
            this.getOrCreateFlattenDirectory(directory).append(info);
        }
    }

    private PackageAnnotator.AtomicPackageCoverageInfo getOrCreateFlattenPackage(@NotNull String packageName) {
        if (packageName == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(6);
        }
        return this.myFlattenPackages.computeIfAbsent(packageName, k -> new PackageAnnotator.AtomicPackageCoverageInfo());
    }

    private PackageAnnotator.AtomicPackageCoverageInfo getOrCreateFlattenDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            JavaCoverageClassesAnnotator.$$$reportNull$$$0(7);
        }
        return this.myFlattenDirectories.computeIfAbsent(file, k -> new PackageAnnotator.AtomicPackageCoverageInfo());
    }

    private static boolean ignoreClass(CoverageSuitesBundle bundle, File child, String toplevelClassSrcFQName) {
        for (JavaCoverageEngineExtension javaCoverageEngineExtension : (JavaCoverageEngineExtension[])JavaCoverageEngineExtension.EP_NAME.getExtensions()) {
            if (!javaCoverageEngineExtension.ignoreCoverageForClass(bundle, child)) continue;
            return true;
        }
        for (JavaCoverageEngineExtension javaCoverageEngineExtension : bundle.getSuites()) {
            if (!(javaCoverageEngineExtension instanceof JavaCoverageSuite) || !((JavaCoverageSuite)((Object)javaCoverageEngineExtension)).isClassFiltered(toplevelClassSrcFQName, ((JavaCoverageSuite)((Object)javaCoverageEngineExtension)).getExcludedClassNames())) continue;
            return true;
        }
        return false;
    }

    private static VirtualFile[] prepareRoots(Module module, String rootPackageVMName, boolean isTestHierarchy) {
        ContentEntry[] contentEntries;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (ContentEntry contentEntry : contentEntries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (SourceFolder folder : contentEntry.getSourceFolders((JpsModuleSourceRootType)(isTestHierarchy ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE))) {
                VirtualFile file = folder.getFile();
                if (file == null) continue;
                String prefix = folder.getPackagePrefix().replace('.', '/');
                VirtualFile relativeSrcRoot = file.findFileByRelativePath(StringUtil.trimStart((String)rootPackageVMName, (String)prefix));
                result.add(relativeSrcRoot);
            }
        }
        return result.toArray(VirtualFile.EMPTY_ARRAY);
    }

    private static int getWorkingThreads() {
        int threads = Registry.intValue((String)"idea.coverage.loading.threads");
        int maxThreads = Runtime.getRuntime().availableProcessors() - 1;
        if (threads == 0) {
            threads = maxThreads;
        }
        threads = Math.min(threads, maxThreads);
        threads = Math.max(threads, 1);
        return threads;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/JavaCoverageClassesAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateFlattenPackage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateFlattenDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

