/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.JavaCoverageSuite;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class JavaCoverageClassesEnumerator {
    protected final CoverageSuitesBundle mySuite;
    protected final Project myProject;
    protected final CoverageDataManager myCoverageManager;
    private final boolean[] myShouldVisitTestSource;
    private final int myRootsCount;
    private int myCurrentRootsCount;

    public JavaCoverageClassesEnumerator(@NotNull CoverageSuitesBundle suite, @NotNull Project project, int totalRoots) {
        boolean[] blArray;
        if (suite == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(1);
        }
        this.mySuite = suite;
        this.myProject = project;
        this.myCoverageManager = CoverageDataManager.getInstance((Project)this.myProject);
        if (this.mySuite.isTrackTestFolders()) {
            boolean[] blArray2 = new boolean[2];
            blArray2[0] = false;
            blArray = blArray2;
            blArray2[1] = true;
        } else {
            boolean[] blArray3 = new boolean[1];
            blArray = blArray3;
            blArray3[0] = false;
        }
        this.myShouldVisitTestSource = blArray;
        this.myRootsCount = totalRoots;
    }

    protected void visitClass(PsiClass psiClass) {
    }

    protected void visitClassFiles(String topLevelClassName, List<File> files, String packageVMName, GlobalSearchScope scope) {
    }

    public void visitSuite() {
        this.myCurrentRootsCount = 0;
        this.updateProgress();
        ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        for (CoverageSuite coverageSuite : this.mySuite.getSuites()) {
            JavaCoverageSuite javaSuite = (JavaCoverageSuite)coverageSuite;
            classes.addAll(javaSuite.getCurrentSuiteClasses(this.myProject));
            packages.addAll(javaSuite.getCurrentSuitePackages(this.myProject));
        }
        if (packages.isEmpty() && classes.isEmpty()) {
            return;
        }
        for (PsiPackage psiPackage : packages) {
            ProgressIndicatorProvider.checkCanceled();
            this.visitRootPackage(psiPackage);
        }
        for (PsiClass psiClass : classes) {
            ProgressIndicatorProvider.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> {
                String packageName = ((PsiClassOwner)psiClass.getContainingFile()).getPackageName();
                PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
                if (psiPackage == null) {
                    return;
                }
                this.visitClass(psiClass);
            });
        }
    }

    public void visitRootPackage(PsiPackage psiPackage) {
        ProjectData data = this.mySuite.getCoverageData();
        if (data == null) {
            return;
        }
        if (!this.isPackageFiltered(psiPackage)) {
            return;
        }
        GlobalSearchScope scope = this.mySuite.getSearchScope(this.myProject);
        Module[] modules = (Module[])this.myCoverageManager.doInReadActionIfProjectOpen(() -> ModuleManager.getInstance((Project)this.myProject).getModules());
        if (modules == null) {
            return;
        }
        String qualifiedName = psiPackage.getQualifiedName();
        String rootPackageVMName = qualifiedName.replace('.', '/');
        for (Module module : modules) {
            if (!scope.isSearchInModuleContent(module)) continue;
            ProgressIndicatorProvider.checkCanceled();
            HashSet<VirtualFile> productionRootsSet = new HashSet<VirtualFile>();
            for (boolean isTestSource : this.myShouldVisitTestSource) {
                this.visitSource(psiPackage, module, scope, rootPackageVMName, isTestSource, productionRootsSet);
            }
        }
    }

    protected void visitSource(PsiPackage psiPackage, Module module, GlobalSearchScope scope, String rootPackageVMName, boolean isTestSource, Set<VirtualFile> productionRootsSet) {
        VirtualFile[] roots = JavaCoverageClassesEnumerator.getRoots(this.myCoverageManager, module, isTestSource);
        if (roots == null) {
            return;
        }
        for (VirtualFile output : roots) {
            if (!isTestSource) {
                productionRootsSet.add(output);
            } else if (productionRootsSet.contains(output)) continue;
            File outputRoot = PackageAnnotator.findRelativeFile(rootPackageVMName, output);
            if (!outputRoot.exists()) continue;
            this.visitRoot(outputRoot, rootPackageVMName, scope);
        }
    }

    protected void visitRoot(File packageOutputRoot, String rootPackageVMName, GlobalSearchScope scope) {
        Stack stack = new Stack((Object[])new PackageData[]{new PackageData(rootPackageVMName, packageOutputRoot.listFiles())});
        while (!stack.isEmpty()) {
            ProgressIndicatorProvider.checkCanceled();
            PackageData packageData = (PackageData)stack.pop();
            String packageVMName = packageData.packageVMName;
            File[] children = packageData.children;
            if (children == null) continue;
            HashMap<String, List> topLevelClasses = new HashMap<String, List>();
            for (File child : children) {
                if (PackageAnnotator.isClassFile(child)) {
                    String childName = PackageAnnotator.getClassName(child);
                    String classFqVMName = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
                    String toplevelClassSrcFQName = PackageAnnotator.getSourceToplevelFQName(classFqVMName);
                    topLevelClasses.computeIfAbsent(toplevelClassSrcFQName, k -> new ArrayList()).add(child);
                    continue;
                }
                if (!child.isDirectory()) continue;
                String childPackageVMName = JavaCoverageClassesEnumerator.getChildVMName(packageVMName, child);
                stack.push((Object)new PackageData(childPackageVMName, child.listFiles()));
            }
            for (Map.Entry entry : topLevelClasses.entrySet()) {
                this.visitClassFiles((String)entry.getKey(), (List)entry.getValue(), packageVMName, scope);
            }
        }
        ++this.myCurrentRootsCount;
        this.updateProgress();
    }

    private void updateProgress() {
        if (this.myRootsCount <= 1) {
            return;
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator == null) {
            return;
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.setFraction((double)this.myCurrentRootsCount / (double)this.myRootsCount);
    }

    @NotNull
    protected static String getChildVMName(@NotNull String packageVMName, @NotNull File child) {
        if (packageVMName == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(2);
        }
        if (child == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(3);
        }
        String childName = child.getName();
        Object object = packageVMName.length() > 0 ? packageVMName + "/" + childName : childName;
        if (object == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(4);
        }
        return object;
    }

    private boolean isPackageFiltered(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            JavaCoverageClassesEnumerator.$$$reportNull$$$0(5);
        }
        String qualifiedName = psiPackage.getQualifiedName();
        for (CoverageSuite coverageSuite : this.mySuite.getSuites()) {
            if (!(coverageSuite instanceof JavaCoverageSuite) || !((JavaCoverageSuite)coverageSuite).isPackageFiltered(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public static VirtualFile[] getRoots(CoverageDataManager manager, Module module, boolean isTestSource) {
        return (VirtualFile[])manager.doInReadActionIfProjectOpen(() -> {
            OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules();
            if (isTestSource) {
                enumerator = enumerator.productionOnly();
            }
            return enumerator.classes().getRoots();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageVMName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/JavaCoverageClassesEnumerator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/JavaCoverageClassesEnumerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildVMName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildVMName";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPackageFiltered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RootsCounter
    extends JavaCoverageClassesEnumerator {
        private int myRoots;

        public RootsCounter(@NotNull CoverageSuitesBundle suite, @NotNull Project project) {
            if (suite == null) {
                RootsCounter.$$$reportNull$$$0(0);
            }
            if (project == null) {
                RootsCounter.$$$reportNull$$$0(1);
            }
            super(suite, project, 0);
            this.visitSuite();
        }

        @Override
        protected void visitRoot(File packageOutputRoot, String rootPackageVMName, GlobalSearchScope scope) {
            ++this.myRoots;
        }

        public int getRoots() {
            return this.myRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "suite";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/coverage/JavaCoverageClassesEnumerator$RootsCounter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PackageData {
        private final String packageVMName;
        private final File[] children;

        private PackageData(String packageVMName, File[] children) {
            this.packageVMName = packageVMName;
            this.children = children;
        }
    }
}

