/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl;

import com.android.tools.idea.gradle.dsl.GradleDslBuildScriptUtil;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class GradleUtil {
    public static final String GRADLE_PATH_SEPARATOR = ":";
    public static final String FN_GRADLE_PROPERTIES = "gradle.properties";

    @Nullable
    public static VirtualFile getGradleSettingsFile(@NotNull File dirPath) {
        File gradleSettingsFilePath;
        VirtualFile result;
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(0);
        }
        return (result = VfsUtil.findFileByIoFile((File)(gradleSettingsFilePath = GradleDslBuildScriptUtil.findGradleSettingsFile(dirPath)), (boolean)false)) != null && result.isValid() ? result : null;
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull File dirPath) {
        File gradleBuildFilePath;
        VirtualFile result;
        if (dirPath == null) {
            GradleUtil.$$$reportNull$$$0(1);
        }
        return (result = VfsUtil.findFileByIoFile((File)(gradleBuildFilePath = GradleDslBuildScriptUtil.findGradleBuildFile(dirPath)), (boolean)false)) != null && result.isValid() ? result : null;
    }

    @NotNull
    public static File getBaseDirPath(@NotNull Project project) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(2);
        }
        if (project.isDefault()) {
            return new File("");
        }
        return new File(Objects.requireNonNull(FileUtil.toCanonicalPath((String)project.getBasePath())));
    }

    @Nullable
    public static VirtualFile getGradleBuildFile(@NotNull Module module) {
        File moduleRoot;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(3);
        }
        return (moduleRoot = GradleUtil.findModuleRootFolderPath(module)) != null ? GradleUtil.getGradleBuildFile(moduleRoot) : null;
    }

    @Nullable
    private static File findModuleRootFolderPath(@NotNull Module module) {
        String path;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(4);
        }
        if ((path = GradleUtil.getModuleDirPath(module)) == null) {
            return null;
        }
        return new File(PathUtil.toSystemDependentName((String)path));
    }

    @Nullable
    public static @SystemIndependent String getModuleDirPath(@NotNull Module module) {
        String linkedProjectPath;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(5);
        }
        if (!Strings.isNullOrEmpty((String)(linkedProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module)))) {
            return linkedProjectPath;
        }
        @SystemIndependent String moduleFilePath = module.getModuleFilePath();
        return VfsUtil.getParentDir((String)moduleFilePath);
    }

    @NotNull
    public static List<String> getPathSegments(@NotNull String gradlePath) {
        if (gradlePath == null) {
            GradleUtil.$$$reportNull$$$0(6);
        }
        List list = Splitter.on((String)GRADLE_PATH_SEPARATOR).omitEmptyStrings().splitToList((CharSequence)gradlePath);
        if (list == null) {
            GradleUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/GradleUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/GradleUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSegments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGradleSettingsFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDirPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findModuleRootFolderPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDirPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathSegments";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

