/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.InterpolatedText;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.FakeElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.kotlin.KotlinDslNameConverter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FakeArtifactElement
extends FakeElement {
    @NotNull
    private final Function<ArtifactDependencySpec, String> myGetter;
    @NotNull
    private final BiConsumer<ArtifactDependencySpecImpl, String> mySetter;
    @NotNull
    private static final Pattern WRAPPED_VARIABLE_FORM = Pattern.compile("\\$\\{(.*)}");
    @NotNull
    private static final Pattern UNWRAPPED_VARIABLE_FORM = Pattern.compile("\\$(([a-zA-Z]\\w*)(\\.([a-zA-Z]\\w+))*)");

    public static boolean shouldInterpolate(@Nullable String str) {
        return str != null && (WRAPPED_VARIABLE_FORM.matcher(str).matches() || UNWRAPPED_VARIABLE_FORM.matcher(str).matches());
    }

    public FakeArtifactElement(@Nullable GradleDslElement parent, @NotNull GradleNameElement name, @NotNull GradleDslSimpleExpression originExpression, @NotNull Function<ArtifactDependencySpec, String> getFunc, @NotNull BiConsumer<ArtifactDependencySpecImpl, String> setFunc, boolean canDelete) {
        if (name == null) {
            FakeArtifactElement.$$$reportNull$$$0(0);
        }
        if (originExpression == null) {
            FakeArtifactElement.$$$reportNull$$$0(1);
        }
        if (getFunc == null) {
            FakeArtifactElement.$$$reportNull$$$0(2);
        }
        if (setFunc == null) {
            FakeArtifactElement.$$$reportNull$$$0(3);
        }
        super(parent, name, originExpression, canDelete);
        this.myGetter = getFunc;
        this.mySetter = setFunc;
    }

    @Override
    @Nullable
    public Object extractValue() {
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved);
        if (spec == null) {
            return null;
        }
        if (resolved.getDslFile().getParser().shouldInterpolate(resolved)) {
            String result = this.myGetter.apply(spec);
            return result == null ? null : GradlePropertyModel.iStr(result);
        }
        return this.myGetter.apply(spec);
    }

    @Override
    protected void consumeValue(@Nullable Object value) {
        assert (this.myCanDelete || value != null);
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved);
        if (spec == null) {
            throw new IllegalArgumentException("Could not create ArtifactDependencySpec from: " + value);
        }
        boolean shouldQuote = false;
        String strValue = null;
        if (value instanceof ReferenceTo) {
            strValue = resolved.getDslFile().getParser().convertReferenceToExternalText((GradleDslElement)resolved, ((ReferenceTo)value).getReferredElement(), true);
            shouldQuote = true;
        } else if (value instanceof InterpolatedText) {
            InterpolatedText interpolatedValue = (InterpolatedText)value;
            StringBuilder builder = new StringBuilder();
            for (InterpolatedText.InterpolatedTextItem elem : interpolatedValue.getInterpolationElements()) {
                if (elem.getTextItem() != null) {
                    builder.append(elem.getTextItem());
                }
                if (elem.getReferenceItem() == null) continue;
                String externalText = resolved.getDslFile().getParser().convertReferenceToExternalText((GradleDslElement)resolved, elem.getReferenceItem().getReferredElement(), true);
                builder.append(externalText != "" ? externalText : elem.getReferenceItem().getReferredElement().getFullName());
            }
            strValue = builder.toString();
        } else if (value instanceof RawText) {
            GradleDslWriter nameConverter = resolved.getDslFile().getWriter();
            if (nameConverter instanceof GroovyDslNameConverter) {
                strValue = ((RawText)value).getGroovyText();
            } else if (nameConverter instanceof KotlinDslNameConverter) {
                strValue = ((RawText)value).getKtsText();
            }
            if (strValue != null && FakeArtifactElement.isDoubleQuotedString(strValue)) {
                shouldQuote = true;
                strValue = StringUtil.unquoteString((String)strValue);
            }
        } else if (value != null && FakeArtifactElement.isDoubleQuotedString(strValue = (String)value)) {
            shouldQuote = true;
            strValue = StringUtil.unquoteString((String)((String)value));
        }
        this.mySetter.accept(spec, strValue);
        if (shouldQuote || resolved.getDslFile().getParser().shouldInterpolate(resolved)) {
            this.myRealExpression.setValue(GradlePropertyModel.iStr(spec.compactNotation()));
        } else {
            this.myRealExpression.setValue(spec.compactNotation());
        }
    }

    private static boolean isDoubleQuotedString(@NotNull String str) {
        if (str == null) {
            FakeArtifactElement.$$$reportNull$$$0(4);
        }
        return StringUtil.isQuotedString((String)str) && str.charAt(0) == '\"';
    }

    @Override
    @Nullable
    public Object produceRawValue() {
        return this.getUnresolvedValue();
    }

    @Override
    @NotNull
    public GradleDslSimpleExpression copy() {
        return new FakeArtifactElement(this.myParent, GradleNameElement.copy(this.myFakeName), this.myRealExpression, this.myGetter, this.mySetter, this.myCanDelete);
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        PsiElement realExpression = this.myRealExpression instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)this.myRealExpression).getCurrentElement() : this.myRealExpression.getExpression();
        if (realExpression == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                FakeArtifactElement.$$$reportNull$$$0(5);
            }
            return immutableList;
        }
        String referenceText = this.getReferenceText();
        if (referenceText == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                FakeArtifactElement.$$$reportNull$$$0(6);
            }
            return immutableList;
        }
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        GradleDslElement element = resolved.resolveExternalSyntaxReference(referenceText, true);
        ImmutableList immutableList = ImmutableList.of((Object)new GradleReferenceInjection(this, element, realExpression, referenceText));
        if (immutableList == null) {
            FakeArtifactElement.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getDependencies() {
        List<GradleReferenceInjection> list = this.getResolvedVariables();
        if (list == null) {
            FakeArtifactElement.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public boolean isReference() {
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved, false);
        if (spec == null) {
            return false;
        }
        String result = this.myGetter.apply(spec);
        return result != null && (WRAPPED_VARIABLE_FORM.matcher(result).matches() || UNWRAPPED_VARIABLE_FORM.matcher(result).matches());
    }

    @Override
    @Nullable
    public String getReferenceText() {
        GradleDslSimpleExpression resolved = PropertyUtil.resolveElement(this.myRealExpression);
        ArtifactDependencySpecImpl spec = FakeArtifactElement.getSpec(resolved, false);
        if (spec == null) {
            return null;
        }
        String result = this.myGetter.apply(spec);
        if (result == null) {
            return null;
        }
        if (result.startsWith("${")) {
            Matcher m = WRAPPED_VARIABLE_FORM.matcher(result);
            if (!m.matches() || m.groupCount() < 1) {
                return null;
            }
            return m.group(1);
        }
        Matcher m = UNWRAPPED_VARIABLE_FORM.matcher(result);
        if (!m.matches() || m.groupCount() < 1) {
            return null;
        }
        return m.group(1);
    }

    @Nullable
    private static ArtifactDependencySpecImpl getSpec(@NotNull GradleDslSimpleExpression element) {
        if (element == null) {
            FakeArtifactElement.$$$reportNull$$$0(9);
        }
        return FakeArtifactElement.getSpec(element, true);
    }

    @Nullable
    private static ArtifactDependencySpecImpl getSpec(@NotNull GradleDslSimpleExpression element, boolean useResolvedValue) {
        Object val;
        if (element == null) {
            FakeArtifactElement.$$$reportNull$$$0(10);
        }
        Object object = val = useResolvedValue ? element.getValue() : element.getUnresolvedValue();
        if (!(val instanceof String)) {
            return null;
        }
        String stringValue = (String)val;
        return ArtifactDependencySpecImpl.create(stringValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getFunc";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setFunc";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/dependencies/FakeArtifactElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/dependencies/FakeArtifactElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isDoubleQuotedString";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

