/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u0002H\f\"\u0006\b\u0000\u0010\f\u0018\u00012\u0006\u0010\r\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u000eJ3\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J-\u0010\u0019\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u001eJ*\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\f0 \"\u0004\b\u0000\u0010\f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\f0\u0010H\u0007JO\u0010\"\u001a\u0002H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\f0\u00102\u001a\u0010#\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100$\"\u0006\u0012\u0002\b\u00030\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010%J\u001a\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007J\f\u0010(\u001a\u00020\t*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiContentHelper;", "", "()V", "JSON_MIME_TYPE", "", "V3_DIFF_JSON_MIME_TYPE", "V3_HTML_JSON_MIME_TYPE", "V3_JSON_MIME_TYPE", "gqlJackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "jackson", "fromJson", "T", "string", "(Ljava/lang/String;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "gqlNaming", "", "(Ljava/lang/String;Ljava/lang/Class;Z)Ljava/lang/Object;", "getObjectMapper", "loadImage", "Ljava/awt/Image;", "stream", "Ljava/io/InputStream;", "readJson", "reader", "Ljava/io/Reader;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "(Ljava/io/Reader;Lcom/fasterxml/jackson/databind/JavaType;Z)Ljava/lang/Object;", "readJsonList", "", "parameterClass", "readJsonObject", "parameters", "", "(Ljava/io/Reader;Ljava/lang/Class;[Ljava/lang/Class;Z)Ljava/lang/Object;", "toJson", "content", "genericConfig", "intellij.vcs.github"})
public final class GithubApiContentHelper {
    @NotNull
    public static final String JSON_MIME_TYPE = "application/json";
    @NotNull
    public static final String V3_JSON_MIME_TYPE = "application/vnd.github.v3+json";
    @NotNull
    public static final String V3_HTML_JSON_MIME_TYPE = "application/vnd.github.v3.html+json";
    @NotNull
    public static final String V3_DIFF_JSON_MIME_TYPE = "application/vnd.github.v3.diff+json";
    private static final ObjectMapper jackson;
    private static final ObjectMapper gqlJackson;
    @NotNull
    public static final GithubApiContentHelper INSTANCE;

    private final ObjectMapper genericConfig(ObjectMapper $this$genericConfig) {
        ObjectMapper objectMapper = $this$genericConfig.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX")).setTimeZone(TimeZone.getDefault()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS}).setSerializationInclusion(JsonInclude.Include.NON_NULL).setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"this.setDateFormat(Simpl\u2026toDetect.Visibility.ANY))");
        return objectMapper;
    }

    public final /* synthetic */ <T> T fromJson(String string) throws GithubJsonException {
        int $i$f$fromJson = 0;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)GithubApiContentHelper.fromJson$default(string, Object.class, false, 4, null);
    }

    @JvmStatic
    public static final <T> T fromJson(@NotNull String string, @NotNull Class<T> clazz, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            return (T)INSTANCE.getObjectMapper(gqlNaming).readValue(string, clazz);
        }
        catch (JsonParseException e) {
            throw (Throwable)new GithubJsonException("Can't parse GitHub response", e);
        }
    }

    public static /* synthetic */ Object fromJson$default(String string, Class clazz, boolean bl, int n, Object object) throws GithubJsonException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return GithubApiContentHelper.fromJson(string, clazz, bl);
    }

    @JvmStatic
    public static final <T> T readJsonObject(@NotNull Reader reader, @NotNull Class<T> clazz, @NotNull Class<?>[] parameters, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        JavaType javaType = jackson.getTypeFactory().constructParametricType(clazz, (Class[])Arrays.copyOf(parameters, parameters.length));
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"jackson.typeFactory.cons\u2026cType(clazz, *parameters)");
        return INSTANCE.readJson(reader, javaType, gqlNaming);
    }

    public static /* synthetic */ Object readJsonObject$default(Reader reader, Class clazz, Class[] classArray, boolean bl, int n, Object object) throws GithubJsonException {
        if ((n & 8) != 0) {
            bl = false;
        }
        return GithubApiContentHelper.readJsonObject(reader, clazz, classArray, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> readJsonList(@NotNull Reader reader, @NotNull Class<T> parameterClass) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(parameterClass, (String)"parameterClass");
        CollectionType collectionType = jackson.getTypeFactory().constructCollectionType(List.class, parameterClass);
        Intrinsics.checkNotNullExpressionValue((Object)collectionType, (String)"jackson.typeFactory.cons\u2026ass.java, parameterClass)");
        return (List)GithubApiContentHelper.readJson$default(INSTANCE, reader, (JavaType)collectionType, false, 4, null);
    }

    private final <T> T readJson(Reader reader, JavaType type, boolean gqlNaming) throws GithubJsonException {
        try {
            if (type.isTypeOrSubTypeOf(Unit.class) || type.isTypeOrSubTypeOf(Void.class)) {
                return (T)Unit.INSTANCE;
            }
            return (T)this.getObjectMapper(gqlNaming).readValue(reader, type);
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new GithubJsonException("Can't parse GitHub response", e);
        }
    }

    static /* synthetic */ Object readJson$default(GithubApiContentHelper githubApiContentHelper, Reader reader, JavaType javaType, boolean bl, int n, Object object) throws GithubJsonException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return githubApiContentHelper.readJson(reader, javaType, bl);
    }

    @JvmStatic
    @NotNull
    public static final String toJson(@NotNull Object content2, boolean gqlNaming) throws GithubJsonException {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        try {
            String string = INSTANCE.getObjectMapper(gqlNaming).writeValueAsString(content2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getObjectMapper(gqlNamin\u2026iteValueAsString(content)");
            return string;
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new GithubJsonException("Can't serialize GitHub request body", e);
        }
    }

    public static /* synthetic */ String toJson$default(Object object, boolean bl, int n, Object object2) throws GithubJsonException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return GithubApiContentHelper.toJson(object, bl);
    }

    private final ObjectMapper getObjectMapper(boolean gqlNaming) {
        return !gqlNaming ? jackson : gqlJackson;
    }

    static /* synthetic */ ObjectMapper getObjectMapper$default(GithubApiContentHelper githubApiContentHelper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return githubApiContentHelper.getObjectMapper(bl);
    }

    @JvmStatic
    @NotNull
    public static final Image loadImage(@NotNull InputStream stream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        BufferedImage bufferedImage = ImageIO.read(stream);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageIO.read(stream)");
        return bufferedImage;
    }

    private GithubApiContentHelper() {
    }

    static {
        GithubApiContentHelper githubApiContentHelper;
        INSTANCE = githubApiContentHelper = new GithubApiContentHelper();
        ObjectMapper objectMapper = githubApiContentHelper.genericConfig(ExtensionsKt.jacksonObjectMapper()).setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"jacksonObjectMapper().ge\u2026amingStrategy.SNAKE_CASE)");
        jackson = objectMapper;
        ObjectMapper objectMapper2 = githubApiContentHelper.genericConfig(ExtensionsKt.jacksonObjectMapper()).setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"jacksonObjectMapper().ge\u2026trategy.LOWER_CAMEL_CASE)");
        gqlJackson = objectMapper2;
    }
}

