/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import git4idea.fetch.GitFetchSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHCommitHash;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommit;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHServiceUtil;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 %2\u00020\u0001:\u0001%B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ8\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00170\u0015H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J2\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00150\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J0\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00170\u00150\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J&\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0013H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "project", "Lcom/intellij/openapi/project/Project;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "gitRemote", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "ghRepository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/progress/ProgressManager;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "createChangesProvider", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProvider;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "mergeBaseOid", "", "commits", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "Lcom/google/common/graph/Graph;", "fetch", "", "refspec", "fetchBranch", "branch", "loadCommitDiffs", "baseRefOid", "oid", "loadCommitsFromApi", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "loadMergeBaseOid", "headRefOid", "Companion", "intellij.vcs.github"})
public final class GHPRChangesServiceImpl
implements GHPRChangesService {
    private final ProgressManager progressManager;
    private final Project project;
    private final GithubApiRequestExecutor requestExecutor;
    private final GitRemoteUrlCoordinates gitRemote;
    private final GHRepositoryCoordinates ghRepository;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public CompletableFuture<Unit> fetch(@NotNull ProgressIndicator progressIndicator, @NotNull String refspec) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)refspec, (String)"refspec");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, refspec){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $refspec;

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GitFetchSupport.fetchSupport((Project)GHPRChangesServiceImpl.access$getProject$p(this.this$0)).fetch(GHPRChangesServiceImpl.access$getGitRemote$p(this.this$0).getRepository(), GHPRChangesServiceImpl.access$getGitRemote$p(this.this$0).getRemote(), this.$refspec).throwExceptionIfFailed();
            }
            {
                this.this$0 = gHPRChangesServiceImpl;
                this.$refspec = string;
                super(1);
            }
        }), LOG, "Error occurred while fetching \"" + refspec + '\"');
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> fetchBranch(@NotNull ProgressIndicator progressIndicator, @NotNull String branch) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return GHServiceUtil.INSTANCE.logError(this.fetch(progressIndicator, branch), LOG, "Error occurred while fetching \"" + branch + '\"');
    }

    @Override
    @NotNull
    public CompletableFuture<Pair<GHCommit, Graph<GHCommit>>> loadCommitsFromApi(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Pair<? extends GHCommit, ? extends Graph<GHCommit>>>(this, pullRequestId){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<GHCommit, Graph<GHCommit>> invoke(@NotNull ProgressIndicator indicator) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Iterable $this$map$iv = new SimpleGHGQLPagesLoader<T>(GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0), (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHPullRequestCommit>>>(this){
                    final /* synthetic */ loadCommitsFromApi.1 this$0;

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHPullRequestCommit>> invoke(@NotNull GHGQLRequestPagination p) {
                        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                        return GHGQLRequests.PullRequest.INSTANCE.commits(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0.this$0), this.this$0.$pullRequestId.getNumber(), p);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, false, 0, 12, null).loadAll(indicator);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    GHPullRequestCommit gHPullRequestCommit = (GHPullRequestCommit)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    GHCommit gHCommit = it.getCommit();
                    collection.add(gHCommit);
                }
                List list2 = (List)destination$iv$iv;
                Companion companion = GHPRChangesServiceImpl.Companion;
                boolean bl = false;
                boolean bl2 = false;
                List p1 = list2;
                boolean bl3 = false;
                return org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$buildCommitsTree(companion, p1);
            }
            {
                this.this$0 = gHPRChangesServiceImpl;
                this.$pullRequestId = gHPRIdentifier;
                super(1);
            }
        }), LOG, "Error occurred while loading commits for PR " + pullRequestId.getNumber());
    }

    @Override
    @NotNull
    public CompletableFuture<Pair<String, String>> loadCommitDiffs(@NotNull ProgressIndicator progressIndicator, @NotNull String baseRefOid, @NotNull String oid) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)baseRefOid, (String)"baseRefOid");
        Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Pair<? extends String, ? extends String>>(this, oid, baseRefOid){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $oid;
            final /* synthetic */ String $baseRefOid;

            @NotNull
            public final Pair<String, String> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String commitDiff = GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.Commits.getDiff(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0), this.$oid));
                String cumulativeDiff = GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.Commits.getDiff(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0), this.$baseRefOid, this.$oid));
                return TuplesKt.to((Object)commitDiff, (Object)cumulativeDiff);
            }
            {
                this.this$0 = gHPRChangesServiceImpl;
                this.$oid = string;
                this.$baseRefOid = string2;
                super(1);
            }
        }), LOG, "Error occurred while loading diffs for commit " + oid);
    }

    @Override
    @NotNull
    public CompletableFuture<String> loadMergeBaseOid(@NotNull ProgressIndicator progressIndicator, @NotNull String baseRefOid, @NotNull String headRefOid) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)baseRefOid, (String)"baseRefOid");
        Intrinsics.checkNotNullParameter((Object)headRefOid, (String)"headRefOid");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, String>(this, baseRefOid, headRefOid){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ String $baseRefOid;
            final /* synthetic */ String $headRefOid;

            @NotNull
            public final String invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRChangesServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.Commits.compare(GHPRChangesServiceImpl.access$getGhRepository$p(this.this$0), this.$baseRefOid, this.$headRefOid)).getMergeBaseCommit().getSha();
            }
            {
                this.this$0 = gHPRChangesServiceImpl;
                this.$baseRefOid = string;
                this.$headRefOid = string2;
                super(1);
            }
        }), LOG, "Error occurred while calculating merge base for " + baseRefOid + " and " + headRefOid);
    }

    @Override
    @NotNull
    public CompletableFuture<GHPRChangesProvider> createChangesProvider(@NotNull ProgressIndicator progressIndicator, @NotNull String mergeBaseOid, @NotNull Pair<GHCommit, ? extends Graph<GHCommit>> commits) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)mergeBaseOid, (String)"mergeBaseOid");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPRChangesProvider>(this, commits, mergeBaseOid){
            final /* synthetic */ GHPRChangesServiceImpl this$0;
            final /* synthetic */ Pair $commits;
            final /* synthetic */ String $mergeBaseOid;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GHPRChangesProvider invoke(@NotNull ProgressIndicator it) {
                void $this$mapValuesTo$iv$iv;
                void lastCommit;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Pair pair = this.$commits;
                GHCommit gHCommit = (GHCommit)pair.component1();
                Graph graph = (Graph)pair.component2();
                boolean bl = false;
                Map commitsDiffsRequests = new LinkedHashMap<K, V>();
                Iterator<T> iterator = Traverser.forGraph((SuccessorsFunction)((SuccessorsFunction)graph)).depthFirstPostOrder((Object)lastCommit).iterator();
                while (iterator.hasNext()) {
                    GHCommit commit;
                    GHCommit gHCommit2 = commit = (GHCommit)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)gHCommit2, (String)"commit");
                    ProgressWrapper progressWrapper = ProgressWrapper.wrap((ProgressIndicator)it);
                    Intrinsics.checkNotNullExpressionValue((Object)progressWrapper, (String)"ProgressWrapper.wrap(it)");
                    commitsDiffsRequests.put(gHCommit2, this.this$0.loadCommitDiffs((ProgressIndicator)progressWrapper, this.$mergeBaseOid, commit.getOid()));
                }
                Collection<V> $this$toTypedArray$iv = commitsDiffsRequests.values();
                boolean $i$f$toTypedArray = false;
                Collection<V> thisCollection$iv = $this$toTypedArray$iv;
                CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
                if (completableFutureArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.allOf(\u2026ts.values.toTypedArray())");
                org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$joinCancellable(GHPRChangesServiceImpl.Companion, completableFuture);
                Map $this$mapValues$iv = commitsDiffsRequests;
                boolean $i$f$mapValues = false;
                Map map2 = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void $dstr$_u24__u24$request;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl2 = false;
                    K k = it$iv$iv.getKey();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    K k2 = k;
                    Map map4 = map3;
                    boolean bl3 = false;
                    void var21_26 = $dstr$_u24__u24$request;
                    boolean bl4 = false;
                    CompletableFuture request = (CompletableFuture)var21_26.getValue();
                    Pair diffs = (Pair)org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$joinCancellable(GHPRChangesServiceImpl.Companion, request);
                    List commitPatches = org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$readAllPatches(GHPRChangesServiceImpl.Companion, (String)diffs.getFirst());
                    List cumulativePatches = org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesServiceImpl$Companion.access$readAllPatches(GHPRChangesServiceImpl.Companion, (String)diffs.getSecond());
                    Pair pair2 = TuplesKt.to((Object)commitPatches, (Object)cumulativePatches);
                    map4.put(k2, pair2);
                }
                Map patchesByCommits = destination$iv$iv;
                it.checkCanceled();
                return new GHPRChangesProviderImpl(GHPRChangesServiceImpl.access$getGitRemote$p(this.this$0).getRepository(), this.$mergeBaseOid, (Graph<GHCommit>)graph, (GHCommit)lastCommit, patchesByCommits);
            }
            {
                this.this$0 = gHPRChangesServiceImpl;
                this.$commits = pair;
                this.$mergeBaseOid = string;
                super(1);
            }
        }), LOG, "Error occurred while building changes from commits");
    }

    public GHPRChangesServiceImpl(@NotNull ProgressManager progressManager, @NotNull Project project, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRemoteUrlCoordinates gitRemote, @NotNull GHRepositoryCoordinates ghRepository) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)gitRemote, (String)"gitRemote");
        Intrinsics.checkNotNullParameter((Object)ghRepository, (String)"ghRepository");
        this.progressManager = progressManager;
        this.project = project;
        this.requestExecutor = requestExecutor;
        this.gitRemote = gitRemote;
        this.ghRepository = ghRepository;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRChangesService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRChangesServiceImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ GitRemoteUrlCoordinates access$getGitRemote$p(GHPRChangesServiceImpl $this) {
        return $this.gitRemote;
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRChangesServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHRepositoryCoordinates access$getGhRepository$p(GHPRChangesServiceImpl $this) {
        return $this.ghRepository;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001d\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildCommitsTree", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "Lcom/google/common/graph/Graph;", "commits", "", "readAllPatches", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "diffFile", "", "joinCancellable", "T", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "intellij.vcs.github"})
    public static final class Companion {
        private final <T> T joinCancellable(CompletableFuture<T> $this$joinCancellable) throws ProcessCanceledException {
            try {
                return $this$joinCancellable.join();
            }
            catch (CancellationException e) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            catch (CompletionException e) {
                if (CompletableFutureUtil.INSTANCE.isCancellation((Throwable)e)) {
                    throw (Throwable)new ProcessCanceledException((Throwable)e);
                }
                throw CompletableFutureUtil.INSTANCE.extractError((Throwable)e);
            }
        }

        private final List<FilePatch> readAllPatches(String diffFile) {
            PatchReader reader = new PatchReader((CharSequence)diffFile, true);
            reader.parseAllPatches();
            List list2 = reader.getAllPatches();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"reader.allPatches");
            return list2;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<GHCommit, Graph<GHCommit>> buildCommitsTree(List<GHCommit> commits) {
            void $this$apply;
            Object v0;
            ImmutableGraph.Builder builder;
            boolean bl;
            boolean bl2;
            Object object;
            Map commitsBySha;
            block3: {
                boolean bl3 = false;
                commitsBySha = new LinkedHashMap();
                boolean bl4 = false;
                Set parentCommits = new LinkedHashSet();
                for (GHCommit commit : commits) {
                    commitsBySha.put(commit.getOid(), commit);
                    parentCommits.addAll((Collection)commit.getParents());
                }
                object = commits;
                bl2 = false;
                Object object2 = object;
                bl = false;
                builder = object2.listIterator(object2.size());
                while (builder.hasPrevious()) {
                    Object e = builder.previous();
                    GHCommit it = (GHCommit)e;
                    boolean bl5 = false;
                    if (!(!parentCommits.contains(it))) continue;
                    v0 = e;
                    break block3;
                }
                v0 = null;
            }
            GHCommit gHCommit = v0;
            if (gHCommit == null) {
                object = "Could not determine last commit";
                bl2 = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            GHCommit lastCommit = gHCommit;
            Function2<ImmutableGraph.Builder<GHCommit>, GHCommit, Unit> $fun$addCommits$1 = new Function2<ImmutableGraph.Builder<GHCommit>, GHCommit, Unit>(commitsBySha){
                final /* synthetic */ Map $commitsBySha;

                public final void invoke(@NotNull ImmutableGraph.Builder<GHCommit> $this$addCommits, @NotNull GHCommit commit) {
                    Intrinsics.checkNotNullParameter($this$addCommits, (String)"$this$addCommits");
                    Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
                    $this$addCommits.addNode((Object)commit);
                    for (GHCommitHash parent : commit.getParents()) {
                        GHCommit parentCommit = (GHCommit)this.$commitsBySha.get(parent.getOid());
                        if (parentCommit == null) continue;
                        $this$addCommits.putEdge((Object)commit, (Object)parentCommit);
                        this.invoke($this$addCommits, parentCommit);
                    }
                }
                {
                    this.$commitsBySha = map2;
                    super(2);
                }
            };
            ImmutableGraph.Builder builder2 = GraphBuilder.directed().allowsSelfLoops(false).immutable();
            boolean bl6 = false;
            bl = false;
            builder = builder2;
            GHCommit gHCommit2 = lastCommit;
            boolean bl7 = false;
            $fun$addCommits$1.invoke((ImmutableGraph.Builder<GHCommit>)$this$apply, lastCommit);
            Unit unit = Unit.INSTANCE;
            return TuplesKt.to((Object)gHCommit2, (Object)builder2.build());
        }

        private Companion() {
        }

        public static final /* synthetic */ Pair access$buildCommitsTree(Companion $this, List commits) {
            return $this.buildCommitsTree(commits);
        }

        public static final /* synthetic */ Object access$joinCancellable(Companion $this, CompletableFuture $this$access_u24joinCancellable) {
            return $this.joinCancellable($this$access_u24joinCancellable);
        }

        public static final /* synthetic */ List access$readAllPatches(Companion $this, String diffFile) {
            return $this.readAllPatches(diffFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

