/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.BloomFilterBase;
import com.intellij.util.containers.IntObjectHashMap;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.Loader;
import com.intellij.util.lang.java6.fastutil.StrippedIntOpenHashSet;
import com.intellij.util.lang.java6.fastutil.StrippedLongOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathCache {
    static final int NUMBER_OF_ACCESSES_FOR_LAZY_CACHING = 1000;
    private static final IntObjectHashMap.ArrayProducer<Object[]> OBJECT_ARRAY_PRODUCER = new IntObjectHashMap.ArrayProducer<Object[]>(){

        public Object[] produce(int s) {
            return s == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[s];
        }
    };
    private final IntObjectHashMap<Object> myResourcePackagesCache = new IntObjectHashMap(OBJECT_ARRAY_PRODUCER);
    private final IntObjectHashMap<Object> myClassPackagesCache = new IntObjectHashMap(OBJECT_ARRAY_PRODUCER);
    private static final double PROBABILITY = 0.005;
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyLoaderData(@NotNull LoaderData loaderData, @NotNull Loader loader) {
        if (loaderData == null) {
            ClasspathCache.$$$reportNull$$$0(0);
        }
        if (loader == null) {
            ClasspathCache.$$$reportNull$$$0(1);
        }
        this.myLock.writeLock().lock();
        try {
            for (int resourcePackageHash : loaderData.myResourcePackageHashes) {
                ClasspathCache.addResourceEntry(resourcePackageHash, this.myResourcePackagesCache, loader);
            }
            for (int classPackageHash : loaderData.myClassPackageHashes) {
                ClasspathCache.addResourceEntry(classPackageHash, this.myClassPackagesCache, loader);
            }
            loader.applyData(loaderData);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <R, T1, T2> R iterateLoaders(@NotNull String resourcePath, @NotNull LoaderIterator<R, T1, T2> iterator, @NotNull T1 parameter, @NotNull T2 parameter2, @NotNull String shortName) {
        Loader[] loaders;
        Object o;
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            ClasspathCache.$$$reportNull$$$0(3);
        }
        if (parameter == null) {
            ClasspathCache.$$$reportNull$$$0(4);
        }
        if (parameter2 == null) {
            ClasspathCache.$$$reportNull$$$0(5);
        }
        if (shortName == null) {
            ClasspathCache.$$$reportNull$$$0(6);
        }
        this.myLock.readLock().lock();
        try {
            IntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
            o = map.get(ClasspathCache.getPackageNameHash(resourcePath));
        }
        finally {
            this.myLock.readLock().unlock();
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Loader) {
            return iterator.process((Loader)o, parameter, parameter2, shortName);
        }
        for (Loader l : loaders = (Loader[])o) {
            R result = iterator.process(l, parameter, parameter2, shortName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static int getPackageNameHash(@NotNull String resourcePath) {
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(7);
        }
        int index = resourcePath.lastIndexOf(47);
        int h = 0;
        for (int off = 0; off < index; ++off) {
            h = 31 * h + resourcePath.charAt(off);
        }
        return h;
    }

    private static void addResourceEntry(int hash, @NotNull IntObjectHashMap map, @NotNull Loader loader) {
        Object o;
        if (map == null) {
            ClasspathCache.$$$reportNull$$$0(8);
        }
        if (loader == null) {
            ClasspathCache.$$$reportNull$$$0(9);
        }
        if ((o = map.get(hash)) == null) {
            map.put(hash, (Object)loader);
        } else if (o instanceof Loader) {
            if (ClassPath.recordLoadingInfo) assert (loader != o);
            map.put(hash, (Object)new Loader[]{(Loader)o, loader});
        } else {
            Object[] loadersArray = (Loader[])o;
            if (ClassPath.recordLoadingInfo) assert (ArrayUtilRt.indexOf((Object[])loadersArray, (Object)loader, (int)0, (int)loadersArray.length) == -1);
            Loader[] newArray = Arrays.copyOf(loadersArray, loadersArray.length + 1);
            newArray[loadersArray.length] = loader;
            map.put(hash, (Object)newArray);
        }
    }

    @NotNull
    static String transformName(@NotNull String name) {
        int nameEnd;
        if (name == null) {
            ClasspathCache.$$$reportNull$$$0(10);
        }
        if ((name = name.substring(name.lastIndexOf(47, (nameEnd = !name.isEmpty() && name.charAt(name.length() - 1) == '/' ? name.length() - 1 : name.length()) - 1) + 1, nameEnd)).endsWith(".class")) {
            String name1 = name;
            int $ = name1.indexOf(36);
            if ($ != -1) {
                name1 = name1.substring(0, $);
            } else {
                int index = name1.lastIndexOf(46);
                if (index >= 0) {
                    name1 = name1.substring(0, index);
                }
            }
            name = name1;
        }
        String string = name;
        if (string == null) {
            ClasspathCache.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderData";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/java6/ClasspathCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/java6/ClasspathCache";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "transformName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyLoaderData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateLoaders";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameHash";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addResourceEntry";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "transformName";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class NameFilter
    extends BloomFilterBase {
        private static final int SEED = 31;

        NameFilter(int _maxElementCount, double probability) {
            super(_maxElementCount, probability);
        }

        NameFilter(@NotNull DataInput input) throws IOException {
            if (input == null) {
                NameFilter.$$$reportNull$$$0(0);
            }
            super(input);
        }

        private void addNameFingerprint(long nameFingerprint) {
            int hash = (int)(nameFingerprint >> 32);
            int hash2 = (int)nameFingerprint;
            this.addIt(hash, hash2);
        }

        boolean maybeContains(@NotNull String name) {
            if (name == null) {
                NameFilter.$$$reportNull$$$0(1);
            }
            int hash = name.hashCode();
            int hash2 = StringHash.murmur((CharSequence)name, (int)31);
            return this.maybeContains(hash, hash2);
        }

        protected void save(@NotNull DataOutput output) throws IOException {
            if (output == null) {
                NameFilter.$$$reportNull$$$0(2);
            }
            super.save(output);
        }

        private static long toNameFingerprint(@NotNull String name) {
            if (name == null) {
                NameFilter.$$$reportNull$$$0(3);
            }
            int hash = name.hashCode();
            int hash2 = StringHash.murmur((CharSequence)name, (int)31);
            return (long)hash << 32 | (long)hash2 & 0xFFFFFFFFL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/lang/java6/ClasspathCache$NameFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "maybeContains";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toNameFingerprint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class LoaderIterator<R, T1, T2> {
        LoaderIterator() {
        }

        @Nullable
        abstract R process(@NotNull Loader var1, @NotNull T1 var2, @NotNull T2 var3, @NotNull String var4);
    }

    static final class LoaderDataBuilder {
        private final StrippedLongOpenHashSet myUsedNameFingerprints = new StrippedLongOpenHashSet();
        private final StrippedIntOpenHashSet myResourcePackageHashes = new StrippedIntOpenHashSet();
        private final StrippedIntOpenHashSet myClassPackageHashes = new StrippedIntOpenHashSet();

        LoaderDataBuilder() {
        }

        void addPossiblyDuplicateNameEntry(@NotNull String name) {
            if (name == null) {
                LoaderDataBuilder.$$$reportNull$$$0(0);
            }
            name = ClasspathCache.transformName(name);
            this.myUsedNameFingerprints.add(NameFilter.toNameFingerprint(name));
        }

        void addResourcePackageFromName(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(1);
            }
            this.myResourcePackageHashes.add(ClasspathCache.getPackageNameHash(path));
        }

        void addClassPackageFromName(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(2);
            }
            this.myClassPackageHashes.add(ClasspathCache.getPackageNameHash(path));
        }

        @NotNull
        LoaderData build() {
            int uniques = this.myUsedNameFingerprints.size();
            if (uniques > 20000) {
                uniques += (int)((double)uniques * 0.03);
            }
            NameFilter nameFilter = new NameFilter(uniques, 0.005);
            StrippedLongOpenHashSet.SetIterator iterator = this.myUsedNameFingerprints.iterator();
            while (iterator.hasNext()) {
                nameFilter.addNameFingerprint(iterator.nextLong());
            }
            return new LoaderData(this.myResourcePackageHashes.toArray(), this.myClassPackageHashes.toArray(), nameFilter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/lang/java6/ClasspathCache$LoaderDataBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPossiblyDuplicateNameEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addResourcePackageFromName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addClassPackageFromName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LoaderData {
        private final int[] myResourcePackageHashes;
        private final int[] myClassPackageHashes;
        private final NameFilter myNameFilter;

        LoaderData(@NotNull int[] resourcePackageHashes, @NotNull int[] classPackageHashes, @NotNull NameFilter nameFilter) {
            if (resourcePackageHashes == null) {
                LoaderData.$$$reportNull$$$0(0);
            }
            if (classPackageHashes == null) {
                LoaderData.$$$reportNull$$$0(1);
            }
            if (nameFilter == null) {
                LoaderData.$$$reportNull$$$0(2);
            }
            this.myResourcePackageHashes = resourcePackageHashes;
            this.myClassPackageHashes = classPackageHashes;
            this.myNameFilter = nameFilter;
        }

        LoaderData(@NotNull DataInput dataInput) throws IOException {
            if (dataInput == null) {
                LoaderData.$$$reportNull$$$0(3);
            }
            this(LoaderData.readIntList(dataInput), LoaderData.readIntList(dataInput), new NameFilter(dataInput));
        }

        @NotNull
        private static int[] readIntList(@NotNull DataInput reader) throws IOException {
            if (reader == null) {
                LoaderData.$$$reportNull$$$0(4);
            }
            int numberOfElements = DataInputOutputUtilRt.readINT((DataInput)reader);
            int[] ints = new int[numberOfElements];
            for (int i = 0; i < numberOfElements; ++i) {
                ints[i] = DataInputOutputUtilRt.readINT((DataInput)reader);
            }
            if (ints == null) {
                LoaderData.$$$reportNull$$$0(5);
            }
            return ints;
        }

        void save(@NotNull DataOutput dataOutput) throws IOException {
            if (dataOutput == null) {
                LoaderData.$$$reportNull$$$0(6);
            }
            LoaderData.writeIntArray(dataOutput, this.myResourcePackageHashes);
            LoaderData.writeIntArray(dataOutput, this.myClassPackageHashes);
            this.myNameFilter.save(dataOutput);
        }

        private static void writeIntArray(@NotNull DataOutput writer, @NotNull int[] hashes) throws IOException {
            if (writer == null) {
                LoaderData.$$$reportNull$$$0(7);
            }
            if (hashes == null) {
                LoaderData.$$$reportNull$$$0(8);
            }
            DataInputOutputUtilRt.writeINT((DataOutput)writer, (int)hashes.length);
            for (int hash : hashes) {
                DataInputOutputUtilRt.writeINT((DataOutput)writer, (int)hash);
            }
        }

        @NotNull
        NameFilter getNameFilter() {
            NameFilter nameFilter = this.myNameFilter;
            if (nameFilter == null) {
                LoaderData.$$$reportNull$$$0(9);
            }
            return nameFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resourcePackageHashes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPackageHashes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameFilter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataInput";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/java6/ClasspathCache$LoaderData";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataOutput";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/java6/ClasspathCache$LoaderData";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readIntList";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readIntList";
                    break;
                }
                case 5: 
                case 9: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "writeIntArray";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

