/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.ClasspathCache;
import com.intellij.util.lang.java6.Loader;
import com.intellij.util.lang.java6.Resource;
import com.intellij.util.lang.java6.fastutil.StrippedIntOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JarLoader
extends Loader {
    private static final List<Map.Entry<Resource.Attribute, Attributes.Name>> PACKAGE_FIELDS = Arrays.asList(new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR));
    private static final String NULL_STRING = "<null>";
    private final String myFilePath;
    private final ClassPath myConfiguration;
    private final URL myUrl;
    private volatile SoftReference<ZipFile> myZipFileSoftReference;
    private volatile Map<Resource.Attribute, String> myAttributes;
    private volatile String myClassPathManifestAttribute;
    private final AtomicInteger myNumberOfRequests;
    private volatile StrippedIntOpenHashSet myPackageHashesInside;
    private static final Object ourLock = new Object();

    JarLoader(@NotNull URL url, @NotNull String filePath, @NotNull ClassPath configuration) throws IOException {
        if (url == null) {
            JarLoader.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            JarLoader.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            JarLoader.$$$reportNull$$$0(2);
        }
        super(new URL("jar", "", -1, url + "!/"));
        this.myNumberOfRequests = new AtomicInteger();
        this.myFilePath = filePath;
        this.myConfiguration = configuration;
        this.myUrl = url;
        if (!configuration.myLazyClassloadingCaches) {
            ZipFile zipFile = this.getZipFile();
            this.releaseZipFile(zipFile);
        }
    }

    @Nullable
    String getClassPathManifestAttribute() {
        this.loadManifestAttributes();
        String manifestAttribute = this.myClassPathManifestAttribute;
        return manifestAttribute != NULL_STRING ? manifestAttribute : null;
    }

    @Nullable
    private static Map<Resource.Attribute, String> getAttributes(@Nullable Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        EnumMap<Resource.Attribute, String> map = null;
        for (Map.Entry<Resource.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
            String value = attributes.getValue(p.getValue());
            if (value == null) continue;
            if (map == null) {
                map = new EnumMap<Resource.Attribute, String>(Resource.Attribute.class);
            }
            map.put(p.getKey(), value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifestAttributes() {
        if (this.myClassPathManifestAttribute != null) {
            return;
        }
        JarLoader jarLoader = this;
        synchronized (jarLoader) {
            try {
                if (this.myClassPathManifestAttribute != null) {
                    return;
                }
                ZipFile zipFile = this.getZipFile();
                try {
                    Attributes manifestAttributes = this.myConfiguration.getManifestData(this.myUrl);
                    if (manifestAttributes == null) {
                        ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                        if (entry != null) {
                            manifestAttributes = JarLoader.loadManifestAttributes(zipFile.getInputStream(entry));
                        }
                        if (manifestAttributes == null) {
                            manifestAttributes = new Attributes(0);
                        }
                        this.myConfiguration.cacheManifestData(this.myUrl, manifestAttributes);
                    }
                    this.myAttributes = JarLoader.getAttributes(manifestAttributes);
                    Object attribute = manifestAttributes.get(Attributes.Name.CLASS_PATH);
                    this.myClassPathManifestAttribute = attribute instanceof String ? (String)attribute : NULL_STRING;
                }
                finally {
                    this.releaseZipFile(zipFile);
                }
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }

    @Nullable
    private static Attributes loadManifestAttributes(InputStream stream) {
        Attributes attributes;
        try {
            attributes = new Manifest(stream).getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        stream.close();
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        ZipFile zipFile = this.getZipFile();
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(".class")) {
                loaderDataBuilder.addClassPackageFromName(name);
            } else {
                loaderDataBuilder.addResourcePackageFromName(name);
            }
            loaderDataBuilder.addPossiblyDuplicateNameEntry(name);
        }
        ClasspathCache.LoaderData loaderData = loaderDataBuilder.build();
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            JarLoader.$$$reportNull$$$0(3);
        }
        return loaderData2;
        finally {
            this.releaseZipFile(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private StrippedIntOpenHashSet buildPackageHashes() {
        ZipFile zipFile = this.getZipFile();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        StrippedIntOpenHashSet result = new StrippedIntOpenHashSet();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            result.add(ClasspathCache.getPackageNameHash(entry.getName()));
        }
        result.add(0);
        StrippedIntOpenHashSet strippedIntOpenHashSet = result;
        this.releaseZipFile(zipFile);
        StrippedIntOpenHashSet strippedIntOpenHashSet2 = strippedIntOpenHashSet;
        if (strippedIntOpenHashSet2 == null) {
            JarLoader.$$$reportNull$$$0(4);
        }
        return strippedIntOpenHashSet2;
        {
            catch (Throwable throwable) {
                try {
                    this.releaseZipFile(zipFile);
                    throw throwable;
                }
                catch (Exception e) {
                    this.error("url: " + this.myFilePath, e);
                    return new StrippedIntOpenHashSet(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(@NotNull String name) {
        if (name == null) {
            JarLoader.$$$reportNull$$$0(5);
        }
        if (this.myConfiguration.myLazyClassloadingCaches) {
            int numberOfHits = this.myNumberOfRequests.incrementAndGet();
            StrippedIntOpenHashSet packagesInside = this.myPackageHashesInside;
            if (numberOfHits > 1000 && packagesInside == null) {
                this.myPackageHashesInside = packagesInside = this.buildPackageHashes();
            }
            if (packagesInside != null && !packagesInside.contains(ClasspathCache.getPackageNameHash(name))) {
                return null;
            }
        }
        try {
            ZipFile zipFile = this.getZipFile();
            try {
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) return null;
                Resource resource = this.instantiateResource(this.getBaseURL(), entry);
                return resource;
            }
            finally {
                this.releaseZipFile(zipFile);
            }
        }
        catch (Exception e) {
            this.error("url: " + this.myFilePath, e);
        }
        return null;
    }

    @NotNull
    protected Resource instantiateResource(@NotNull URL url, @NotNull ZipEntry entry) throws IOException {
        if (url == null) {
            JarLoader.$$$reportNull$$$0(6);
        }
        if (entry == null) {
            JarLoader.$$$reportNull$$$0(7);
        }
        return new MyResource(url, entry);
    }

    protected void error(@NotNull String message, @NotNull Throwable t) {
        if (message == null) {
            JarLoader.$$$reportNull$$$0(8);
        }
        if (t == null) {
            JarLoader.$$$reportNull$$$0(9);
        }
        if (this.myConfiguration.myLogErrorOnMissingJar) {
            LoggerRt.getInstance(JarLoader.class).error(message, t);
        } else {
            LoggerRt.getInstance(JarLoader.class).warn(message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected ZipFile getZipFile() throws IOException {
        ZipFile zipFile;
        if (!this.myConfiguration.myCanLockJars) {
            ZipFile zipFile2 = this.createZipFile(this.myFilePath);
            if (zipFile2 != null) return zipFile2;
            JarLoader.$$$reportNull$$$0(13);
            return zipFile2;
        }
        SoftReference<ZipFile> ref = this.myZipFileSoftReference;
        ZipFile zipFile3 = zipFile = ref == null ? null : ref.get();
        if (zipFile != null) {
            ZipFile zipFile4 = zipFile;
            if (zipFile4 != null) return zipFile4;
            JarLoader.$$$reportNull$$$0(10);
            return zipFile4;
        }
        Object object = ourLock;
        // MONITORENTER : object
        ref = this.myZipFileSoftReference;
        ZipFile zipFile5 = zipFile = ref == null ? null : ref.get();
        if (zipFile != null) {
            ZipFile zipFile6 = zipFile;
            // MONITOREXIT : object
            if (zipFile6 != null) return zipFile6;
            JarLoader.$$$reportNull$$$0(11);
            return zipFile6;
        }
        zipFile = this.createZipFile(this.myFilePath);
        this.myZipFileSoftReference = new SoftReference<ZipFile>(zipFile);
        ZipFile zipFile7 = zipFile;
        // MONITOREXIT : object
        if (zipFile7 != null) return zipFile7;
        JarLoader.$$$reportNull$$$0(12);
        return zipFile7;
    }

    @NotNull
    protected ZipFile createZipFile(@NotNull String path) throws IOException {
        if (path == null) {
            JarLoader.$$$reportNull$$$0(14);
        }
        return new ZipFile(path);
    }

    protected void releaseZipFile(@NotNull ZipFile zipFile) throws IOException {
        if (zipFile == null) {
            JarLoader.$$$reportNull$$$0(15);
        }
        if (!this.myConfiguration.myCanLockJars) {
            zipFile.close();
        }
    }

    public String toString() {
        return "JarLoader [" + this.myFilePath + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/java6/JarLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/java6/JarLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPackageHashes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instantiateResource";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createZipFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "releaseZipFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyResource
    extends Resource {
        protected final URL myUrl;
        protected final ZipEntry myEntry;

        MyResource(@NotNull URL url, ZipEntry entry) throws IOException {
            if (url == null) {
                MyResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                MyResource.$$$reportNull$$$0(1);
            }
            this.myUrl = new URL(url, entry.getName());
            this.myEntry = entry;
        }

        @Override
        @NotNull
        public URL getURL() {
            URL uRL = this.myUrl;
            if (uRL == null) {
                MyResource.$$$reportNull$$$0(2);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public byte[] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            ZipFile file;
            block4: {
                file = JarLoader.this.getZipFile();
                stream = null;
                stream = file.getInputStream(this.myEntry);
                byArray = FileUtilRt.loadBytes((InputStream)stream, (int)((int)this.myEntry.getSize()));
                if (byArray != null) break block4;
                MyResource.$$$reportNull$$$0(3);
            }
            return byArray;
            finally {
                if (stream != null) {
                    stream.close();
                }
                JarLoader.this.releaseZipFile(file);
            }
        }

        @Override
        public String getValue(@NotNull Resource.Attribute key) {
            if (key == null) {
                MyResource.$$$reportNull$$$0(4);
            }
            JarLoader.this.loadManifestAttributes();
            return JarLoader.this.myAttributes != null ? (String)JarLoader.this.myAttributes.get((Object)key) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/java6/JarLoader$MyResource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/java6/JarLoader$MyResource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

