/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.fileType;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.sh.parser.ShShebangParserUtil;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service
public final class ShShebangFileTypeDetector
implements DocumentListener,
Disposable {
    private static final Set<@NlsSafe String> KNOWN_SHELLS = Set.of("sh", "zsh", "bash");

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            ShShebangFileTypeDetector.$$$reportNull$$$0(0);
        }
        Document document = event.getDocument();
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile instanceof LightVirtualFile) {
            return;
        }
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
        if (project == null) {
            return;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (!(psiFile instanceof PsiPlainTextFile)) {
            return;
        }
        TextRange textRange = TextRange.create((int)document.getLineStartOffset(0), (int)document.getLineEndOffset(0));
        String firstLine = document.getText(textRange);
        String interpreter = ShShebangParserUtil.detectInterpreter(firstLine);
        if (interpreter != null && KNOWN_SHELLS.contains(interpreter)) {
            psiDocumentManager.performLaterWhenAllCommitted(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                FileTypeManager.getInstance().removeAssociation((FileType)FileTypes.PLAIN_TEXT, (FileNameMatcher)new ExactFileNameMatcher(psiFile.getName()));
                FileDocumentManager.getInstance().saveDocument(document);
            }));
        }
    }

    public void subscribe() {
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this, (Disposable)this);
    }

    public void dispose() {
        EditorFactory.getInstance().getEventMulticaster().removeDocumentListener((DocumentListener)this);
    }

    public static ShShebangFileTypeDetector getInstance(Project project) {
        return (ShShebangFileTypeDetector)project.getService(ShShebangFileTypeDetector.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sh/fileType/ShShebangFileTypeDetector", "documentChanged"));
    }
}

