/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.PairProcessor;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.ObjectObjectMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public class ObjectObjectPersistentMultiMaplet<K, V>
extends ObjectObjectMultiMaplet<K, V> {
    private static final Collection<?> NULL_COLLECTION = Collections.emptySet();
    private static final int CACHE_SIZE = 128;
    private final PersistentHashMap<K, Collection<V>> myMap;
    private final DataExternalizer<V> myValueExternalizer;
    private final SLRUCache<K, Collection<V>> myCache;

    public ObjectObjectPersistentMultiMaplet(File file, KeyDescriptor<K> keyExternalizer, DataExternalizer<V> valueExternalizer, Supplier<? extends Collection<V>> collectionFactory) throws IOException {
        this.myValueExternalizer = valueExternalizer;
        this.myMap = new PersistentHashMap(file, keyExternalizer, new CollectionDataExternalizer<V>(valueExternalizer, collectionFactory));
        this.myCache = new SLRUCache<K, Collection<V>>(128, 384, (EqualityPolicy)keyExternalizer){

            @NotNull
            public Collection<V> createValue(K key) {
                Collection collection;
                try {
                    Collection collection2 = (Collection)ObjectObjectPersistentMultiMaplet.this.myMap.get(key);
                    collection = collection2 == null ? NULL_COLLECTION : collection2;
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ObjectObjectPersistentMultiMaplet$1", "createValue"));
            }
        };
    }

    @Override
    public boolean containsKey(K key) {
        try {
            return this.myMap.containsMapping(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public Collection<V> get(K key) {
        Collection collection = (Collection)this.myCache.get(key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(K key, Collection<V> value) {
        try {
            this.myCache.remove(key);
            if (value == null || value.isEmpty()) {
                this.myMap.remove(key);
            } else {
                this.myMap.put(key, value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(K key, final Collection<V> value) {
        try {
            this.myCache.remove(key);
            this.myMap.appendData(key, new AppendablePersistentMap.ValueDataAppender(){

                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    for (Object v : value) {
                        ObjectObjectPersistentMultiMaplet.this.myValueExternalizer.save(out, v);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/ObjectObjectPersistentMultiMaplet$2", "append"));
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(K key, V value) {
        this.put(key, (V)Collections.singleton(value));
    }

    @Override
    public void removeAll(K key, Collection<V> values) {
        try {
            Collection collection = (Collection)this.myCache.get(key);
            if (collection != NULL_COLLECTION && collection.removeAll(values)) {
                this.myCache.remove(key);
                if (collection.isEmpty()) {
                    this.myMap.remove(key);
                } else {
                    this.myMap.put(key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(K key, V value) {
        try {
            Collection collection = (Collection)this.myCache.get(key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.myCache.remove(key);
                if (collection.isEmpty()) {
                    this.myMap.remove(key);
                } else {
                    this.myMap.put(key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(K key) {
        try {
            this.myCache.remove(key);
            this.myMap.remove(key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry((key, value) -> {
            this.put((K)key, (V)value);
            return true;
        });
    }

    @Override
    public void replaceAll(ObjectObjectMultiMaplet<K, V> m) {
        m.forEachEntry((key, value) -> {
            this.replace((K)key, (Collection<V>)value);
            return true;
        });
    }

    @Override
    public void close() {
        try {
            this.myCache.clear();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.myMap.isDirty()) {
                this.myMap.dropMemoryCaches();
            }
        } else {
            this.myMap.force();
        }
    }

    @Override
    void forEachEntry(@NotNull PairProcessor<? super K, ? super Collection<V>> procedure) {
        if (procedure == null) {
            ObjectObjectPersistentMultiMaplet.$$$reportNull$$$0(0);
        }
        try {
            this.myMap.processKeysWithExistingMapping(key -> {
                try {
                    return procedure.process(key, this.myMap.get(key));
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "org/jetbrains/jps/builders/java/dependencyView/ObjectObjectPersistentMultiMaplet", "forEachEntry"));
    }

    private static class CollectionDataExternalizer<V>
    implements DataExternalizer<Collection<V>> {
        private final DataExternalizer<V> myElementExternalizer;
        private final Supplier<? extends Collection<V>> myCollectionFactory;

        CollectionDataExternalizer(DataExternalizer<V> elementExternalizer, Supplier<? extends Collection<V>> collectionFactory) {
            this.myElementExternalizer = elementExternalizer;
            this.myCollectionFactory = collectionFactory;
        }

        public void save(@NotNull DataOutput out, Collection<V> value) throws IOException {
            if (out == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(0);
            }
            for (V x : value) {
                this.myElementExternalizer.save(out, x);
            }
        }

        public Collection<V> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                CollectionDataExternalizer.$$$reportNull$$$0(1);
            }
            Collection<V> result = this.myCollectionFactory.get();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(this.myElementExternalizer.read(in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/ObjectObjectPersistentMultiMaplet$CollectionDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

