/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefJSQuery;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.intellij.datavis.r.VisualizationBundle;
import org.intellij.datavis.r.inlays.MouseWheelUtils;
import org.intellij.datavis.r.inlays.components.GithubMarkdownCss;
import org.intellij.datavis.r.inlays.components.InlayOutput;
import org.intellij.datavis.r.inlays.components.InlayOutputHtml;
import org.intellij.datavis.r.inlays.components.InlayOutputHtml$1$$special$;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/intellij/datavis/r/inlays/components/InlayOutputHtml;", "Lorg/intellij/datavis/r/inlays/components/InlayOutput;", "parent", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "clearAction", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "height", "", "heightJsCallback", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "kotlin.jvm.PlatformType", "jbBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "saveJsCallback", "acceptType", "", "type", "", "addData", "data", "clear", "getCollapsedDescription", "notifySize", "saveAs", "scrollToTop", "intellij.notebooks.visualization"})
public final class InlayOutputHtml
extends InlayOutput {
    private final JBCefBrowser jbBrowser;
    private final JBCefJSQuery heightJsCallback;
    private final JBCefJSQuery saveJsCallback;
    private int height;

    @Override
    public boolean acceptType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return Intrinsics.areEqual((Object)type, (Object)"HTML") || Intrinsics.areEqual((Object)type, (Object)"URL");
    }

    @Override
    public void clear() {
    }

    private final void notifySize() {
        CefBrowser cefBrowser = this.jbBrowser.getCefBrowser();
        StringBuilder stringBuilder = new StringBuilder().append("var body = document.body,html = document.documentElement;var height = Math.max( body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight , html.offsetHeight );").append("window.");
        JBCefJSQuery jBCefJSQuery = this.heightJsCallback;
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"heightJsCallback");
        String string = stringBuilder.append(jBCefJSQuery.getFuncName()).append("({request: String(height)});").toString();
        CefBrowser cefBrowser2 = this.jbBrowser.getCefBrowser();
        Intrinsics.checkNotNullExpressionValue((Object)cefBrowser2, (String)"jbBrowser.cefBrowser");
        cefBrowser.executeJavaScript(string, cefBrowser2.getURL(), 0);
    }

    @Override
    public void addData(@NotNull String data, @NotNull String type) {
        boolean isUrl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean bl = isUrl = StringsKt.startsWith$default((String)data, (String)"file://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)data, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)data, (String)"https://", (boolean)false, (int)2, null);
        if (isUrl) {
            this.jbBrowser.loadURL(data);
        } else {
            this.jbBrowser.loadHTML("<head><style>" + GithubMarkdownCss.Companion.getCss() + " </style></head><body>" + data + "</body>");
        }
        this.jbBrowser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(this){
            final /* synthetic */ InlayOutputHtml this$0;

            public void onLoadingStateChange(@Nullable CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                InlayOutputHtml.access$notifySize(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        }, this.jbBrowser.getCefBrowser());
    }

    @Override
    public void scrollToTop() {
    }

    @Override
    @NotNull
    public String getCollapsedDescription() {
        return "html output";
    }

    @Override
    public void saveAs() {
        String title = VisualizationBundle.INSTANCE.message("inlay.action.export.as.txt.title", new Object[0]);
        String description = VisualizationBundle.INSTANCE.message("inlay.action.exports.range.csv.description", new Object[0]);
        this.saveWithFileChooser(title, description, new String[]{"txt"}, "output", (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(this){
            final /* synthetic */ InlayOutputHtml this$0;

            public final void invoke(@NotNull File destination) {
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                InlayOutputHtml.access$getSaveJsCallback$p(this.this$0).addHandler((Function)new Function<String, JBCefJSQuery.Response>(this, destination){
                    final /* synthetic */ saveAs.1 this$0;
                    final /* synthetic */ File $destination;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public JBCefJSQuery.Response apply(@NotNull String selection) {
                        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
                        Object object = this.$destination;
                        Charset charset = Charsets.UTF_8;
                        int n = 8192;
                        boolean bl = false;
                        Object object2 = object;
                        boolean bl2 = false;
                        Object object3 = object2;
                        boolean bl3 = false;
                        object3 = new FileOutputStream((File)object3);
                        bl3 = false;
                        object2 = new OutputStreamWriter((OutputStream)object3, charset);
                        bl2 = false;
                        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
                        boolean bl4 = false;
                        n = 0;
                        Throwable throwable = null;
                        try {
                            BufferedWriter out = (BufferedWriter)object;
                            boolean bl5 = false;
                            out.write(selection);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                        }
                        InlayOutputHtml.access$getSaveJsCallback$p(this.this$0.this$0).removeHandler((Function)this);
                        return new JBCefJSQuery.Response("OK");
                    }
                    {
                        this.this$0 = this$0;
                        this.$destination = $captured_local_variable$1;
                    }
                });
                CefBrowser cefBrowser = InlayOutputHtml.access$getJbBrowser$p(this.this$0).getCefBrowser();
                StringBuilder stringBuilder = new StringBuilder().append("window.");
                JBCefJSQuery jBCefJSQuery = InlayOutputHtml.access$getSaveJsCallback$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"saveJsCallback");
                String string = stringBuilder.append(jBCefJSQuery.getFuncName()).append("({request: window.getSelection().toString()})").toString();
                CefBrowser cefBrowser2 = InlayOutputHtml.access$getJbBrowser$p(this.this$0).getCefBrowser();
                Intrinsics.checkNotNullExpressionValue((Object)cefBrowser2, (String)"jbBrowser.cefBrowser");
                cefBrowser.executeJavaScript(string, cefBrowser2.getURL(), 0);
            }
            {
                this.this$0 = inlayOutputHtml;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public InlayOutputHtml(@NotNull Disposable parent, @NotNull Editor editor, @NotNull Function0<Unit> clearAction2) {
        void it;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(clearAction2, (String)"clearAction");
        super(parent, editor, clearAction2);
        JBCefBrowser jBCefBrowser = new JBCefBrowser();
        boolean bl = false;
        boolean bl2 = false;
        JBCefBrowser jBCefBrowser2 = jBCefBrowser;
        InlayOutputHtml inlayOutputHtml = this;
        boolean bl3 = false;
        Disposer.register((Disposable)parent, (Disposable)((Disposable)it));
        Unit unit = Unit.INSTANCE;
        inlayOutputHtml.jbBrowser = jBCefBrowser;
        this.heightJsCallback = JBCefJSQuery.create((JBCefBrowser)this.jbBrowser);
        this.saveJsCallback = JBCefJSQuery.create((JBCefBrowser)this.jbBrowser);
        JComponent jComponent = this.jbBrowser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"jbBrowser.component");
        MouseWheelUtils.INSTANCE.wrapMouseWheelListeners(jComponent, parent);
        this.heightJsCallback.addHandler(new Function(){

            public final JBCefJSQuery.Response apply(String it) {
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                String string2 = string;
                boolean bl = false;
                int height = Integer.parseInt(string2);
                if (height != height) {
                    height = height;
                    ModalityState modalityState$iv = null;
                    boolean $i$f$invokeLater = false;
                    Application application = ApplicationManager.getApplication();
                    Runnable runnable = new Runnable(this, height){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ int $height$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$height$inlined = n;
                        }

                        public final void run() {
                            boolean bl = false;
                            SwingUtilities.invokeLater(new Runnable(this){
                                final /* synthetic */ 1$$special$$inlined$invokeLater$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                public final void run() {
                                    block0: {
                                        Function1<Integer, Unit> function1 = this.this$0.this$0.this.getOnHeightCalculated();
                                        if (function1 == null) break block0;
                                        Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this.this$0.$height$inlined);
                                    }
                                }
                            });
                        }
                    };
                    ModalityState modalityState = ModalityState.defaultModalityState();
                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                    application.invokeLater(runnable, modalityState);
                }
                return new JBCefJSQuery.Response("OK");
            }
        });
        Disposer.register((Disposable)((Disposable)this.jbBrowser), (Disposable)((Disposable)this.heightJsCallback));
        this.getToolbarPane().setDataComponent(this.jbBrowser.getComponent());
    }

    public static final /* synthetic */ void access$notifySize(InlayOutputHtml $this) {
        $this.notifySize();
    }

    public static final /* synthetic */ JBCefJSQuery access$getSaveJsCallback$p(InlayOutputHtml $this) {
        return $this.saveJsCallback;
    }

    public static final /* synthetic */ JBCefBrowser access$getJbBrowser$p(InlayOutputHtml $this) {
        return $this.jbBrowser;
    }
}

