/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.datavis.r.inlays.table.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.RowFilter;
import org.intellij.datavis.r.inlays.table.filters.IFilter;
import org.intellij.datavis.r.inlays.table.filters.IFilterObserver;

public abstract class Filter
extends RowFilter
implements IFilter {
    private Set<IFilterObserver> observers = new HashSet<IFilterObserver>();
    private boolean enabled = true;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable != this.enabled) {
            this.enabled = enable;
            this.reportFilterUpdatedToObservers();
        }
    }

    @Override
    public void addFilterObserver(IFilterObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeFilterObserver(IFilterObserver observer) {
        this.observers.remove(observer);
    }

    public Set<IFilterObserver> getFilterObservers() {
        return new HashSet<IFilterObserver>(this.observers);
    }

    public void reportFilterUpdatedToObservers() {
        for (IFilterObserver obs : new ArrayList<IFilterObserver>(this.observers)) {
            obs.filterUpdated(this);
        }
    }
}

