/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellHighlighterRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "()V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "intellij.notebooks.visualization"})
final class NotebookCellHighlighterRenderer
implements CustomHighlighterRenderer {
    @NotNull
    public static final NotebookCellHighlighterRenderer INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        EditorImpl cfr_ignored_0 = (EditorImpl)editor;
        Graphics $this$use$iv = g.create();
        boolean $i$f$use = false;
        try {
            Graphics g2 = $this$use$iv;
            boolean bl = false;
            JScrollPane jScrollPane = ((EditorImpl)editor).getScrollPane();
            Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
            JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            Intrinsics.checkNotNullExpressionValue((Object)jScrollBar, (String)"editor.scrollPane.verticalScrollBar");
            int scrollbarWidth = jScrollBar.getWidth();
            Graphics graphics = g2;
            Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"g");
            Rectangle oldBounds = graphics.getClipBounds();
            ScrollingModelEx scrollingModelEx = ((EditorImpl)editor).getScrollingModel();
            Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"editor.scrollingModel");
            Rectangle rectangle = scrollingModelEx.getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"editor.scrollingModel.visibleArea");
            Rectangle visibleArea = rectangle;
            g2.setClip(visibleArea.x + visibleArea.width - scrollbarWidth, oldBounds.y, scrollbarWidth, oldBounds.height);
            EditorColorsScheme editorColorsScheme = ((EditorImpl)editor).getColorsScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
            g2.setColor(editorColorsScheme.getDefaultBackground());
            Rectangle rectangle2 = g2.getClipBounds();
            boolean bl2 = false;
            boolean bl3 = false;
            Rectangle $this$run = rectangle2;
            boolean bl4 = false;
            int fillX = ((EditorImpl)editor).getEditorKind() == EditorKind.DIFF && ((EditorImpl)editor).isMirrored() ? $this$run.x + 20 : $this$run.x;
            g2.fillRect(fillX, $this$run.y, $this$run.width, $this$run.height);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$use$iv.dispose();
        }
    }

    private NotebookCellHighlighterRenderer() {
    }

    static {
        NotebookCellHighlighterRenderer notebookCellHighlighterRenderer;
        INSTANCE = notebookCellHighlighterRenderer = new NotebookCellHighlighterRenderer();
    }
}

