/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.editor;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.notebooks.editor.InlaysChangedListener;
import org.jetbrains.plugins.notebooks.editor.NotebookCellEditorScrollingPositionKeeper;
import org.jetbrains.plugins.notebooks.editor.NotebookCellEditorScrollingPositionKeeperKt;
import org.jetbrains.plugins.notebooks.editor.NotebookCellHighlighterRenderer;
import org.jetbrains.plugins.notebooks.editor.NotebookCellInlayController;
import org.jetbrains.plugins.notebooks.editor.NotebookCellInlayManager;
import org.jetbrains.plugins.notebooks.editor.NotebookCellLines;
import org.jetbrains.plugins.notebooks.editor.NotebookCellLinesKt;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearance;
import org.jetbrains.plugins.notebooks.editor.NotebookEditorAppearanceProviderKt;
import org.jetbrains.plugins.notebooks.editor.UpdateInlaysTask;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 E2\u00020\u0001:\u0001EB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 H\u0002J\b\u0010!\u001a\u00020\u001dH\u0002J\u001e\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0007J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0$2\u0006\u0010*\u001a\u00020&H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010*\u001a\u00020&H\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\b\u00100\u001a\u00020\u001dH\u0002J\b\u00101\u001a\u00020\u001dH\u0002J\b\u00102\u001a\u00020\u001dH\u0002J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u0012042\u0006\u00105\u001a\u00020\u0019J\b\u00106\u001a\u00020\u001dH\u0002J\u0018\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u0019H\u0002J\u0010\u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020.H\u0002J\b\u0010;\u001a\u00020<H\u0002J\u000e\u0010=\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020&J\u0006\u0010>\u001a\u00020\u001dJ\u0010\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020&H\u0002J\u001e\u0010A\u001a\u00020\u001d2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00190$2\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010C\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020&J\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00190$*\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00020\u000e*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006F"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellInlayManager;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "changedListener", "Lorg/jetbrains/plugins/notebooks/editor/InlaysChangedListener;", "getChangedListener", "()Lorg/jetbrains/plugins/notebooks/editor/InlaysChangedListener;", "setChangedListener", "(Lorg/jetbrains/plugins/notebooks/editor/InlaysChangedListener;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "initialized", "", "inlays", "", "Lcom/intellij/openapi/editor/Inlay;", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellInlayController;", "notebookCellLines", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "viewportQueue", "shouldHaveHighlighter", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;", "getShouldHaveHighlighter", "(Lorg/jetbrains/plugins/notebooks/editor/NotebookCellLines$Interval;)Z", "addDocumentListener", "", "addHighlighters", "intervals", "", "addViewportChangeListener", "ensureInlaysAndHighlightersExist", "matchingCellsBeforeChange", "", "logicalLines", "Lkotlin/ranges/IntRange;", "getInlays", "getMatchingHighlightersForLines", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "lines", "getMatchingInlaysForLines", "getMatchingInlaysForOffsets", "startOffset", "", "endOffset", "handleRefreshedDocument", "initialize", "inlaysChanged", "inlaysForInterval", "", "interval", "refreshHighlightersLookAndFeel", "rememberController", "controller", "saturateLine", "line", "textAttributesForHighlighter", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "update", "updateAllImmediately", "updateConsequentInlays", "interestingRange", "updateControllers", "matchingCells", "updateImmediately", "getMatchingCells", "Companion", "intellij.notebooks.visualization"})
public final class NotebookCellInlayManager {
    private final Map<Inlay<?>, NotebookCellInlayController> inlays;
    private final NotebookCellLines notebookCellLines;
    private final MergingUpdateQueue viewportQueue;
    private final MergingUpdateQueue updateQueue;
    private boolean initialized;
    @Nullable
    private InlaysChangedListener changedListener;
    @NotNull
    private final EditorImpl editor;
    private static final Logger LOG;
    private static final Key<NotebookCellInlayManager> key;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final InlaysChangedListener getChangedListener() {
        return this.changedListener;
    }

    public final void setChangedListener(@Nullable InlaysChangedListener inlaysChangedListener) {
        this.changedListener = inlaysChangedListener;
    }

    @NotNull
    public final Iterable<NotebookCellInlayController> inlaysForInterval(@NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.getMatchingInlaysForLines(interval.getLines());
    }

    public final void updateImmediately(@NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        if (this.initialized) {
            this.updateConsequentInlays(lines);
        }
    }

    public final void updateAllImmediately() {
        if (this.initialized) {
            this.updateQueue.cancelAllUpdates();
            int n = 0;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
            this.updateConsequentInlays(new IntRange(n, documentEx.getLineCount()));
        }
    }

    public final void update(@NotNull IntRange lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        this.updateQueue.queue((Update)new UpdateInlaysTask(this, lines));
    }

    private final void addViewportChangeListener() {
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        jScrollPane.getViewport().addChangeListener(new ChangeListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;

            public final void stateChanged(ChangeEvent it) {
                NotebookCellInlayManager.access$getViewportQueue$p(this.this$0).queue(new Update(this, "Viewport change"){
                    final /* synthetic */ addViewportChangeListener.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public void run() {
                        if (Disposer.isDisposed((Disposable)this.this$0.this$0.getEditor().getDisposable())) {
                            return;
                        }
                        Map map = NotebookCellInlayManager.access$getInlays$p(this.this$0.this$0);
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void inlay;
                            Map.Entry<K, V> entry;
                            Map.Entry<K, V> entry2 = entry = iterator.next();
                            boolean bl2 = false;
                            map = (Inlay)entry2.getKey();
                            entry2 = entry;
                            bl2 = false;
                            NotebookCellInlayController controller = (NotebookCellInlayController)entry2.getValue();
                            controller.onViewportChange();
                            Object object = inlay.getRenderer();
                            if (object == null) continue;
                            EditorCustomElementRenderer $this$castSafelyTo$iv = object;
                            boolean $i$f$castSafelyTo = false;
                            EditorCustomElementRenderer editorCustomElementRenderer = $this$castSafelyTo$iv;
                            if (!(editorCustomElementRenderer instanceof JComponent)) {
                                editorCustomElementRenderer = null;
                            }
                            if ((object = (JComponent)editorCustomElementRenderer) == null) continue;
                            ((JComponent)object).updateUI();
                        }
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1);
                    }
                });
            }
            {
                this.this$0 = notebookCellInlayManager;
            }
        });
    }

    private final void initialize() {
        this.editor.putUserData(key, (Object)this);
        this.handleRefreshedDocument();
        this.addDocumentListener();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        MessageBusConnection messageBusConnection = application.getMessageBus().connect(this.editor.getDisposable());
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"ApplicationManager.getAp\u2026onnect(editor.disposable)");
        MessageBusConnection appMessageBus = messageBusConnection;
        appMessageBus.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;

            public final void globalSchemeChange(@Nullable EditorColorsScheme it) {
                NotebookCellInlayManager.access$refreshHighlightersLookAndFeel(this.this$0);
            }
            {
                this.this$0 = notebookCellInlayManager;
            }
        });
        appMessageBus.subscribe(LafManagerListener.TOPIC, (Object)new LafManagerListener(this){
            final /* synthetic */ NotebookCellInlayManager this$0;

            public final void lookAndFeelChanged(@NotNull LafManager it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NotebookCellInlayManager.access$refreshHighlightersLookAndFeel(this.this$0);
            }
            {
                this.this$0 = notebookCellInlayManager;
            }
        });
        this.addViewportChangeListener();
        this.initialized = true;
    }

    private final void refreshHighlightersLookAndFeel() {
        MarkupModelEx markupModelEx = this.editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"editor.markupModel");
        RangeHighlighter[] rangeHighlighterArray = markupModelEx.getAllHighlighters();
        int n = rangeHighlighterArray.length;
        for (int i = 0; i < n; ++i) {
            RangeHighlighter highlighter;
            RangeHighlighter rangeHighlighter = highlighter = rangeHighlighterArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"highlighter");
            if (rangeHighlighter.getCustomRenderer() != NotebookCellHighlighterRenderer.INSTANCE) continue;
            RangeHighlighter rangeHighlighter2 = highlighter;
            if (!(rangeHighlighter2 instanceof RangeHighlighterEx)) {
                rangeHighlighter2 = null;
            }
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)rangeHighlighter2;
            if (rangeHighlighterEx == null) continue;
            rangeHighlighterEx.setTextAttributes(this.textAttributesForHighlighter());
        }
    }

    private final void handleRefreshedDocument() {
        List list = NotebookCellInlayController.Factory.EP_NAME.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"NotebookCellInlayControl\u2026ory.EP_NAME.extensionList");
        List factories = list;
        for (NotebookCellLines.Interval interval : this.notebookCellLines.getIntervals()) {
            for (NotebookCellInlayController.Factory factory : factories) {
                NotebookCellInlayController controller = factory.compute(this.editor, CollectionsKt.emptyList(), this.notebookCellLines.getIntervals().listIterator(interval.getOrdinal()));
                if (controller == null) continue;
                this.rememberController(controller, interval);
            }
        }
        this.addHighlighters((Collection<NotebookCellLines.Interval>)this.notebookCellLines.getIntervals());
        this.inlaysChanged();
    }

    private final void addDocumentListener() {
        DocumentListener documentListener2 = new DocumentListener(this){
            private List<NotebookCellLines.Interval> matchingCellsBeforeChange;
            private boolean isBulkModeEnabled;
            final /* synthetic */ NotebookCellInlayManager this$0;

            private final IntRange interestingLogicalLines(Document document, int startOffset, int length) {
                int end = startOffset + length <= document.getTextLength() ? document.getLineNumber(startOffset + length) : document.getLineCount() + 1;
                int n = document.getLineNumber(startOffset);
                return new IntRange(n, end);
            }

            public void bulkUpdateStarting(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                this.isBulkModeEnabled = true;
                this.matchingCellsBeforeChange = NotebookCellInlayManager.access$getMatchingCells(this.this$0, NotebookCellInlayManager.access$getNotebookCellLines$p(this.this$0), RangesKt.until((int)0, (int)document.getLineCount()));
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.isBulkModeEnabled) {
                    return;
                }
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
                Document document2 = document;
                IntRange logicalLines = this.interestingLogicalLines(document2, event.getOffset(), event.getOldLength());
                this.matchingCellsBeforeChange = NotebookCellInlayManager.access$getMatchingCells(this.this$0, NotebookCellInlayManager.access$getNotebookCellLines$p(this.this$0), logicalLines);
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.isBulkModeEnabled) {
                    return;
                }
                Document document = event.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
                IntRange logicalLines = this.interestingLogicalLines(document, event.getOffset(), event.getNewLength());
                NotebookCellInlayManager.access$ensureInlaysAndHighlightersExist(this.this$0, this.matchingCellsBeforeChange, logicalLines);
            }

            public void bulkUpdateFinished(@NotNull Document document) {
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                this.isBulkModeEnabled = false;
                NotebookCellInlayManager.access$ensureInlaysAndHighlightersExist(this.this$0, this.matchingCellsBeforeChange, RangesKt.until((int)0, (int)document.getLineCount()));
            }
            {
                this.this$0 = this$0;
                this.matchingCellsBeforeChange = CollectionsKt.emptyList();
            }
        };
        this.editor.getDocument().addDocumentListener(documentListener2, this.editor.getDisposable());
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureInlaysAndHighlightersExist(List<NotebookCellLines.Interval> matchingCellsBeforeChange, IntRange logicalLines) {
        IntRange intRange;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = matchingCellsBeforeChange;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IntRange intRange2 = it.getLines();
            collection.add(intRange2);
        }
        iterable = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable it = iterable;
        boolean bl3 = false;
        Collection collection = (Collection)it;
        int n = 0;
        Iterable iterable2 = !collection.isEmpty() ? iterable : null;
        if (iterable2 != null) {
            iterable = iterable2;
            bl = false;
            bl2 = false;
            it = iterable;
            boolean bl4 = false;
            int n2 = logicalLines.getFirst();
            n = ((IntRange)CollectionsKt.first((List)it)).getFirst();
            boolean bl5 = false;
            int n3 = n2 = Math.min(n2, n);
            n2 = ((IntRange)CollectionsKt.last((List)it)).getLast();
            n = logicalLines.getLast();
            bl5 = false;
            IntRange intRange3 = new IntRange(n3, Math.max(n2, n));
            intRange = intRange3;
        } else {
            intRange = logicalLines;
        }
        IntRange interestingRange = intRange;
        this.updateConsequentInlays(interestingRange);
    }

    private final void inlaysChanged() {
        block0: {
            InlaysChangedListener inlaysChangedListener = this.changedListener;
            if (inlaysChangedListener == null) break block0;
            inlaysChangedListener.inlaysChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateConsequentInlays(IntRange interestingRange) {
        void destination$iv;
        void $this$mapTo$iv;
        Object object;
        Map map;
        void $this$associateByTo$iv;
        IntRange intRange;
        NotebookCellEditorScrollingPositionKeeper notebookCellEditorScrollingPositionKeeper = NotebookCellEditorScrollingPositionKeeperKt.getNotebookCellEditorScrollingPositionKeeper((Editor)this.editor);
        if (notebookCellEditorScrollingPositionKeeper != null) {
            notebookCellEditorScrollingPositionKeeper.saveSelectedCellPosition();
        }
        List<NotebookCellLines.Interval> matchingIntervals = this.getMatchingCells(this.notebookCellLines, interestingRange);
        Collection collection = matchingIntervals;
        boolean bl = false;
        if (!collection.isEmpty()) {
            int n = ((NotebookCellLines.Interval)CollectionsKt.first(matchingIntervals)).getLines().getFirst();
            intRange = new IntRange(n, ((NotebookCellLines.Interval)CollectionsKt.last(matchingIntervals)).getLines().getLast());
        } else {
            intRange = interestingRange;
        }
        IntRange fullInterestingRange = intRange;
        List<RangeHighlighterEx> existingHighlighters = this.getMatchingHighlightersForLines(fullInterestingRange);
        Iterable iterable = matchingIntervals;
        Object destination$iv2 = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            void it;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)element$iv;
            map = destination$iv2;
            boolean bl2 = false;
            object = it.getLines();
            map.put(object, element$iv);
        }
        HashMap intervalsToAddHighlightersFor = (HashMap)destination$iv2;
        for (RangeHighlighterEx highlighter : existingHighlighters) {
            DocumentEx documentEx = this.editor.getDocument();
            boolean element$iv = false;
            boolean it = false;
            DocumentEx $this$run = documentEx;
            boolean bl3 = false;
            int n = $this$run.getLineNumber(highlighter.getStartOffset());
            IntRange lines22 = new IntRange(n, $this$run.getLineNumber(highlighter.getEndOffset()));
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)intervalsToAddHighlightersFor.remove(lines22);
            if (interval != null && this.getShouldHaveHighlighter(interval)) continue;
            this.editor.getMarkupModel().removeHighlighter((RangeHighlighter)highlighter);
        }
        Collection<NotebookCellLines.Interval> collection2 = intervalsToAddHighlightersFor.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"intervalsToAddHighlightersFor.values");
        this.addHighlighters(collection2);
        destination$iv2 = this.getMatchingInlaysForLines(fullInterestingRange);
        boolean lines22 = false;
        Collection lines22 = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            NotebookCellInlayController $this$run = (NotebookCellInlayController)item$iv;
            map = destination$iv;
            boolean bl4 = false;
            object = TuplesKt.to((Object)this.editor.getDocument().getLineNumber(it.getInlay().getOffset()), (Object)it);
            map.add(object);
        }
        List allMatchingInlays = (List)destination$iv;
        List list = NotebookCellInlayController.Factory.EP_NAME.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"NotebookCellInlayControl\u2026ory.EP_NAME.extensionList");
        List allFactories = list;
        for (NotebookCellLines.Interval interval : matchingIntervals) {
            Iterable $this$associateWith$iv = allFactories;
            boolean $i$f$associateWith = false;
            Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv22 = $this$associateWith$iv;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv22) {
                NotebookCellInlayController.Factory factory = (NotebookCellInlayController.Factory)element$iv$iv;
                object = element$iv$iv;
                map = (Map)result$iv;
                boolean bl5 = false;
                SmartList smartList = new SmartList();
                map.put(object, smartList);
            }
            Map seenControllersByFactory = (Map)result$iv;
            allMatchingInlays.removeIf(new Predicate(interval, seenControllersByFactory){
                final /* synthetic */ NotebookCellLines.Interval $interval;
                final /* synthetic */ Map $seenControllersByFactory;

                /*
                 * WARNING - void declaration
                 */
                public final boolean test(@NotNull Pair<Integer, ? extends NotebookCellInlayController> $dstr$inlayLine$controller) {
                    boolean bl;
                    void inlayLine;
                    Intrinsics.checkNotNullParameter($dstr$inlayLine$controller, (String)"<name for destructuring parameter 0>");
                    int n = ((Number)$dstr$inlayLine$controller.component1()).intValue();
                    NotebookCellInlayController controller = (NotebookCellInlayController)$dstr$inlayLine$controller.component2();
                    if (this.$interval.getLines().contains((int)inlayLine)) {
                        List list = (List)this.$seenControllersByFactory.get(controller.getFactory());
                        if (list != null) {
                            list.add(controller);
                        }
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$interval = interval;
                    this.$seenControllersByFactory = map;
                }
            });
            result$iv = seenControllersByFactory;
            boolean $this$associateWithTo$iv$iv22 = false;
            Iterator iterator = result$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void factory;
                NotebookCellInlayController actualController;
                Map.Entry entry;
                Map.Entry $i$f$associateWithTo2 = entry = iterator.next();
                boolean bl6 = false;
                result$iv = (NotebookCellInlayController.Factory)$i$f$associateWithTo2.getKey();
                $i$f$associateWithTo2 = entry;
                bl6 = false;
                List controllers = (List)$i$f$associateWithTo2.getValue();
                NotebookCellInlayController notebookCellInlayController = actualController = !Disposer.isDisposed((Disposable)this.editor.getDisposable()) ? factory.compute(this.editor, controllers, this.notebookCellLines.getIntervals().listIterator(interval.getOrdinal())) : null;
                if (actualController != null) {
                    this.rememberController(actualController, interval);
                }
                for (NotebookCellInlayController oldController : controllers) {
                    if (!(Intrinsics.areEqual((Object)oldController, (Object)actualController) ^ true)) continue;
                    Disposer.dispose((Disposable)((Disposable)oldController.getInlay()), (boolean)false);
                }
            }
        }
        for (Pair pair : allMatchingInlays) {
            NotebookCellInlayController controller = (NotebookCellInlayController)pair.component2();
            Disposer.dispose((Disposable)((Disposable)controller.getInlay()), (boolean)false);
        }
        this.inlaysChanged();
    }

    private final void rememberController(NotebookCellInlayController controller, NotebookCellLines.Interval interval) {
        Inlay<?> inlay = controller.getInlay();
        Object $this$castSafelyTo$iv = inlay.getRenderer();
        boolean $i$f$castSafelyTo = false;
        Object object = $this$castSafelyTo$iv;
        if (!(object instanceof JComponent)) {
            object = null;
        }
        JComponent jComponent = (JComponent)object;
        if (jComponent != null) {
            $this$castSafelyTo$iv = jComponent;
            boolean bl = false;
            boolean bl2 = false;
            Object component = $this$castSafelyTo$iv;
            boolean bl3 = false;
            ((JComponent)component).putClientProperty("DataProvider", new DataProvider((JComponent)component, this, interval){
                final /* synthetic */ JComponent $component;
                final /* synthetic */ NotebookCellInlayManager this$0;
                final /* synthetic */ NotebookCellLines.Interval $interval$inlined;
                {
                    this.$component = jComponent;
                    this.this$0 = notebookCellInlayManager;
                    this.$interval$inlined = interval;
                }

                @Nullable
                public final Object getData(@NotNull String key) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    String string = key;
                    if (Intrinsics.areEqual((Object)string, (Object)NotebookCellLinesKt.getNOTEBOOK_CELL_LINES_INTERVAL_DATA_KEY().getName())) {
                        object = this.$interval$inlined;
                    } else {
                        DataKey dataKey = PlatformCoreDataKeys.CONTEXT_COMPONENT;
                        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PlatformCoreDataKeys.CONTEXT_COMPONENT");
                        if (Intrinsics.areEqual((Object)string, (Object)dataKey.getName())) {
                            object = this.$component;
                        } else {
                            DataKey dataKey2 = PlatformDataKeys.EDITOR;
                            Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"PlatformDataKeys.EDITOR");
                            object = Intrinsics.areEqual((Object)string, (Object)dataKey2.getName()) ? this.this$0.getEditor() : null;
                        }
                    }
                    return object;
                }
            });
        }
        if (this.inlays.put(inlay, controller) != controller) {
            Disposable disposable2 = new Disposable(this, inlay){
                final /* synthetic */ NotebookCellInlayManager this$0;
                final /* synthetic */ Inlay $inlay;

                public final void dispose() {
                    EditorCustomElementRenderer $this$castSafelyTo$iv = this.$inlay.getRenderer();
                    boolean $i$f$castSafelyTo = false;
                    EditorCustomElementRenderer editorCustomElementRenderer = $this$castSafelyTo$iv;
                    if (!(editorCustomElementRenderer instanceof JComponent)) {
                        editorCustomElementRenderer = null;
                    }
                    JComponent jComponent = (JComponent)editorCustomElementRenderer;
                    if (jComponent != null) {
                        jComponent.putClientProperty("DataProvider", null);
                    }
                    NotebookCellInlayManager.access$getInlays$p(this.this$0).remove(this.$inlay);
                }
                {
                    this.this$0 = notebookCellInlayManager;
                    this.$inlay = inlay;
                }
            };
            if (Disposer.isDisposed((Disposable)((Disposable)inlay))) {
                disposable2.dispose();
            } else {
                Disposer.register((Disposable)((Disposable)inlay), (Disposable)disposable2);
            }
        }
    }

    private final List<RangeHighlighterEx> getMatchingHighlightersForLines(IntRange lines) {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List list2 = list;
        boolean bl4 = false;
        int startOffset = this.editor.getDocument().getLineStartOffset(this.saturateLine(lines.getFirst()));
        int endOffset = this.editor.getDocument().getLineEndOffset(this.saturateLine(lines.getLast()));
        this.editor.getMarkupModel().processRangeHighlightersOverlappingWith(startOffset, endOffset, new Processor(list2){
            final /* synthetic */ List $list;

            public final boolean process(RangeHighlighterEx it) {
                RangeHighlighterEx rangeHighlighterEx = it;
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"it");
                if (rangeHighlighterEx.getCustomRenderer() == NotebookCellHighlighterRenderer.INSTANCE) {
                    this.$list.add(it);
                }
                return true;
            }
            {
                this.$list = list;
            }
        });
        return list;
    }

    private final List<NotebookCellInlayController> getMatchingInlaysForLines(IntRange lines) {
        return this.getMatchingInlaysForOffsets(this.editor.getDocument().getLineStartOffset(this.saturateLine(lines.getFirst())), this.editor.getDocument().getLineEndOffset(this.saturateLine(lines.getLast())));
    }

    private final int saturateLine(int line) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        return RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)line, (int)(documentEx.getLineCount() - 1)), (int)0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<NotebookCellInlayController> getMatchingInlaysForOffsets(int startOffset, int endOffset) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list = this.editor.getInlayModel().getBlockElementsInRange(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"editor.inlayModel\n      \u2026e(startOffset, endOffset)");
        Iterable iterable = list;
        Map<Inlay<?>, NotebookCellInlayController> map = this.inlays;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NotebookCellInlayController notebookCellInlayController;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Inlay p1 = (Inlay)element$iv$iv;
            boolean bl2 = false;
            if (map.get(p1) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            NotebookCellInlayController it$iv$iv = notebookCellInlayController;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean getShouldHaveHighlighter(NotebookCellLines.Interval $this$shouldHaveHighlighter) {
        return $this$shouldHaveHighlighter.getType() == NotebookCellLines.CellType.CODE;
    }

    private final void addHighlighters(Collection<NotebookCellLines.Interval> intervals) {
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
        DocumentEx document = documentEx;
        for (NotebookCellLines.Interval interval : intervals) {
            RangeHighlighter highlighter;
            if (!this.getShouldHaveHighlighter(interval)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)this.editor.getMarkupModel().addRangeHighlighter(document.getLineStartOffset(interval.getLines().getFirst()), document.getLineEndOffset(interval.getLines().getLast()), 900, this.textAttributesForHighlighter(), HighlighterTargetArea.LINES_IN_RANGE), (String)"editor.markupModel.addRa\u2026.LINES_IN_RANGE\n        )");
            highlighter.setCustomRenderer((CustomHighlighterRenderer)NotebookCellHighlighterRenderer.INSTANCE);
        }
    }

    private final TextAttributes textAttributesForHighlighter() {
        TextAttributes textAttributes = new TextAttributes();
        boolean bl = false;
        boolean bl2 = false;
        TextAttributes $this$apply = textAttributes;
        boolean bl3 = false;
        NotebookEditorAppearance notebookEditorAppearance = NotebookEditorAppearanceProviderKt.getNotebookAppearance((Editor)this.editor);
        EditorColorsScheme editorColorsScheme = this.editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
        $this$apply.setBackgroundColor(notebookEditorAppearance.getCodeCellBackground(editorColorsScheme));
        return textAttributes;
    }

    private final List<NotebookCellLines.Interval> getMatchingCells(NotebookCellLines $this$getMatchingCells, IntRange logicalLines) {
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List result = list;
        boolean bl4 = false;
        ListIterator<NotebookCellLines.Interval> iterator = $this$getMatchingCells.intervalsIterator(logicalLines.getFirst());
        if (iterator.hasPrevious()) {
            iterator.previous();
        }
        Iterator iterator2 = iterator;
        boolean bl5 = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)iterator3.next();
            result.add(interval);
            if (interval.getLines().getFirst() <= logicalLines.getLast()) continue;
            break;
        }
        return list;
    }

    @TestOnly
    @NotNull
    public final Map<Inlay<?>, NotebookCellInlayController> getInlays() {
        return this.inlays;
    }

    @TestOnly
    public final void updateControllers(@NotNull List<NotebookCellLines.Interval> matchingCells, @NotNull IntRange logicalLines) {
        Intrinsics.checkNotNullParameter(matchingCells, (String)"matchingCells");
        Intrinsics.checkNotNullParameter((Object)logicalLines, (String)"logicalLines");
        this.ensureInlaysAndHighlightersExist(matchingCells, logicalLines);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    private NotebookCellInlayManager(EditorImpl editor) {
        this.editor = editor;
        this.inlays = new HashMap();
        this.notebookCellLines = NotebookCellLines.Companion.get((Editor)this.editor);
        this.viewportQueue = new MergingUpdateQueue("NotebookCellInlayManager Viewport Update", 100, true, null, this.editor.getDisposable(), null, true);
        this.updateQueue = new MergingUpdateQueue("NotebookCellInlayManager Interval Update", 20, true, null, this.editor.getDisposable(), null, true);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NotebookCellInlayManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        Key key = Key.create((String)NotebookCellInlayManager.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<NotebookCellI\u2026Manager::class.java.name)");
        NotebookCellInlayManager.key = key;
    }

    public static final /* synthetic */ MergingUpdateQueue access$getViewportQueue$p(NotebookCellInlayManager $this) {
        return $this.viewportQueue;
    }

    public static final /* synthetic */ Map access$getInlays$p(NotebookCellInlayManager $this) {
        return $this.inlays;
    }

    public static final /* synthetic */ void access$refreshHighlightersLookAndFeel(NotebookCellInlayManager $this) {
        $this.refreshHighlightersLookAndFeel();
    }

    public static final /* synthetic */ List access$getMatchingCells(NotebookCellInlayManager $this, NotebookCellLines $this$access_u24getMatchingCells, IntRange logicalLines) {
        return $this.getMatchingCells($this$access_u24getMatchingCells, logicalLines);
    }

    public static final /* synthetic */ NotebookCellLines access$getNotebookCellLines$p(NotebookCellInlayManager $this) {
        return $this.notebookCellLines;
    }

    public static final /* synthetic */ void access$ensureInlaysAndHighlightersExist(NotebookCellInlayManager $this, List matchingCellsBeforeChange, IntRange logicalLines) {
        $this.ensureInlaysAndHighlightersExist(matchingCellsBeforeChange, logicalLines);
    }

    public /* synthetic */ NotebookCellInlayManager(EditorImpl editor, DefaultConstructorMarker $constructor_marker) {
        this(editor);
    }

    @JvmStatic
    public static final void install(@NotNull EditorImpl editor) {
        Companion.install(editor);
    }

    @JvmStatic
    @Nullable
    public static final NotebookCellInlayManager get(@NotNull Editor editor) {
        return Companion.get(editor);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000fH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/notebooks/editor/NotebookCellInlayManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "key", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/notebooks/editor/NotebookCellInlayManager;", "kotlin.jvm.PlatformType", "get", "editor", "Lcom/intellij/openapi/editor/Editor;", "install", "", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.notebooks.visualization"})
    public static final class Companion {
        @JvmStatic
        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            new NotebookCellInlayManager(editor, null).initialize();
        }

        @JvmStatic
        @Nullable
        public final NotebookCellInlayManager get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (NotebookCellInlayManager)key.get((UserDataHolder)editor);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

